# Copyright (c) 2020 INFORM GmbH. All rights reserverd. 
# This copyright notice applies to the current file and all its outputs. 

import random
random.seed(42)

# Parameters of the generator
iNoArticles = 1000
iNoOrders = 100000
lDimensionsOfPallet = [120,80,160]
hlDimensionsOfBoxType = {
                        "B0" : (20,10,10),
                        "B1" : (20,20,10),
                        "B2" : (20,20,20),
                        "B3" : (20,40,20),
                        "B4" : (20,40,40),
                        "B5" : (30,40,40),
                        "B6" : (40,40,40),
                        "B7" : (60,40,40)
                        }

# Generate dimensions of articles randomly
hlDimensionsOfArticle = {}
for i in range(1,iNoArticles+1):
    hlDimensionsOfArticle["A"+str(i)] = ( random.choices([5,8,10,12,15,20], [0.01,0.09,0.4,0.2,0.1,0.2])[0],
                                          random.choices([5,8,10,12,15,20], [0.01,0.09,0.4,0.2,0.1,0.2])[0],
                                          random.choices([5,8,10,12,15,20], [0.01,0.09,0.4,0.2,0.1,0.2])[0] )

# Generate weight according to random density
hWeightOfArticle = {}
hDensityOfArticle = {}
for a in hlDimensionsOfArticle:
    fDensity = random.choices([0.01,0.1,0.2,0.5], weights=[0.1,0.4,0.3,0.2])[0]
    hWeightOfArticle[a] = int(hlDimensionsOfArticle[a][0]*hlDimensionsOfArticle[a][1]*hlDimensionsOfArticle[a][2]*fDensity)

# Generate for every order a random set of articles
hhNumberOfArticlesOfOrder = {}
for i in range(iNoOrders):
    hhNumberOfArticlesOfOrder["O"+str(i)] = {}
    # Between 1 and 10 different articles per order
    iNoOfArticles = random.randint(1,10)
    # Choose a random subset of articles for order
    sArticlesOfOrder = random.sample(hlDimensionsOfArticle.keys(), iNoOfArticles)
    for a in sArticlesOfOrder:
        # Number of articles in order is a random between 1 and 10
        hhNumberOfArticlesOfOrder["O"+str(i)][a] = random.randint(1,10)

def test_not_empty():
    assert hlDimensionsOfArticle
    assert hlDimensionsOfBoxType
    assert hWeightOfArticle
    assert hDensityOfArticle

print("Order ID;;;;;;Article ID;Article Name;Length (cm);Width (cm);Height (cm);Weight (g);Units")
for o in hhNumberOfArticlesOfOrder:
    for a in hhNumberOfArticlesOfOrder[o]:
        print(o,";;;;;;",a,";",a,";",hlDimensionsOfArticle[a][0],";",hlDimensionsOfArticle[a][1],";",hlDimensionsOfArticle[a][2],";",hWeightOfArticle[a],";",hhNumberOfArticlesOfOrder[o][a])
