/*
**  bifb_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/07/22.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIFB/A, as mechanically as possible.
*/


// #include <stddef.h>
#include <stdio.h>

#include "bif_a.h"
#include "bif_m.h"
#include "bif7b_a.h"
//#include "bifdp_a.h"
#include "bifst_a.h"	/* for break_pressed() */
#include "bifb_a.h"



/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
03640 	FCC 'EMIT'
03650 	FCB 4
03660 	FCB MFORE
03670 	FDB DLITER-CFAOFF
03680 	FDB BIF+2
03690 	FDB DUP-CFAOFF
03700 	FDB ENCLOS-CFAOFF
*/
static character_t sEMIT[] = "\x4" "EMIT";
definition_header_s hEMIT =	
{	{ (natural_t) sEMIT },
	{ 0 },
	{ (natural_t) &hDLITER },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDUP },
	{ (natural_t) &hENCLOS },
	{ (natural_t) EMIT }
};
/*
03705 * output using rom CHROUT: redirectable to printer
03710 EMIT	PULU D
03720 	TFR B,A
03730 	CLRB
03740 	PSHS Y,U,DP
03750 	TFR B,DP
03760 	JSR [$A002]
03770 	PULS Y,U,DP
03780 	NEXT
03790 *
*/
void EMIT(void)	/* Temporary code to just get output, for now. */
{	/* Need some way to issue a warning when character_t is not char or unsigned char.
	// Or, perhaps, a way to automagically compile it to output the right size.
	// That, in addition to the issues of stdout vs. stderr, vs. redirection.
	*/
	char outch = (char) ( * SP++ ).integer;
	fputc( outch, standardOutput );
}


/* Strictly local macro for filtering break key presses: */
#define KEYRfilter( flag, key )	( ( (flag) == '\x03' ) ? ( ~0xff | ( (flag) & 0xff ) ) : (key) )
/* Feels like a hack, it's late at night. */

/*
03800 	FCC 'KEY'
03810 	FCB 3
03820 	FCB MFORE
03830 	FDB EMIT-CFAOFF
03840 	FDB BIF+2
03850 	FDB IN-CFAOFF
03860 	FDB LIMIT-CFAOFF
*/
static character_t sKEY[] = "\x3" "KEY";
definition_header_s hKEY =	
{	{ (natural_t) sKEY },
	{ 0 },
	{ (natural_t) &hEMIT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hIN },
	{ (natural_t) &hLIMIT },
	{ (natural_t) KEY }
};
/*
03870 * wait for key from POLCAT
03880 KEY	PSHS Y,U,DP
03890 	CLRB
03895 	LDA #$CF a cursor
03900 	TFR B,DP
03901 	SETDP 0
03904 	LDX <$88 locate
03906 	LDB ,X save
03908 	STA ,X
03910 	JSR [$A000]
03920 	BEQ *-4
03925 	STB ,X restore
03930 KEYR	CLRB
03932 	CMPA #3 break key
03934 	BNE *+3
03936 	COMB
03938 	EXG A,B
03940 	PULS Y,U,DP
03942 	SETDP VDP
03945 	PSHU D
03950 	NEXT
03960 *
*/
void KEY(void)	/* Temporary code to just get input, for now. */
{	/* See the notes on EMIT. */
	/* Also, there is no way to parallel the Color Computer 6809 code, so approximate effect. */
	int inch = fgetc( standardInput );
	( * --SP ).sinteger = KEYRfilter( inch, inch );
}


/*
03970 	FCC '?TERMINAL'
03980 	FCB 9
03990 	FCB MFORE
04000 	FDB KEY-CFAOFF
04010 	FDB BIF+2
04020 	FDB QSTACK-CFAOFF
04030 	FDB 0
*/
static character_t sQTERM[] = "\x9" "?TERMINAL";
definition_header_s hQTERM =	
{	{ (natural_t) sQTERM },
	{ 0 },
	{ (natural_t) &hKEY },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hQSTACK },
	{ 0 },
	{ (natural_t) QTERM }
};
/*
04040 * check break key using POLCAT
04050 QTERM	PSHS Y,U,DP
04060 	CLRB
04070 	TFR B,DP
04080 	JSR [$A000]
04100 	BRA KEYR
04140 *
*/
void QTERM(void)
{	/* See the notes on KEY. */
	( * --SP ).sinteger = KEYRfilter( break_pressed(), 0 );
}


/*
04150 	FCC 'CR'
04160 	FCB 2
04170 	FCB MFORE
04180 	FDB QTERM-CFAOFF
04190 	FDB BIF+2
04200 	FDB COUNT-CFAOFF
04210 	FDB 0
*/
static character_t sCR[] = "\x2" "CR";
definition_header_s hCR =	
{	{ (natural_t) sCR },
	{ 0 },
	{ (natural_t) &hQTERM },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hCOUNT },
	{ 0 },
	{ (natural_t) CR }
};
/*
04220 CR	LDB #$0D
04230 	BRA EMIT+2
04240 *
*/
void CR(void)
{	( * --SP ).integer = '\n';
	EMIT();
}


/*
04250 	FCC '(;CODE)'
04260 	FCB MCOMP.OR.7
04270 	FCB MFORE
04280 	FDB CR-CFAOFF
04290 	FDB BIF+2
04300 	FDB 0
04310 	FDB 0
*/
static character_t sXSCODE[] = "\x7" "(;CODE)";
definition_header_s hXSCODE =	
{	{ (natural_t) sXSCODE },
	{ MCOMP },
	{ (natural_t) &hCR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XSCODE }
};
/*
04320 XSCODE	LDX <UP
04330 	LDX UCURR,X being defined
04340 	LEAX CFAOFF,X
04350 	LDA AJSR,PCR
04360 	STA ,X+
04370 	STY ,X++ code address
04380 	PULS Y un-nest
04390 	NEXT
04400 * parameters are 3 bytes beyond CFA
04410 AJSR	JSR >0 to be compiled
04420 *
*/
/* Nothing we can do about AJSR at this point, or, at least, nothing we want to do about it in C. 
// *** Probably ought to flag this as unavailable.
*/
void XSCODE(void)
{	definition_header_s * latest = UP.task->lastDefined.definitionp;
	latest->parameterLink[ 0 ] = ( W.definitionp )->parameterLink[ 1 ];	/* Must already be allocated. */
	SEMIS();
	/* Get the parameter[ 1 ] from executing definition and store it in the cfa -- parameter[ 0 ] of the latest. */
}


/* Memory for switching output to a log/pseudo-print file.
// (Use a file instead of actually attempting to dump what could be log directly to a printer.)
*/
/* static FILE * printLog = NULL; Really don't want to try to deal with another function overwriting standardOutput. */
static FILE * standardOutputMemory = NULL;

/* But I may want to eventually handle setting the path to the printer log file.
*/
static char PrinterLogFilePath[] = "~/BIFPrinterLog";

/*
04440 DEVNUM	EQU $6F coco ROM constant
04450 	FCC '>PRT'
04460 	FCB 4
04470 	FCB MFORE
04480 	FDB XSCODE-CFAOFF
04490 	FDB BIF+2
04500 	FDB 0
04510 	FDB 0
*/
static character_t sTOPRT[] = "\x4" ">PRT";
definition_header_s hTOPRT =	
{	{ (natural_t) sTOPRT },
	{ 0 },
	{ (natural_t) &hXSCODE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) TOPRT }
};
void TOPRT(void)
{	if ( standardOutputMemory == NULL )
	{	standardOutputMemory = standardOutput;
		standardOutput = fopen( PrinterLogFilePath, "a" );	/* Arbitrary NUL padding in "binary"? */
	}
}
/*
04520 TOPRT	LDB #-2
04530 	STB DEVNUM
04540 	NEXT
04550 *
*/


/*
04560 	FCC '>VID'
04570 	FCB 4
04580 	FCB MFORE
04590 	FDB TOPRT-CFAOFF
04600 	FDB BIF+2
04610 	FDB 0
04620 	FDB 0
*/
static character_t sTOVID[] = "\x4" ">VID";
definition_header_s hTOVID =	
{	{ (natural_t) sTOVID },
	{ 0 },
	{ (natural_t) &hTOPRT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) TOVID }
};
void TOVID(void)
{	if ( standardOutputMemory != NULL )
	{	fclose( standardOutput );
		standardOutput = standardOutputMemory;
		standardOutputMemory = NULL;
	}
}
/*
04630 TOVID	CLR DEVNUM
04650 	NEXT
04660 *
*/


/*
04670 	FCC '2*'
04680 	FCB 2
04690 	FCB MFORE
04700 	FDB TOVID-CFAOFF
04710 	FDB BIF+2
04720 	FDB 0
04730 	FDB 0
*/
static character_t sLSHIFT[] = "\x2" "2*";
definition_header_s hLSHIFT =	
{	{ (natural_t) sLSHIFT },
	{ 0 },
	{ (natural_t) &hTOVID },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) LSHIFT }
};
void LSHIFT(void)
{		SP[ 0 ].integer <<= 1;
}
/*
04740 LSHIFT	LSL 1,U
04750 	ROL ,U
04760 	NEXT
04770 *
*/


/*
04780 	FCC '2/'
04790 	FCB 2
04800 	FCB MFORE
04810 	FDB LSHIFT-CFAOFF
04820 	FDB BIF+2
04830 	FDB SUB2-CFAOFF
04840 	FDB THREE-CFAOFF
*/
static character_t sRSHIFT[] = "\x2" "2/";
definition_header_s hRSHIFT =	
{	{ (natural_t) sRSHIFT },
	{ 0 },
	{ (natural_t) &hLSHIFT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hSUB2 },
	{ (natural_t) &hTHREE },
	{ (natural_t) RSHIFT }
};
void RSHIFT(void)
{	SP[ 0 ].integer >>= 1;
}
/*
04850 RSHIFT	ASR ,U
04860 	ROR 1,U
04870 	NEXT
04880 *
*/


/* 
04885 	FCC '(REFIND)'
04890 	FCB 8
04895 	FCB MFORE
04900 	FDB RSHIFT-CFAOFF
04910 	FDB BIF+2
04920 	FDB 0
04930 	FDB 0
*/
static character_t sPREF[] = "\x8" "(REFIND)";
definition_header_s hPREF =	
{	{ (natural_t) sPREF },
	{ 0 },
	{ (natural_t) &hRSHIFT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) PREF }
};
/* Tried to intermix the C, but it's impossible.
04940 * search vocabulary adr2 for first (adr1)
04950 PREF	LDD #PFAOFF vocab flag
04955 	PSHS D,Y
04960 	LDX ,U root ptr
04965 	BEQ PREFN // buggy firewall
04970 	BRA PREFA
04980 PREFP	LDY 2,U hunt for
04990 	LDB ,X count
05000 	ANDB #NLMASK
05005 	BEQ PREF1
05010 	TFR B,A
05020 	NEGA
05040 	LEAX A,X hunt in
05050 PREFS	LDA ,Y+ scan
05060 	SUBA ,X+
05070 	BNE PREFN
05080 	DECB
05090 	BNE PREFS
05100 PREF1	LDA ,Y NUL?
05110 	BNE PREFN
05120 PREFX	PULS D,Y
05140 	PSHU D flag
05170 	NEXT
05180 PREFN	LDX [,U] old NFA
05190 	TSTA
05200 	BMI *+6
05210 	LDB #RTOFF
05220 	BRA *+4
05230 	LDB #LFTOFF
05233 	LEAX B,X
05236 	STB 1,S flag
05240 	STX ,U
05250 PREFA	LDX ,X new NFA
05260 	BNE PREFP
05280 	BRA PREFX
08200 *
*/
void PREF(void)	/* No way to get more than a sort of close match to the 6809 source. */
{	cell_u * base = SP[ 0 ].cellp;
	cell_u link;
#if defined DBG_FIND
	fprintf( standardError, "(REFIND)ing {%p:%s}\n", SP[ 1 ].bytep, SP[ 1 ].chString );
#endif
	( * --SP ).integer = 0;	/* Fix a lack of firewalling bug, new flag. */
	if ( base != (cell_u *) 0 )
	{	SP[ 0 ].integer = PFAOFF;	/* Actually means their are no child nodes. */
		while ( ( link = * base ).definitionp != (definition_header_s *) 0 )
		{	character_t * goal = SP[ 2 ].chString;
			character_t * search = ( * link.definitionp ).nameLink.chString;
			natural_t count = * search++;
			snatural_t difference;
			character_t goalch;
#if defined DBG_FIND
	fprintf( standardError, "checking {%p.%p:%s}\n", link.definitionp, search, search );
#endif
			do  
			{	goalch = * goal++;
				if ( count > 0 )
				{	difference = goalch - * search++;
					--count;
				}
				else
				{	difference = goalch;
					break;
				}
			} while ( ( goalch != 0 ) && ( difference == 0 ) );
			if ( difference < 0 )
			{	base = (cell_u *) ( link.bytep + LFTOFF );
				SP[ 0 ].integer = LFTOFF;
			}
			else if ( difference > 0 )
			{	base = (cell_u *) ( link.bytep + RTOFF );
				SP[ 0 ].integer = RTOFF;
			}
			else
			{	break;
			}
		} /* while ( link.definitionp != NULL ); gcc actually compiled this with both while conditions. */
		SP[ 1 ].cellp = base; 
	}
#if defined DBG_FIND
{	character_t * name = SP[ 2 ].chString;
	cell_u * locptr = SP[ 1 ].cellp;
	definition_header_s * found = ( * locptr ).definitionp;
	fprintf( standardError, "found {%p:%s}=>{(%p):%p:%s}{%lX}\n",
			 name, name, locptr, found, 
			 ( ( found == (definition_header_s *) 0 ) ? (character_t *) "{NULL}" : found->nameLink.chString + 1 ),
			 (unsigned long) SP[ 0 ].integer );
}
#endif
}
