/*
**  bifu_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/07/22.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF/A, as mechanically as possible.
*/
#include "bif_a.h"
#include "bifb_a.h"


/* 00080 	INCLUDE BIFU/I:1 */
#include "bifu_i.h"

/*
00090 	ORG $1200	DEBIF: $3F00
00100 	INCLUDE BIF/M:1
*/
#include "bif_m.h"

/* The task record was allocated in bifdp/a. 
00110 	INCLUDE BIFDP/A:1
*/
#include "bifdp_a.h"
/*
00110 	INCLUDE BIFST/A:1
*/
#include "bifst_a.h"
/* No direct page to set up.
00120 	SETDP VDP COLD loads DP
*/

/* Have to bring some of the other header files in, too:
*/
#include "bif2b_a.h"	/* for HERERR() */
#include "bif5b_a.h"	/* for ERROR() */
#include "bif7_a.h"
#include "bif7b_a.h"

/*
01000 *
01001 	FCC '@' name
01002 	FCB 1 name length, usage (NFA)
01003 	FCB MFORE type/allocation MODES
01004 	FDB WARM-CFAOFF previous link in allocation
01005 	FDB BIF+2 owning vocabulary
01006 	FDB EQ-CFAOFF left link in tree
01007 	FDB AND-CFAOFF right link in tree
*/
static character_t sFETCH[] = "\x1" "@";
definition_header_s hFETCH =	
{	{ (natural_t) sFETCH },
	{ 0 },
	{ (natural_t) &hWARM },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hEQ },
	{ (natural_t) &hAND },
	{ (natural_t) FETCH }
};
/*
01010 FETCH	LDD [,U] from [tos] to stack
01011 	STD ,U
01012 	NEXT
01013 *
*/
void FETCH(void)
{	SP[ 0 ] = * ( SP[ 0 ].cellp );
}


/*
01014 	FCC '!'
01015 	FCB 1
01016 	FCB MFORE
01017 	FDB FETCH-CFAOFF
01030 	FDB BIF+2
01040 	FDB NUBLK-CFAOFF
01050 	FDB STOCSP-CFAOFF
*/
static character_t sSTORE[] = "\x1" "!";
definition_header_s hSTORE =	
{	{ (natural_t) sSTORE },
	{ 0 },
	{ (natural_t) &hFETCH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hNUBLK },
	{ (natural_t) &hSTOCSP },
	{ (natural_t) STORE }
};
/*
01060 STORE	LDD 2,U from stack to [top]
01070 	STD [,U]
01080 	LEAU 4,U
01090 	NEXT
01095 *
*/
void STORE(void)
{	cell_u * target = SP[ 0 ].cellp;
	* target = SP[ 1 ];
	SP += 2;
}


/*
01100 	FCC 'LIT'
01110 	FCB MCOMP.OR.3
01120 	FCB MFORE
01130 	FDB STORE-CFAOFF
01140 	FDB BIF+2
01150 	FDB 0 * LIST-CFAOFF
01160 	FDB 0
*/
static character_t sLIT[] = "\x3" "LIT";
definition_header_s hLIT =	
{	{ (natural_t) sLIT },
	{ MCOMP },
	{ (natural_t) &hSTORE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) LIT }
};
/*
01170 LIT	LDD ,Y++ push literal from code
01180 	PSHU D
01190 	NEXT
01200 *
*/
void LIT(void)
{	* --SP = * ( IP++ );
}


/*
01210 	FCC 'DLIT'
01220 	FCB MCOMP.OR.4
01230 	FCB MFORE
01240 	FDB LIT-CFAOFF
01250 	FDB BIF+2
01260 	FDB 0
01270 	FDB 0
*/
static character_t sDLIT[] = "\x4" "DLIT";
definition_header_s hDLIT =	
{	{ (natural_t) sDLIT },
	{ MCOMP },
	{ (natural_t) &hLIT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) DLIT }
};
/*
01280 * push double literal from code
01290 DLIT	LDD ,Y++
01300 	LDX ,Y++
01310 	PSHU D,X
01320 	NEXT
01330 *
*/
void DLIT(void)
{	SP -= 2;
	SP[ 0 ] = IP[ 0 ];	/* Pay attention! */
	SP[ 1 ] = IP[ 1 ];	/* Just pushing twice from the list would invert the half-double-cells. */
	IP += 2;	/* This is closer to optimized, anyway. */
}


/*
01340 	FCC 'EXECUTE'
01350 	FCB MCOMP.OR.7
01360 	FCB MFORE
01370 	FDB DLIT-CFAOFF
01380 	FDB BIF+2
01390 	FDB 0
01400 	FDB 0
*/
static character_t sEXEC[] = "\x7" "EXECUTE";
definition_header_s hEXEC =	
{	{ (natural_t) sEXEC },
	{ MCOMP },
	{ (natural_t) &hDLIT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) EXEC }
};
/*
01410 * EXECUTE cfa on stack
01420 EXEC	LDX ,U++
01430 	BEQ *+4
01440 	JMP ,X
01450 	LDD #9
01460 	PSHU D
01462 	JMP ERROR
01464 *
*/
void EXEC(void)
{	cell_u target = * SP++;	/* Yeah, probably not optimal. */
	/* W = target;	// Done in the macro call. */
#if defined DBG_TRACE_NEXT
fprintf( standardError, "executing:{%p:%s}", 
		 target.bytep, target.definitionp->nameLink.chString + 1 );
dumpState( "before" );
#endif
	if ( target.integer != 0 )
	{	/* ( * ( * target.definitionp ).codeLink.icode )(); */
		mCALLcell( target );
	}
	else
		mERROR( CAN_T_EXECUTE_A_NULL );
#if defined DBG_TRACE_NEXT
fprintf( standardError, "executed:{%p:%s}", 
		 target.bytep, target.definitionp->nameLink.chString + 1 );
dumpState( "after" );
#endif
}


/*
01466 	FCC '1BRANCH'
01468 	FCB MCOMP.OR.7
01470 	FCB MFORE
01472 	FDB EXEC-CFAOFF
01474 	FDB BIF+2
01476 	FDB 0
01478 	FDB 0
*/
static character_t sTBR[] = "\x7" "1BRANCH";
definition_header_s hTBR =	
{	{ (natural_t) sTBR },
	{ MCOMP },
	{ (natural_t) &hEXEC },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) TBR }
};
/*
01480 TBR	LDD ,U++
01482 	BNE BRANCH
01484 	LEAY 2,Y
01486 	NEXT
01488 *
*/
void TBR(void)
{	if ( ( * SP++ ).integer != FALSE )
	{	BRANCH();
	}
	else
	{	IP++;
	}
}


/*
01490 	FCC 'BRANCH'
01500 	FCB MCOMP.OR.6
01510 	FCB MFORE
01520 	FDB TBR-CFAOFF
01530 	FDB BIF+2
01540 	FDB 0
01550 	FDB 0
*/
static character_t sBRANCH[] = "\x6" "BRANCH";
definition_header_s hBRANCH =	
{	{ (natural_t) sBRANCH },
	{ MCOMP },
	{ (natural_t) &hTBR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) BRANCH }
};
/*
01560 BRANCH	LDD ,Y++
01570 	LEAY D,Y
01580 	NEXT
01590 *
*/
void BRANCH(void)
{	snatural_t offset = ( * IP++ ).sinteger;
	byte_p nextIcode = (byte_p) IP;
	nextIcode += offset;
	IP = (cell_u *) nextIcode;	/* Let the CPU worry about word boundaries. */
}


/*
01600 	FCC '0BRANCH'
01610 	FCB MCOMP.OR.7
01620 	FCB MFORE
01630 	FDB BRANCH-CFAOFF
01640 	FDB BIF+2
01650 	FDB 0
01660 	FDB 0
*/
static character_t sZBR[] = "\x7" "0BRANCH";
definition_header_s hZBR =	
{	{ (natural_t) sZBR },
	{ MCOMP },
	{ (natural_t) &hBRANCH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) ZBR }
};
/*
01670 ZBR	LDD ,U++
01680 	BEQ BRANCH
01690 	LEAY 2,Y
01700 	NEXT
01710 *
*/
void ZBR(void)	/* 0BRANCH is the more commonly used conditional! */
{	if ( ( * SP++ ).integer == FALSE )
	{	BRANCH();
	}
	else
	{	IP++;
	}
}


/*
01720 	FCC '(LOOP)'
01730 	FCB MCOMP.OR.6
01740 	FCB MFORE
01750 	FDB ZBR-CFAOFF
01760 	FDB BIF+2
01770 	FDB 0
01780 	FDB 0
*/
static character_t sXLOOP[] = "\x6" "(LOOP)";
definition_header_s hXLOOP =	
{	{ (natural_t) sXLOOP },
	{ MCOMP },
	{ (natural_t) &hZBR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XLOOP }
};
/*
01790 XLOOP	LDD #1
01800 	ADDD ,S
01810 	STD ,S
01820 	SUBD 2,S
01830 	BLT BRANCH
01840 XLOOPN	LEAY 2,Y
01850 	LEAS 4,S
01860 	NEXT
01870 *
*/
void XLOOP(void)
{	RP[ 0 ].integer += 1;
	/* The original, not smart loop.
	// Should be good for 32 bit signed.
	// But I want to avoid trouble with the sign of pointers:
	*/
	{	snatural_t difference = RP[ 1 ].integer - RP[ 0 ].integer;
		if ( difference > 0 )
		{	BRANCH();
		}
		else
		{	++IP;
			RP += 2;
		}
	}
}


/*
01880 	FCC '(+LOOP)'
01890 	FCB MCOMP.OR.7
01900 	FCB MFORE
01910 	FDB XLOOP-CFAOFF
01920 	FDB BIF+2
01930 	FDB 0
01940 	FDB 0
*/
static character_t sXPLOOP[] = "\x7" "(+LOOP)";
definition_header_s hXPLOOP =	
{	{ (natural_t) sXPLOOP },
	{ MCOMP },
	{ (natural_t) &hXLOOP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XPLOOP }
};
/*
01950 XPLOOP	LDD ,U++ inc val
01960 	BPL XLOOP+3
01970 	ADDD ,S
01980 	STD ,S
01990 	SUBD 2,S
02000 	BGT BRANCH
02010 	BRA XLOOPN
02020 *
*/
void XPLOOP(void)
{	snatural_t increment = ( * SP++ ).sinteger;
	RP[ 0 ].sinteger += increment;	/* I want these to be unsigned, but C will never see unsigned < 0. */
	/* The original, not smart +loop. 
	// Should be good for 32 bit signed.
	// But I want to avoid trouble with the sign of pointers:
	*/
	{	snatural_t difference = RP[ 1 ].integer - RP[ 0 ].integer;
		if ( ( ( increment > 0 ) && ( difference < 0 ) ) 
			 || ( ( increment < 0 ) && ( difference > 0 ) ) )
		{	BRANCH();	/* Conflate these with a macro, or just not be slavish? */
		}
		else
		{	++IP;
			RP += 2;
		}
	}
}

/*
02030 	FCC '(DO)'
02040 	FCB 4
02050 	FCB MFORE
02060 	FDB XPLOOP-CFAOFF
02070 	FDB BIF+2
02080 	FDB 0
02090 	FDB 0
*/
static character_t sXDO[] = "\x4" "(DO)";
definition_header_s hXDO =	
{	{ (natural_t) sXDO },
	{ 0 },
	{ (natural_t) &hXPLOOP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XDO }
};
/*
02100 XDO	PULU D,X
02110 	PSHS D,X
02120 	NEXT
02130 *
*/
void XDO(void)
{	RP -= 2;	/* Take care not to invert. */
	RP[ 0 ] = SP[ 0 ];
	RP[ 1 ] = SP[ 1 ];
	SP += 2;
}


/*
02140 	FCC 'I'
02150 	FCB 1
02160 	FCB MFORE
02170 	FDB XDO-CFAOFF
02180 	FDB BIF+2
02190 	FDB HLD-CFAOFF
02200 	FDB IDDOT-CFAOFF
*/
static character_t sI[] = "\x1" "I";
definition_header_s hI =	
{	{ (natural_t) sI },
	{ 0 },
	{ (natural_t) &hXDO },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hHLD },
	{ (natural_t) &hIDDOT },
	{ (natural_t) I }
};
/*
02210 I	LDD ,S
02220 	PSHU D
02222 	NEXT
02224 *
*/
void I(void)
{	* --SP = RP[ 0 ];
}


/*
02226 	FCC 'J'
02228 	FCB 1
02230 	FCB MFORE
02232 	FDB I-CFAOFF
02234 	FDB BIF+2
02236 	FDB IPCOM-CFAOFF
02238 	FDB 0
*/
static character_t sJ[] = "\x1" "J";
definition_header_s hJ =	
{	{ (natural_t) sJ },
	{ 0 },
	{ (natural_t) &hI },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hIPCOM },
	{ 0 },
	{ (natural_t) J }
};
/*
02240 J	LDD 4,S
02242 	PSHU D
02244 	NEXT
02246 *
*/
void J(void)
{	* --SP = RP[ 2 ];
}


/*
02250 	FCC 'DIGIT'
02260 	FCB 5
02270 	FCB MFORE
02280 	FDB J-CFAOFF
02290 	FDB BIF+2
02300 	FDB DEC-CFAOFF
02310 	FDB DLITER-CFAOFF
*/
static character_t sDIGIT[] = "\x5" "DIGIT";
definition_header_s hDIGIT =	
{	{ (natural_t) sDIGIT },
	{ 0 },
	{ (natural_t) &hJ },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDEC },
	{ (natural_t) &hDLITER },
	{ (natural_t) DIGIT }
};
/*
02320 DIGIT	LDB 3,U
02330 	CMPB #'9
02340 	BLS DIGITX+4
02350 	CMPB #'A
02360 	BLO DIGITN
02370 	CMPB #'Z
02380 	BLS DIGITX+2
02390 	CMPB #'a
02400 	BLO DIGITN
02410 	CMPB #'z
02420 	BHI DIGITN
02430 DIGITX	SUBB #'a-'Z-1
02440 	SUBB #'A-'9-1
02450 	SUBB #'0
02460 	CMPB 1,U
02470 	BHS DIGITN
02480 	CLRA
02490 	STD 2,U
02500 	LDD #-1
02510 DIGITL	STD ,U
02520 	NEXT
02530 DIGITN	LEAU 2,U
02540 	LDD #0
02550 	BRA DIGITL
02560 *
*/
void DIGIT(void)	/* 0xA == 0xa, Effectively limited to base 36. */
{	natural_t base = SP[ 0 ].integer;
	natural_t digit = SP[ 1 ].integer;
	++SP;	/* Follow the 6809 code. Assume/preset false so we can bail early. */
	SP[ 0 ].sinteger = FALSE;
	if ( digit > '9' )
	{	if ( digit < 'A' )
			return;
		if ( digit > 'Z' )
		{	if ( ( digit < 'a' ) || ( digit > 'z' ) )
				return;
			digit -= 'a' - 'Z' - 1;	/* Subtract the gap. */
		}
		digit -= 'A' - '9' - 1;	/* Subtract the gap. */
	}
	digit -= '0';	/* Final adjustment, digit < '0' wraps to very high value. */
	if ( digit > base )
		return;
	SP[ 0 ].integer = digit;
	( * --SP ).sinteger = TRUE;
	return;
}


/*
02570 	FCC '(FIND)'
02580 	FCB 6
02590 	FCB MFORE
02600 	FDB DIGIT-CFAOFF
02610 	FDB BIF+2
02620 	FDB IABORT-CFAOFF
02630 	FDB XMACH-CFAOFF
*/
static character_t sPFIND[] = "\x6" "(FIND)";
definition_header_s hPFIND =	
{	{ (natural_t) sPFIND },
	{ 0 },
	{ (natural_t) &hDIGIT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hIABORT },
	{ (natural_t) &hXMACH },
	{ (natural_t) PFIND }
};
/*
02640 * search vocabulary adr2 for (adr1)
02650 PFIND	LDD ,U valid?
02660 	BEQ PFINDX
02670 PFINDL	DOCOL
02680 	FDB PREF
02690 	FDB XMACH
02700 	LEAU 2,U
02710 	LDX [,U] NULL link?
02720 	BEQ PFINDN
02730 	LDB ,X
02740 	ANDB #MHID smudged?
02750 	BEQ PFINDY
02760 	LEAX RTOFF,X deeper
02770 	STX ,U
02780 	BRA PFINDL
02790 PFINDY	LDX #-1
02800 PFINDN	LDD ,U
02810 	STX ,U
02820 PFINDX	STD 2,U
02830 	NEXT
02990 *
*/
void PFIND(void)
{	cell_u * base = SP[ 0 ].cellp;
	while ( base != (cell_u *) 0 )	/* Firewall. */
	{	PREF();
		++SP;	/* Ignore flag, check link. */
		base = SP[ 0 ].cellp;
		cell_u link = * base;
		snatural_t flag = FALSE;	/* Want to be careful not to depend on NULL being numerically 0. */
		if ( link.definitionp != (definition_header_s *) 0 )
		{	if ( ( ( ( * link.definitionp ).interpMode ).integer & MHID ) != 0 )	/* Smudged (hidden), go deeper. */
			{	SP[ 0 ].cellp = base = (cell_u *) link.bytep + RTOFF;	/* Smudged definitions are lexically less. */
				continue;	/* Trying to follow the 6809 code, for now. */
			}
			else
			{	flag = TRUE;	/* Exists. */
			}
		}
		SP[ 0 ].sinteger = flag;
		break;
	}
	SP[ 1 ].cellp = base;	/* if it came in NULL, pass it back NULL. */
}


/*
03000 	FCC 'ENCLOSE'
03010 	FCB 7
03020 	FCB MFORE
03030 	FDB PFIND-CFAOFF
03040 	FDB BIF+2
03050 	FDB EMTBUF-CFAOFF
03060 	FDB 0
*/
static character_t sENCLOS[] = "\x7" "ENCLOSE";
definition_header_s hENCLOS =	
{	{ (natural_t) sENCLOS },
	{ 0 },
	{ (natural_t) &hPFIND },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hEMTBUF },
	{ 0 },
	{ (natural_t) ENCLOS }
};
/*
03070 * adr1 c --- adr2 len
03080 ENCLOS	LDX 2,U
03100 ENCLLD	LDB ,X+ delimiter
03110 	BEQ ENCL0
03120 	CMPB 1,U
03130 	BEQ ENCLLD
03133 ENCL0	LEAX -1,X
03140 	STX 2,U
03150 ENCLLW	LDB ,X+ scan word
03160 	BEQ ENCLCA
03170 	CMPB 1,U
03180 	BNE ENCLLW
03190 ENCLCA	TFR X,D length
03195 	SUBD #1
03200 	SUBD 2,U
03220 	STD ,U
03230 	NEXT
03240 *
*/
void ENCLOS(void)
{	character_t * buffer = SP[ 1 ].chString;
	character_t delimiter = (character_t) SP[ 0 ].integer;
	character_t ch;
	while ( ( ( ch = * buffer++ ) != 0 ) && ( ch == delimiter ) )
	{	}
	SP[ 1 ].chString = --buffer;
	while ( ( ( ch = * buffer++ ) != 0 ) && ( ch != delimiter ) )
	{	}
	--buffer;
	SP[ 0 ].integer = buffer - SP[ 1 ].chString;
}


/* Out of order instead of putting this in bif_a.h :
03410 LITERS	LDX <UP
03412 	LDB USTATE+1,X
03414 	ANDB #SCOMP
03416 	PULS D no CC
03418 	BNE *+4 compiling?
03420 	NEXT no
03422 	PSHS Y
03424 	LDY UDP,X
03426 	EXG D,PC return
03430 *
** Most of this is stuff that C would pass off to the optimizer.
** LITERS is converted to a macro and moved to where LITER can see it.
*/
#define LITERS	\
{	if ( ( ( UP.task->compilerState.integer ) & SCOMP ) == 0 )	\
	{	return;	\
	}	\
	/* And then what would be useful?		\
	** Splitting the local variable and its	use is generally bad practice in macros, anyway.	\
	** Eventually, check before allocating, in common code. \
	** That would make sense as a macro.	\
	*/	\
}

/*
03250 	FCC 'LITERAL'
03260 	FCB MIMM.OR.7
03270 	FCB MFORE
03280 	FDB ENCLOS-CFAOFF
03290 	FDB BIF+2
03300 	FDB LIT-CFAOFF
03310 	FDB LOAD-CFAOFF
*/
static character_t sLITER[] = "\x7" "LITERAL";
definition_header_s hLITER =	
{	{ (natural_t) sLITER },
	{ MIMM },
	{ (natural_t) &hENCLOS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hLIT },
	{ (natural_t) &hLOAD },
	{ (natural_t) LITER }
};
/*
03320 * compile a literal
03330 LITER	BSR LITERS
03340 	LDD #LIT
03350 LITERB	STD ,Y++
03360 	PULU D
03370 	STD ,Y++
03380 	STY UDP,X
03390 	PULS Y
03400 	JMP HERERR
03405 *
*/
void LITER(void)
{	LITERS;	/* This is a race condition. Also, want to use the same code as comma. */
	cell_u * allocation = UP.task->dictionaryAllocationPointer.cellp;
	( * allocation++ ).definitionp = &hLIT;
	( * allocation++ ) = * SP++;
	UP.task->dictionaryAllocationPointer.cellp = allocation;
	HERERR;
}


/*
03410 LITERS	LDX <UP
03412 	LDB USTATE+1,X
03414 	ANDB #SCOMP
03416 	PULS D no CC
03418 	BNE *+4 compiling?
03420 	NEXT no
03422 	PSHS Y
03424 	LDY UDP,X
03426 	EXG D,PC return
03430 *
** Most of this is stuff that C would pass off to the optimizer.
** LITERS is converted to a macro and moved to where LITER can see it.
*/


/*
03435 	FCC 'DLITERAL'
03440 	FCB MIMM.OR.8
03450 	FCB MFORE
03460 	FDB LITER-CFAOFF
03470 	FDB BIF+2
03480 	FDB DLIT-CFAOFF
03490 	FDB DMINUS-CFAOFF
*/
static character_t sDLITER[] = "\x8" "DLITERAL";
definition_header_s hDLITER =	
{	{ (natural_t) sDLITER },
	{ MIMM },
	{ (natural_t) &hLITER },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDLIT },
	{ (natural_t) &hDMINUS },
	{ (natural_t) DLITER }
};
/*
03500 * compile a 32 bit constant
03510 DLITER	BSR LITERS
03540 	LDD #DLIT
03550 	STD ,Y++
03560 	PULU D
03570 	BRA LITERB
03630 *
*/
void DLITER(void)
{	LITERS;
	cell_u * allocation = UP.task->dictionaryAllocationPointer.cellp;
	( * allocation++ ).definitionp = &hDLIT;
	( * allocation++ ) = * SP++;
	( * allocation++ ) = * SP++;
	UP.task->dictionaryAllocationPointer.cellp = allocation;
	HERERR;
}


/* Including these all through bifu_i.h, depending on the inclusion guards to prevent loops.
08210 	INCLUDE BIFB/A:1
08220 	INCLUDE BIF1/A:1
08230 	INCLUDE BIF1B/A:1
08240 	INCLUDE BIF2/A:1
08250 	INCLUDE BIF2B/A:1
08260 	INCLUDE BIF3/A:1
08270 	INCLUDE BIF3B/A:1
08280 	INCLUDE BIF4/A:1
08285 	INCLUDE BIF4B/A:1
08290 	INCLUDE BIF5/A:1
08295 	INCLUDE BIF5B/A:1
08300 	INCLUDE BIF6/A:1
08310 	INCLUDE BIF6B/A:1
08320 	INCLUDE BIF7/A:1
08330 	INCLUDE BIF7B/A:1
09000 	END
*/