/*
**  bif4_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF4/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bif7b_a.h"	/* To link into the BIF vocabulary. */
/* #include "bif5b_a.h"	 for ERROR() */

#include "bif4_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
01000 	FCC 'M*'
01010 	FCB 2
01020 	FCB MFORE
01030 	FDB DO-CFAOFF
01040 	FDB BIF+2
01050 	FDB 0
01060 	FDB MSLASH-CFAOFF
*/
static character_t sMSTAR[] = "\x2" "M*";
definition_header_s hMSTAR = 
{	{ (natural_t) sMSTAR },
	{ 0 },
	{ (natural_t) &hDO },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hMSLASH },
	{ (natural_t) MSTAR }
};
/*
01070 MSTAR	LDD ,U	see fig-FORTH model
01080 	EORA 2,U n bit
01090 	PSHS D
01100 	DOCOL
01110 	FDB ABS
01120 	FDB SWAP
01130 	FDB ABS
01140 	FDB USTAR
01150 	FDB XMACH
01160 	LDD ,S++
01170 	LBMI DMINUS
01180 	NEXT
01190 *
*/
void MSTAR( void )
{
#if defined ULONG_LONG_MAX_AVAILABLE && ( ULONG_LONG_MAX_AVAILABLE == 64 ) \
	&& ( BYTESPERCELL == 4 ) && ( BITSPERBYTE == 8 )
	sdouble_t left = SP[ 1 ].sinteger;
	sdouble_t right = SP[ 0 ].sinteger;
	* ( (sdouble_t *) &( SP[ 0 ] ) ) = left * right;
#else
#	error "M* not yet ready for defined types! (byte order dependent compiling)"
#endif
}


/*
01200 	FCC 'M/'
01210 	FCB 2
01220 	FCB MFORE
01230 	FDB MSTAR-CFAOFF
01240 	FDB BIF+2
01250 	FDB 0
01260 	FDB 0
*/
static character_t sMSLASH[] = "\x2" "M/";
definition_header_s hMSLASH = 
{	{ (natural_t) sMSLASH },
	{ 0 },
	{ (natural_t) &hMSTAR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) MSLASH }
/*
	{ (natural_t) XCOL },
01270 MSLASH	DOCOL	see fig-FORTH model
01280 	FDB OVER
01290 	FDB TOR signs: dividend
01300 	FDB TOR & divisor
01310 	FDB DABS
01320 	FDB R divisor
01330 	FDB ABS
01340 	FDB USLASH
01350 	FDB RFROM divisor
01360 	FDB R
01370 	FDB XOR quotient sign
01380 	FDB CHS
01390 	FDB SWAP remainder
01400 	FDB RFROM dividend sign
01410 	FDB CHS
01420 	FDB SWAP
01430 	FDB SEMIS
01500 *
	{
		{ (natural_t) &hOVER	},	// * mucking with byte order dependency like crazy * /
		{ (natural_t) &hTOR	},	// * signs: dividend * /
		{ (natural_t) &hTOR	},	// * & divisor * /
		{ (natural_t) &hDABS	},
		{ (natural_t) &hR	},	// * divisor * /
		{ (natural_t) &hABS	},
		{ (natural_t) &hUSLASH	},
		{ (natural_t) &hRFROM	},	// * divisor * /
		{ (natural_t) &hR	},
		{ (natural_t) &hXOR	},	// * quotient sign * /
		{ (natural_t) &hCHS	},
		{ (natural_t) &hSWAP	},	// * remainder * /
		{ (natural_t) &hRFROM	},	// * dividend sign * /
		{ (natural_t) &hCHS	},
		{ (natural_t) &hSWAP	},
		{ (natural_t) &hSEMIS	}
	}
*/
};
void MSLASH(void)	/* ( d n --- remainder quotient ) */
{
#if defined ULONG_LONG_MAX_AVAILABLE && ( ULONG_LONG_MAX_AVAILABLE == 64 ) \
	&& ( BYTESPERCELL == 4 ) && ( BITSPERBYTE == 8 )
	sdouble_t dividend = * ( (double_t *) &( SP[ 1 ] ) );
	sdouble_t divisor = SP[ 0 ].sinteger;
	SP[ 1 ].sinteger = dividend % divisor;
	SP[ 0 ].sinteger = dividend / divisor;
#else
#	error "M/ not yet ready for defined types! (byte order dependent compiling)"
#endif
}


/*
01510 	FCC '*'
01520 	FCB 1
01530 	FCB MFORE
01540 	FDB MSLASH-CFAOFF
01550 	FDB BIF+2
01560 	FDB PFIND-CFAOFF
01570 	FDB SSMOD-CFAOFF
*/
static character_t sSTAR[] = "\x1" "*";
definition_header_s hSTAR = 
{	{ (natural_t) sSTAR },
	{ 0 },
	{ (natural_t) &hMSLASH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hPFIND },
	{ (natural_t) &hSSMOD },
	{ (natural_t) XCOL },
/*
01580 STAR	DOCOL	see fig-FORTH model
01590 	FDB USTAR
01600 	FDB DROP
01610 	FDB SEMIS
01700 *
*/
	{
		{ (natural_t) &hUSTAR	},
		{ (natural_t) &hDROP	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
01710 	FCC '/MOD'
01720 	FCB 4
01730 	FCB MFORE
01740 	FDB STAR-CFAOFF
01750 	FDB BIF+2
01760 	FDB 0
01770 	FDB 0
*/
static character_t sSLAMOD[] = "\x4" "/MOD";
definition_header_s hSLAMOD =	
{	{ (natural_t) sSLAMOD },
	{ 0 },
	{ (natural_t) &hSTAR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) SLAMOD }
};
/*
01780 SLAMOD	LDD ,U
01790 	PSHU D
01800 	LDD #-1
01810 	TST 4,U sign extend
01820 	BMI *+5
01830 	ADDD #1
01840 	STD 2,U
01850 	LBRA MSLASH
01900 *
*/
void SLAMOD(void)
{	/* Not going to fight C optimizations too hard. But this gives the C integer results, 
	// and I want to check whether that is what I really wanted.
	// If I can figure out where. 
	// Feels weird writing code for C to undo what the machine probably provides naturally.
	// Wonder whether I'd more consistent results from calling M/ per the FORTH model.
	*/
	snatural_t dividend = SP[ 1 ].sinteger;
	snatural_t divisor = SP[ 0 ].sinteger;
	SP[ 1 ].sinteger = dividend % divisor;
	SP[ 0 ].sinteger = dividend / divisor;
}


/*
01910 	FCC '/'
01920 	FCB 1
01930 	FCB MFORE
01940 	FDB SLAMOD-CFAOFF
01950 	FDB BIF+2
01960 	FDB NEXSCR-CFAOFF
01970 	FDB ADD1-CFAOFF
*/
static character_t sSLASH[] = "\x1" "/";
definition_header_s hSLASH =	
{	{ (natural_t) sSLASH },
	{ 0 },
	{ (natural_t) &hSLAMOD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hNEXSCR },
	{ (natural_t) &hADD1 },
/*	{ (natural_t) SLASH } */
	{ (natural_t) XCOL },
/*
01980 SLASH	DOCOL	see fig-FORTH model
01990 	FDB SLAMOD
02000 	FDB SWAP
02010 	FDB DROP
02020 	FDB SEMIS
02100 *
*/
	{
		{ (natural_t) &hSLAMOD	},
		{ (natural_t) &hSWAP	},
		{ (natural_t) &hDROP	},
		{ (natural_t) &hSEMIS	}
	}
};

void SLASH(void)
{	/* Not going to fight C optimizations too hard. But this gives the C integer division, 
	// and I want to check whether that is what I really wanted.
	// If I can figure out where. 
	*/
	SP[ 1 ].sinteger /= SP[ 0 ].sinteger;
	++SP;
}


/*
02110 	FCC 'MOD'
02120 	FCB 3
02130 	FCB MFORE
02140 	FDB SLASH-CFAOFF
02150 	FDB BIF+2
02160 	FDB 0
02170 	FDB 0
*/
static character_t sMOD[] = "\x3" "MOD";
definition_header_s hMOD =	
{	{ (natural_t) sMOD },
	{ 0 },
	{ (natural_t) &hSLASH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
/*	{ (natural_t) MOD } */
	{ (natural_t) XCOL },
/*
02180 MOD	DOCOL	see fig-FORTH model
02190 	FDB SLAMOD
02210 	FDB DROP
02220 	FDB SEMIS
02300 *
*/
	{
		{ (natural_t) &hSLAMOD	},
		{ (natural_t) &hDROP	},
		{ (natural_t) &hSEMIS	}
	}
};

void MOD(void)
{	/* Not going to fight C optimizations too hard. But this gives the C integer modulus, 
	// and I want to check whether that is what I really wanted.
	// If I can figure out where.
	*/
	SP[ 1 ].sinteger %= SP[ 0 ].sinteger;
	++SP;
}


/*
02310 	FCC '* /MOD'	// * The name of this causes comment termination. * /
02320 	FCB 5
02330 	FCB MFORE
02340 	FDB MOD-CFAOFF
02350 	FDB BIF+2
02360 	FDB STARSL-CFAOFF
02370 	FDB 0
*/
static character_t sSSMOD[] = "\x5" "*/MOD";
definition_header_s hSSMOD = 
{	{ (natural_t) sSSMOD },
	{ 0 },
	{ (natural_t) &hMOD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hSTARSL },
	{ 0 },
	{ (natural_t) XCOL },
/*
02380 SSMOD	DOCOL	see fig-FORTH model
02390 	FDB TOR
02400 	FDB MSTAR
02410 	FDB RFROM
02420 	FDB MSLASH
02430 	FDB SEMIS
02500 *
*/
	{
		{ (natural_t) &hTOR	},
		{ (natural_t) &hMSTAR	},
		{ (natural_t) &hRFROM	},
		{ (natural_t) &hMSLASH	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
02510 	FCC '* /'	this name causes comment termination too.
02520 	FCB 2
02530 	FCB MFORE
02540 	FDB SSMOD-CFAOFF
02550 	FDB BIF+2
02560 	FDB 0
02570 	FDB 0
*/
static character_t sSTARSL[] = "\x2" "*/";
definition_header_s hSTARSL = 
{	{ (natural_t) sSTARSL },
	{ 0 },
	{ (natural_t) &hSSMOD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL },
/*
02580 STARSL	DOCOL	see fig-FORTH model
02590 	FDB SSMOD
02600 	FDB SWAP
02610 	FDB DROP
02630 	FDB SEMIS
02700 *
*/
	{
		{ (natural_t) &hSSMOD	},
		{ (natural_t) &hSWAP	},
		{ (natural_t) &hDROP	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
02710 	FCC 'M/MOD'
02720 	FCB 5
02730 	FCB MFORE
02740 	FDB STARSL-CFAOFF
02750 	FDB BIF+2
02760 	FDB MSTAR-CFAOFF
02770 	FDB MESS-CFAOFF
*/
static character_t sMSMOD[] = "\x5" "M/MOD";
definition_header_s hMSMOD = 
{	{ (natural_t) sMSMOD },
	{ 0 },
	{ (natural_t) &hSTARSL },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hMSTAR },
	{ (natural_t) &hMESS },
	{ (natural_t) MSMOD }
/*
	{ (natural_t) XCOL },
02780 MSMOD	DOCOL	see fig-FORTH model
02790 	FDB TOR
02800 	FDB ZERO
02810 	FDB R
02820 	FDB USLASH ms word
02830 	FDB RFROM
02840 	FDB SWAP
02850 	FDB TOR save high q
02860 	FDB USLASH ls word
02870 	FDB RFROM double q
02880 	FDB SEMIS
02900 *
	{
		{ (natural_t) &hTOR	},
		{ (natural_t) &hZERO	},	// * Byte order dependency * /
		{ (natural_t) &hR	},
		{ (natural_t) &hUSLASH	},	// * ms word * /
		{ (natural_t) &hRFROM	},
		{ (natural_t) &hSWAP	},
		{ (natural_t) &hTOR	},	// * save high q * /
		{ (natural_t) &hUSLASH	},	// * ls word * /
		{ (natural_t) &hRFROM	},	// * double q * /
		{ (natural_t) &hSEMIS	}
	}
*/
};
void MSMOD(void)	/* ( uddividend udivisor --- uremainder udquotient ) */
{	
#if defined ULONG_LONG_MAX_AVAILABLE && ( ULONG_LONG_MAX_AVAILABLE == 64 ) \
	&& ( BYTESPERCELL == 4 ) && ( BITSPERBYTE == 8 )
	double_t dividend = * ( (double_t *) &( SP[ 1 ] ) );	/* Native CPU byte order for doubles. */
	double_t divisor = (double_t) ( SP[ 0 ].integer );
	SP[ 2 ].integer = (natural_t) ( dividend % divisor );
	* ( (double_t *) &( SP[ 0 ] ) ) = dividend / divisor;
#else
#	error "M/MOD not yet ready for defined types! (byte order dependent compiling)"
#endif
}


/*
02910 	FCC '+BUF'
02920 	FCB 4
02930 	FCB MFORE
02940 	FDB MSMOD-CFAOFF
02950 	FDB BIF+2
02960 	FDB 0
02970 	FDB 0
*/
static character_t sADDBUF[] = "\x4" "+BUF";
definition_header_s hADDBUF = 
{	{ (natural_t) sADDBUF },
	{ 0 },
	{ (natural_t) &hMSMOD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) ADDBUF }
};
/*
02980 ADDBUF	LDX <UP
02990 	LDD BPBUF+2
02995 	ADDD #4
03000 	ADDD ,U
03010 	CMPD ULIMIT,X
03020 	BLO ADDBN
03025 	LDD UFIRST,X
03030 ADDBN	STD ,U
03040 	CMPD UPREV,X
03050 	BEQ *+7
03060 	LDD #-1
03065 	BRA *+5
03070 	LDD #0
03080 	PSHU D
03090 	NEXT
03100 *
*/
void ADDBUF( void )
{	byte_t * bufferStart = SP[ 0 ].bytep + hBPBUF.parameterLink[ 0 ].integer + BUFF_CTRL_WID;
	if ( bufferStart >= UP.task->limitOfBufferRAM.bytep )
	{	bufferStart = UP.task->firstByteOfBuffers.bytep;
	}
	SP[ 0 ].bytep = bufferStart;
	( * --SP ).sinteger = ( bufferStart == UP.task->mostRecentBuffer.bytep ) ? 0L: -1L;
}


/*
03110 	FCC 'UPDATE'
03120 	FCB 6
03130 	FCB MFORE
03140 	FDB ADDBUF-CFAOFF
03150 	FDB BIF+2
03160 	FDB UNTIL-CFAOFF
03170 	FDB USER-CFAOFF
*/
static character_t sUPDATE[] = "\x6" "UPDATE";
definition_header_s hUPDATE = 
{	{ (natural_t) sUPDATE },
	{ 0 },
	{ (natural_t) &hADDBUF },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hUNTIL },
	{ (natural_t) &hUSER },
	{ (natural_t) UPDATE }
};
/*
03180 UPDATE	LDX <UP
03190 	LDD [UPREV,X]
03200 	ORA #$80	// This is probably the source of the bug that failed to write out dirty buffers sometimes.
03210 	STD [UPREV,X]
03220 	NEXT
03300 *
*/
void UPDATE( void )
{	cell_u * previousBufferControl = SP[ 0 ].cellp;
	previousBufferControl->integer |= BUFF_DIRTY_FLAG;
}


/*
03310 	FCC 'EMPTY-BUFFERS'
03320 	FCB 13
03330 	FCB MFORE
03340 	FDB UPDATE-CFAOFF
03350 	FDB BIF+2
03360 	FDB 0
03370 	FDB 0
*/
static character_t sEMTBUF[] = "\xd" "EMPTY-BUFFERS";
definition_header_s hEMTBUF = 
{	{ (natural_t) sEMTBUF },
	{ 0 },
	{ (natural_t) &hUPDATE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) EMTBUF }
};
/*
03380 EMTBUF	LDX <UP
03390 	LDD ULIMIT,X
03395 	SUBD #1 catch odd
03400 	PSHS D,Y
03410 	LDX UFIRST,X
03420 	LDY #0
03430 	LDD BPBUF+2
03440 EMTBL	CMPX ,S
03445 	BHS EMTBE
03450 	STY ,X++ update bit
03455 	LEAX D,X
03460 	CMPX ,S
03465 	BHS EMTBE
03470 	STY ,X++ term NUL
03475 	BRA EMTBL
03480 EMTBE	PULS D,Y
03490 	NEXT
03500 *
*/
void EMTBUF( void )
{	byte_p end = UP.task->limitOfBufferRAM.bytep;	/* Not adjusting down to catch odd stuff. */
	byte_p start = UP.task->firstByteOfBuffers.bytep;
	natural_t byteCount = hBPBUF.parameterLink[ 0 ].integer + BUFF_CTRL_WID;	/* implicit semantic linkage!!! */
	for ( start = UP.task->firstByteOfBuffers.bytep; start < end; start += byteCount )
	{	cell_u * buff_control = (cell_u *) start;
		buff_control[ 0 ].cellp = 0;	/* Clear the flag bits. */
		buff_control[ 1 ].cellp = 0;	/* Store a 0 count. (?) */
	}
}


/* Lots of implicit linkage here, see B/BUF, etc., too.
** Ultimately, this needs to be defined at the FORTH level, too.
*/
#define	DRIVE_BLOCK_COUNT	0
#define	DRIVE_FILE_POINTER	1
/* I keep thinking I want sector/block size here, instead, but maybe not really. */
typedef cell_u vdrive_a[ 2 ];	/* Structures are just arrays, right? 8-* */
#define DRIVE_LIST_TERMINATOR	CELL_HIGH_BIT

/*
03510 	FCC 'DRIVE-OFFSET'
03520 	FCB 12
03530 	FCB MFORE
03540 	FDB EMTBUF-CFAOFF
03550 	FDB BIF+2
03560 	FDB DRIVE-CFAOFF
03570 	FDB DROOT-CFAOFF
*/
static character_t sDROFFS[] = "\xc" "DRIVE-OFFSET";
definition_header_s hDROFFS = 
{	{ (natural_t) sDROFFS },
	{ 0 },
	{ (natural_t) &hEMTBUF },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDRIVE },
	{ (natural_t) &hDROOT },
	{ (natural_t) X1ARR },
/*
03580 DROFFS	DO1ARR
03590 	FDB 0 low
03600 	FDB 4 width
03610 	FCB 2 element size
03620 	FDB 18*35 drive 0
03630 	FDB 18*35
03640 	FDB $8000 8 Meg max
03650 	FDB $8000
03660 	FDB $8000 never a drive 5!
03700 *
**
** The purpose of this array was to present FORTH a virtual array of persistent bytes
** that spanned all on-line disk storage.
** This point of view doesn't really make sense in a hosted environment.
** Except that most host environments do not provide files that exceed the volume size.
** So, maybe, what I want here is an array of FILE pointers, so I can use multiple files like multiple drives.
** Whether I need sizes (limits? constant allocation?) is a separate question.
** Ultimately, this wants to define database interfaces, but that's quite a ways off.
** I could use two "drive" files, one that has indexes, error messages, code, etc., 
** and one that is hypothetically data.
** So, should I put the file pointers for those in an array in UTILITIES,
** Or should I make this linear array a linear array of structures? 
*/
	{	/* Default virtual drive emulating the size of my Color Computer drives. */
		{ 0	},	/* array low index */
		{ 4	},	/* array width */
		{ 2 * sizeof (cell_u)	},	/* array element size, room for sector/block count and FILE pointer */
		{ 18 * 35	},	{	(natural_t) NULL	},	/* virtual drive 0 */
		{ 18 * 35	},	{	(natural_t) NULL	},	/* Eventually, command line parameters will specify these. */
		{ DRIVE_LIST_TERMINATOR	},	{	(natural_t) NULL	},	/* Originally 8 Meg max (TOTAL!) (heh!) */
		{ DRIVE_LIST_TERMINATOR	},	{	(natural_t) NULL	},	/* (And still not big enough, really.) */
		{ DRIVE_LIST_TERMINATOR	},	{	(natural_t) NULL	}	/* never a drive 5 on a Tandy Color Computer! */
	}
};
/*
03710 	FCC 'DRIVE'
03720 	FCB 5
03730 	FCB MFORE
03740 	FDB DROFFS-CFAOFF
03750 	FDB BIF+2
03760 	FDB 0
03770 	FDB 0
*/
static character_t sDRIVE[] = "\x5" "DRIVE";
definition_header_s hDRIVE = 
{	{ (natural_t) sDRIVE },
	{ 0 },
	{ (natural_t) &hDROFFS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) DRIVE }
};
/*
03780 DRIVE	LDX #DROFFS+7
03800 	LDD #0
03810 DRIVL	ADDD ,X++
03820 	BMI DRIVX table end?
03830 	DEC 1,U
03840 	BPL DRIVL
03850 	SUBD -2,X back one
03860 DRIVX	LDX <UP
03870 	STD UOFFS,X
03890 	LEAU 2,U
03900 	NEXT
04000 *
*/
void DRIVE( void )
{	natural_t offset = 0;
	cell_u * driveSize = hDROFFS.parameterLink + LINEARRAY_DATAOFFSET;	/* False intimate linkage? */
	snatural_t driveCount = SP[ 0 ].sinteger;	/* Messy loop counting induces false interpretation of type. */
	do
	{	offset += ( * driveSize++ ).integer;
	} while ( --driveCount >= 0 );
	offset -= driveSize[ -1 ].integer;	/* Yeah, this was awkward. And this shouldn't be done low level. */
	UP.task->activeDriveOffset.integer = offset;
	++SP;	/* I'll fix this later. */
}


/*
04000 	FCC 'R/W'
04010 	FCB 3
04020 	FCB MFORE
04030 	FDB DRIVE-CFAOFF
04040 	FDB BIF+2
04050 	FDB 0
04060 	FDB 0
*/
static character_t sRW[] = "\x3" "R/W";	/* low level interface */
definition_header_s hRW = 
{	{ (natural_t) sRW },
	{ 0 },
	{ (natural_t) &hDRIVE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) RW }
};
/*
04070 RW	PSHS Y,U,DP
04080 	LDY $C006 control table
04090 	LDX #DROFFS+7
04100 	LDD 2,U
04110 RWD	SUBD ,X++ sectors
04120 	BHS RWD
04130 	BVC RWR table end?
04140 	LDD #6
04150 	PSHU D
04160 	JMP ERROR
04170 RWR	ADDD ,--X back one
04175 	PSHS X
04180 	PSHU D
04190 	LDD #18 sectors/track
04200 	PSHU D
04210 	DOCOL
04220 	FDB SLAMOD
04230 	FDB XMACH
04240 	PULU D
04250 	STB 2,Y track
04260 	PULU D
04265 	INCB
04270 	STB 3,Y sector
04280 	PULS D table entry
04290 	SUBD #DROFFS+7
04300 	ASRB drive #
04310 	STB 1,Y
04320 	LDD 4,U buffer
04330 	STD 4,Y
04340 	LDB #2 coco READ
04350 	LDX ,U 0?
04360 	BNE *+3
04370 	INCB coco WRITE
04380 	STB ,Y op code
04384 	CLRA
04386 	TFR A,DP
04390 	JSR [$C004]	ROM handles timeout
04400 	PULS Y,U,DP	if IRQ enabled
04420 	LEAU 6,U
04430 	LDX $C006
04440 	LDB 6,X coco status
04450 	BEQ RWE
04460 	LDX <UP
04470 	LDD #0 no disc
04480 	STD UWARN,X
04490 	LDD #8
04500 	PSHU D
04510 	JMP ERROR
04520 RWE	NEXT
05000 *
*/
void RW( void )
{	cell_u * driveOffset = hDROFFS.parameterLink + 3;
	int result = 0;
	natural_t writeFlag = SP[ 0 ].integer;
	natural_t blockOffset = SP[ 1 ].integer;
	byte_t * buffer = SP[ 2 ].bytep;
	SP += 3;	/* Want to be able to return at any point. */
	/* I really don't like this loop, any way I look at it, but it will work for now. Want to count it. */
	while ( ( driveOffset->integer < DRIVE_LIST_TERMINATOR ) && ( blockOffset > driveOffset->integer ) )
	{	blockOffset -= driveOffset->integer;	/* Not time-critical, trade readability for speed. */
		driveOffset += ( sizeof (vdrive_a) / sizeof (cell_u) );	/* semi-explicit linkage */
	}
	if ( driveOffset->integer >= DRIVE_LIST_TERMINATOR )
	{	mERROR( DISC_RANGE );
		return;
	}
	if ( driveOffset[ 1 ].filep == NULL )
	{	UP.task->diskOnLine.integer = 0;	/* No disk. */
		mERROR( DISC_ERROR );	/* Want a disk off-line error message. */
		return;
	}
	/* Don't need to back up, since the loop looked ahead. */
	if ( driveOffset[ 1 ].filep != NULL )
	{	result = fseek( driveOffset[ 1 ].filep, blockOffset * hBPBUF.parameterLink[ 0 ].integer, SEEK_SET );
		if ( result == 0 )
		{	if ( writeFlag == 0 )
			{	result = fwrite( buffer, sizeof (char), hBPBUF.parameterLink[ 0 ].integer, driveOffset[ 1 ].filep );
			}
			else
			{	result = fread( buffer, sizeof (char), hBPBUF.parameterLink[ 0 ].integer, driveOffset[ 1 ].filep );
			}
		}
	}
	if ( result != 0 )
	{	mERROR( DISC_ERROR );	/* This is an actual I/O error. */
	}
}
