/* Convert Color Computer 32 column screens to terminated lines.
// Written by Joel Rees, Takino, Hyogo, Japan, May 1997.
// Assigned to the public domain.
// Since it is in the public domain, it can't be copyrighted. 
// If you borrow this code directly, 
// please note the source and the fact that it is public domain in your source code comments.
//
// Current e-mail (January 2000): joel_rees@sannet.ne.jp, reiisi@nettaxi.com
*/

#include <stdio.h>
#include <stdlib.h>	/* for EXIT_SUCCESS */
#include <ctype.h>
/* It's Mac, yess! */
#include <console.h>


const int ScreenWidth = 32;
const int ScreenHeight = 32;
const int BufferWidth = ScreenWidth + 1;	/* room for NUL */




int main(int argc, char * argv[] )
{
	char buffer[ ScreenHeight ][ BufferWidth ];
	FILE * input = stdin;

	/* Use the pseudo-command-line as simple file interface */
	argc = ccommand( &argv );
	if ( argc > 1 )
	{	input = fopen( argv[ 1 ], "rb" );
		if ( input == NULL )
		{	return EXIT_FAILURE;
		}
	}

	while ( !feof( input ) )
	{	int lineCount;
		for ( lineCount = 0; lineCount < ScreenHeight && !feof( input ); ++lineCount )
		{	int length = fread( buffer[ lineCount ], sizeof (char), ScreenWidth, input );
			while ( --length >= 0 
					&& ( isspace( buffer[ lineCount ][ length ] ) 
						 || !isprint( buffer[ lineCount ][ length ] ) ) )
				/* "empty" loop */;
			buffer[ lineCount ][ ++length ] = '\0';
		}
		if ( lineCount > 1 
			 || ( lineCount == 1 && buffer[ 0 ][ 0 ] != '\0' ) )
		{	while ( --lineCount > 0 && buffer[ lineCount ][ 0 ] == '\0' )
				/* "empty" loop */;
			for ( int line = 0; line <= lineCount; ++line )
				puts( buffer[ line ] );
			putchar( '\f' );
		}
	}

	return EXIT_SUCCESS;
}

