/*
**  bifdp_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/07/22.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIFDP/A, as mechanically as possible.
**
*/


#if !defined BIFDP_A_H
#define BIFDP_A_H


#include "bifu_i.h"
#include "bif_m.h"


/* Since this is where most of the inner interpreter got defined, 
** I'll define the virtual machine registers here, too.
** Notes from BIFDOC.TXT:
*******************************************************************************
                        The BIF Virtual Machine

fig     6809
UP      [DP]    pointer to the per-USER variable table (USER Pointer)
IP      Y       pointer to the next definition (Instruction Pointer)
RP      S       return/control stack pointer
SP      U       parameter/data stack pointer
W       [S]     pointer to executing definition's parameter field
*/


extern cell_u	UP;	/* [DP]    pointer to the per-USER variable table (USER Pointer) */
extern cell_u	* IP;	/* Y       Pointer to the next definition to execute (Instruction Pointer). */
extern cell_u	* RP;	/* S       return/control stack pointer */
extern cell_u	* SP;	/* U       parameter/data stack pointer */
/* W was originally (ephemeral) on the 6809 stack because there weren't enough registers. */
/* extern cell_u	W;	/ * [S]     pointer to executing definition's parameter field, now a local register */
extern volatile cell_u	sysSIG;	/* This now primarily records hard exceptions only. */
#define	SYS_SIG_NORMAL	0
#define	SYS_SIG_NORMAL_EXIT	1
#define SYS_SIG_GENERAL_EXCEPTION	-1
#define SYS_SIG_ERROR_EXIT_EXCEPTION	-2
/* If a negative (hard exception) return value is returned, it will be stored here.
*/

#define SPARE_REG_COUNT	8	/* Don't know if these will be useful. */
extern cell_u spares[ SPARE_REG_COUNT ];


/* The inner interpreter.
XNEXT    ( --- )         
	Initiates an inner interpretation loop.
** The inner interpretor performs a C call, 
** so the effective jump back to NEXT is the end of the loop block.
*/
/* Not absorbed into the WARM boot code, after all.
*/
/* extern snatural_t XNEXT ( definition_header_s * wp ); // Don't want this globally known.	*/
#define	ICODE_LIST_CONTINUE		0
#define	ICODE_LIST_EXIT			1
#define	ICODE_LIST_ERROR_EXIT	-1
#if	ICODE_LIST_CONTINUE != SYS_SIG_NORMAL
#	error "Is there a good reason for ICODE_LIST_CONTINUE != SYS_SIG_NORMAL?"
#endif
#if	ICODE_LIST_EXIT != SYS_SIG_NORMAL_EXIT
#	error "Is there a good reason for ICODE_LIST_EXIT != SYS_SIG_NORMAL_EXIT?"
#endif
#if	ICODE_LIST_ERROR_EXIT != SYS_SIG_GENERAL_EXCEPTION
#	error "Is there a good reason for ICODE_LIST_ERROR_EXIT != SYS_SIG_GENERAL_EXCEPTION?"
#endif
#if	ICODE_LIST_CONTINUE != 0
#	error "Is there a good reason for ICODE_LIST_CONTINUE != 0 ?"
#endif
#if	ICODE_LIST_EXIT != 1
#	error "Is there a good reason for ICODE_LIST_EXIT != 1 ?"
#endif
#if	ICODE_LIST_ERROR_EXIT != -1
#	error "Is there a good reason for ICODE_LIST_ERROR_EXIT != -1 ?"
#endif
/* Positive is to quit n levels of list.
** Negative is to throw a hard exception (beyond ERROR). 
*/

/* Nest into an icode list.
XCOL   ( *** IP )
        Characteristic of a colon (:) definition.  Begins execution of a
        non-leaf definition, i. e., nests the definition and begins
        processing icodes. 
*/
extern snatural_t XCOL( definition_header_s * wp );

/* Push the first cell from the parameter field as a constant.
DOCON   ( --- n )
        Characteristic of a CONSTANT.  A CONSTANT simply loads its value
        from its parameter field and pushes it on the stack.
*/
extern snatural_t XCON( definition_header_s * wp );

/* Push the address of the first cell of the parameter field as a variable.
DOVAR   ( --- vadr )    jsr <XVAR (bif.m, bifdp.a)
        Characteristic of a VARIABLE.  A VARIABLE pushes its PFA address
        on the stack.  The parameter field of a VARIABLE is the actual
        allocation of the variable, so that pushing its address allows
        its contents to be @ed (fetched).  Ordinary arrays and strings
        that do not subscript themselves may be allocated by defining a
        variable and immediately ALLOTting the remaining space.
        VARIABLES are global to all users, and thus should have been
        hidden in resource monitors, but aren't.
*/
extern snatural_t XVAR( definition_header_s * wp );

/* Push the address of a the per-task variable, base of USER PAGE + offset.
*/
extern snatural_t XUSER( definition_header_s * wp );

/* Push the address of the element of a 1 dimensional bounded array.
*/
#define LINEARRAY_DATAOFFSET	3	/* Except this really shouldn't be visible, I guess. */
extern snatural_t X1ARR( definition_header_s * wp );

/* Push the value of a user variable as a constant.
*/
extern snatural_t XUCON( definition_header_s * wp );

/* Stores a pointer to itself in the search context root pointer.
*/
extern snatural_t XVOC( definition_header_s * wp );

/* Start into a characteristic that is defined high-level.
*/
extern snatural_t XDOES( definition_header_s * wp );

/* Push the first two cells from the parameter field as a double-width constant.
*/
extern snatural_t XDCON( definition_header_s * wp );

/* C code to call a definition through its header, setting and restoring W.
** But, use mEXEC(), the macro wrapped EXEC(), instead.
snatural_t callDefinition( definition_header_s * headerp );
*/


#endif /* !defined BIFDP_A_H */
