/*
**  bif5b_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/07/24.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF5B/A, as mechanically as possible.
*/

#if !defined BIF5B_A_H
#define BIF5B_A_H


#include <limits.h>


#include "bifu_i.h"


/* #define ARRAY_BOUNDS_ERROR	0xC	//	in tools_g00.h */


extern definition_header_s hIABORT;
/* extern snatural_t IABORT( definition_header_s * wp ); move the longjmp to (HABORT) */
#define IABORT_JMP_FLAG	0x494a	/* int */

/* stub, will take a message number, dump the message to the error console and abort. 
*/
extern definition_header_s hERROR;
/* extern snatural_t ERROR( definition_header_s * wp ); */
/* #define ERROR	mEXECdef( &hERROR ) */

/* Macro to make calling ERROR a little more foolproof.
*/
#define mERROR( number )	\
{	( * --SP ).integer = number;	\
	( * hERROR.codeLink.icode )( &hERROR ); /* mCALLdef( &hERROR ); */	\
	return SYS_SIG_ERROR_EXIT_EXCEPTION;	/* ERROR should longjmp out of here through QUIT or ABORT. */ \
}

#define ERROR_ABORT_FLAG	ULONG_HIGH_BIT

extern definition_header_s hEDITOR;

extern definition_header_s hQSYNC;
extern snatural_t QSYNC( definition_header_s * wp );

extern definition_header_s hEBLK;

extern definition_header_s hCURSOR;

extern definition_header_s hQDUMP;
extern snatural_t QDUMP( definition_header_s * wp );

extern definition_header_s hQARROW;
extern snatural_t QARROW( definition_header_s * wp );


#endif /* !defined BIF5B_A_H */
