/*
**  bif3_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF3/A, as mechanically as possible.
*/


#if !defined BIF3_A_H
#define BIF3_A_H


#include "bifu_i.h"


extern definition_header_s hLATEST;

extern definition_header_s hLFA;	/* Convert header address to LFA. */
extern snatural_t LFA( definition_header_s * wp );

extern definition_header_s hCFA;	/* Convert header address to CFA. */
extern snatural_t CFA( definition_header_s * wp );

extern definition_header_s hGFA;	/* Convert header address to GFA. */
extern snatural_t GFA( definition_header_s * wp );

extern definition_header_s hPFA;	/* Convert header address to PFA. */
extern snatural_t PFA( definition_header_s * wp );

extern definition_header_s hNFA;	/* Convert PFA to header address. */
extern snatural_t NFA( definition_header_s * wp );

extern definition_header_s hSTOCSP;
extern snatural_t STOCSP( definition_header_s * wp );

extern definition_header_s hHEX;
extern snatural_t HEX( definition_header_s * wp );

extern definition_header_s hDEC;
extern snatural_t DEC( definition_header_s * wp );

extern definition_header_s hOCT;
extern snatural_t OCT( definition_header_s * wp );

extern definition_header_s hFILL;
extern snatural_t FILL( definition_header_s * wp );

extern definition_header_s hERASE;
extern snatural_t ERASE( definition_header_s * wp );

extern definition_header_s hBLANKS;
extern snatural_t BLANKS( definition_header_s * wp );

extern definition_header_s hHOLD;
extern snatural_t HOLD( definition_header_s * wp );

extern definition_header_s hPAD;

extern definition_header_s hSTOD;
extern snatural_t STOD( definition_header_s * wp );

extern definition_header_s hCHS;
extern snatural_t CHS( definition_header_s * wp );

extern definition_header_s hDCHS;
extern snatural_t DCHS( definition_header_s * wp );

extern definition_header_s hABS;
extern snatural_t ABS( definition_header_s * wp );

extern definition_header_s hDABS;
extern snatural_t DABS( definition_header_s * wp );

extern definition_header_s hMIN;
extern snatural_t MIN( definition_header_s * wp );

extern definition_header_s hMAX;
extern snatural_t MAX( definition_header_s * wp );

extern definition_header_s hLBRAK;
extern snatural_t LBRAK( definition_header_s * wp );

extern definition_header_s hRBRAK;
extern snatural_t RBRAK( definition_header_s * wp );


#define toggleDefinitionState( bit )	UP.task->lastDefined.integer ^= bit
extern definition_header_s hIMMED;
extern snatural_t IMMED( definition_header_s * wp );

extern definition_header_s hSMUDGE;
extern snatural_t SMUDGE( definition_header_s * wp );

extern definition_header_s hCOMPO;
extern snatural_t COMPO( definition_header_s * wp );

extern definition_header_s hCOUNT;
extern snatural_t COUNT( definition_header_s * wp );

extern definition_header_s hDTRAIL;
extern snatural_t DTRAIL( definition_header_s * wp );

extern definition_header_s hXMACH;
extern snatural_t XMACH( definition_header_s * wp );


#endif /* !defined BIF3_A_H */
