/*
**  bif2b_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/08/03.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF2B/A, as mechanically as possible.
*/


#if !defined BIF2B_A_H
#define BIF2B_A_H


#include "bifu_i.h"


#include "bif5b_a.h"	/* for mERROR */


extern definition_header_s hHERE;
extern snatural_t HERE( definition_header_s * wp );
/*
05100 HERE	LDX <UP
05110 	LDD UDP,X
05120 	PSHU D
05122 HERERR	LDX <UP
05124 	CMPU UDP,X
05128 	BLS ALLERR
05130 	NEXT
05132 ALLERR	LDD #2
05134 	PSHU D
05136 	JMP ERROR
05140 *
** HERERR and ALLERR are converted to macros.
*/

#define HERERR	/* Check allocation limits. */		\
	if ( UP.task->dictionaryAllocationPointer.cellp + 10 >= SP )	/* Probably want to buffer this, really. */	\
		ALLERR;	

#define ALLERR	mERROR( 2 );	/* Report allocation errors. */

extern definition_header_s hALLOT;
extern snatural_t ALLOT( definition_header_s * wp );

extern definition_header_s hCOMMA;
extern snatural_t COMMA( definition_header_s * wp );

extern definition_header_s hCCOMMA;
extern snatural_t CCOMMA( definition_header_s * wp );

extern definition_header_s hSPACE;
extern snatural_t SPACE( definition_header_s * wp );

extern definition_header_s hDDUP;
extern snatural_t DDUP( definition_header_s * wp );

extern definition_header_s hQCST;
extern snatural_t QCST( definition_header_s * wp );

/* I eventually want to make this byte-order independent. 
*/
#define	IF_FLAG	( ( 'I' << 24 ) + ( 'F' << 16 ) + ( 'E' << 8 ) + 'L' )
/* #define	IF_FLAG	( 'IFEL' ) */

extern definition_header_s hIF;

extern definition_header_s hELSE;

extern definition_header_s hENDIF;


#endif /* !defined BIF2B_A_H */
