/*
**  bif2_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/07/25.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF2/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bif7b_a.h"	/* To link into the BIF vocabulary. */

#include "bifst_a.h"
#include "bif2_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
01000 	FCC '1+'
01010 	FCB 2
01020 	FCB MFORE
01030 	FDB SWAN-CFAOFF
01040 	FDB BIF+2
01050 	FDB ZLESS-CFAOFF
01060 	FDB ADD2-CFAOFF
*/
static character_t sADD1[] = "\x2" "1+";
definition_header_s hADD1 =
{	{ (natural_t) sADD1 },
	{ 0 },
	{ (natural_t) &hSWAN },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hZLESS },
	{ (natural_t) &hADD2 },
	{ (natural_t) ADD1 }
};
/*
01070 ADD1	LDD #1
01080 	ADDTOP
01110 *
*/
snatural_t ADD1( definition_header_s * wp )
{	ADDTOP( 1 );
}


/*
01120 	FCC '1-'
01130 	FCB 2
01140 	FCB MFORE
01150 	FDB ADD1-CFAOFF
01160 	FDB BIF+2
01170 	FDB 0
01180 	FDB 0
*/
static character_t sSUB1[] = "\x2" "1-";
definition_header_s hSUB1 =
{	{ (natural_t) sSUB1 },
	{ 0 },
	{ (natural_t) &hADD1 },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) SUB1 }
};
/*
01190 SUB1	LDD #-1
01200 	ADDTOP
01230 *
*/
snatural_t SUB1( definition_header_s * wp )
{	ADDTOP( -1 );
}


/*
01240 	FCC '2+'
01250 	FCB 2
01260 	FCB MFORE
01270 	FDB SUB1-CFAOFF
01280 	FDB BIF+2
01290 	FDB TWO-CFAOFF
01300 	FDB RSHIFT-CFAOFF
*/
static character_t sADD2[] = "\x2" "2+";
definition_header_s hADD2 =
{	{ (natural_t) sADD2 },
	{ 0 },
	{ (natural_t) &hSUB1 },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hTWO },
	{ (natural_t) &hRSHIFT },
	{ (natural_t) ADD2 }
};
/*
01310 ADD2	LDD #2
01320 	ADDTOP
01330 *
*/
snatural_t ADD2( definition_header_s * wp )
{	ADDTOP( 2 );
}


/*
01340 	FCC '2-'
01350 	FCB 2
01360 	FCB MFORE
01370 	FDB ADD2-CFAOFF
01380 	FDB BIF+2
01390 	FDB 0
01400 	FDB 0
*/
static character_t sSUB2[] = "\x2" "2-";
definition_header_s hSUB2 =
{	{ (natural_t) sSUB2 },
	{ 0 },
	{ (natural_t) &hADD2 },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) SUB2 }
};
/*
01410 SUB2	LDD #-2
01420 	ADDTOP
01430 *
*/
snatural_t SUB2( definition_header_s * wp )
{	ADDTOP( -2 );
}


/*
01440 	FCC '0'
01450 	FCB 1
01460 	FCB MFORE
01470 	FDB SUB2-CFAOFF
01480 	FDB BIF+2
01490 	FDB SLAMOD-CFAOFF
01500 	FDB INULL-CFAOFF
*/
static character_t sZERO[] = "\x1" "0";
definition_header_s hZERO =
{	{ (natural_t) sZERO },
	{ 0 },
	{ (natural_t) &hSUB2 },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hSLAMOD },
	{ (natural_t) &hINULL },
	{ (natural_t) XCON },
	{	{ 0 }	}	/* Not really trying for speed here, but we could see if code to push is faster. */
};
/*
01510 ZERO	LDD #0
01520 	PSHU D
01530 	NEXT
01540 *
*/


/*
01550 	FCC '1'
01560 	FCB 1
01570 	FCB MFORE
01580 	FDB ZERO-CFAOFF
01590 	FDB BIF+2
01600 	FDB ZBR-CFAOFF
01610 	FDB 0
*/
static character_t sONE[] = "\x1" "1";
definition_header_s hONE =
{	{ (natural_t) sONE },
	{ 0 },
	{ (natural_t) &hZERO },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hZBR },
	{ 0 },
	{ (natural_t) XCON },
	{	{ 1 }	}
};
/*
01620 ONE	LDD #1
01630 	PSHU D
01640 	NEXT
01650 *
*/


/*
01660 	FCC '-1'
01670 	FCB 2
01680 	FCB MFORE
01690 	FDB ONE-CFAOFF
01700 	FDB BIF+2
01710 	FDB 0
01720 	FDB DDFIND-CFAOFF
*/
static character_t sMONE[] = "\x2" "-1";
definition_header_s hMONE =
{	{ (natural_t) sMONE },
	{ 0 },
	{ (natural_t) &hONE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hDDFIND },
	{ (natural_t) XCON },
	{	{ -1 }	}
};
/*
01730 MONE	LDD #-1
01740 	PSHU D
01750 	NEXT
01760 *
*/


/*
01770 	FCC '2'
01780 	FCB 1
01790 	FCB MFORE
01800 	FDB MONE-CFAOFF
01810 	FDB BIF+2
01820 	FDB ONEARR-CFAOFF
01830 	FDB LSHIFT-CFAOFF
**
** This is used as a substitute for the width of an address word.
** Need a constant for that.
*/
static character_t sTWO[] = "\x1" "2";
definition_header_s hTWO =
{	{ (natural_t) sTWO },
	{ 0 },
	{ (natural_t) &hMONE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hONEARR },
	{ (natural_t) &hLSHIFT },
	{ (natural_t) XCON },
	{	{ 2 }	}
};
/*
01840 TWO	DOCON
01850 	FDB 2
01860 *
*/


/*
01870 	FCC '3'
01880 	FCB 1
01890 	FCB MFORE
01895 	FDB TWO-CFAOFF
01900 	FDB BIF+2
01910 	FDB 0
01920 	FDB 0
*/
static character_t sTHREE[] = "\x1" "3";
definition_header_s hTHREE =
{	{ (natural_t) sTHREE },
	{ 0 },
	{ (natural_t) &hTWO },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCON },
	{	{ 3 }	}
};
/*
01930 THREE	DOCON
01940 	FDB 3
01950 *
*/


/*
01960 	FCC 'BL'
01970 	FCB 2
01980 	FCB MFORE
01990 	FDB THREE-CFAOFF
02000 	FDB BIF+2
02010 	FDB 0
02020 	FDB 0
*/
static character_t sBL[] = "\x2" "BL";
definition_header_s hBL =
{	{ (natural_t) sBL },
	{ 0 },
	{ (natural_t) &hTHREE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCON },
	{	{ ' ' }	}	/* SPACE character */
};
/*
02030 BL	DOCON
02040 	FDB $20 ascii SP
02050 *
*/


/*
02060 	FCC 'C/L'
02070 	FCB 3
02080 	FCB MFORE
02090 	FDB BL-CFAOFF
02100 	FDB BIF+2
02110 	FDB 0
02120 	FDB 0
*/
static character_t sCPERL[] = "\x3" "C/L";
definition_header_s hCPERL =
{	{ (natural_t) sCPERL },
	{ 0 },
	{ (natural_t) &hBL },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUCON },
	{	{ UCOLUM }	}	/* SPACE character */
};
/*
02130 CPERL	DOUCON
02140 	FCB UCOLUM
02170 *
*/


/*
02180 	FCC 'FIRST'
02190 	FCB 5
02200 	FCB MFORE
02210 	FDB CPERL-CFAOFF
02220 	FDB BIF+2
02230 	FDB 0
02240 	FDB FLD-CFAOFF
*/
static character_t sFIRST[] = "\x5" "FIRST";
definition_header_s hFIRST =
{	{ (natural_t) sFIRST },
	{ 0 },
	{ (natural_t) &hCPERL },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hFLD },
	{ (natural_t) XUCON },
	{	{ UFIRST }	}	/* pseudo-constant */
};
/*
02250 FIRST	DOUCON
02260 	FCB UFIRST
02290 *
*/


/*
02300 	FCC 'LIMIT'
02310 	FCB 5
02320 	FCB MFORE
02330 	FDB FIRST-CFAOFF
02340 	FDB BIF+2
02350 	FDB LEAVE-CFAOFF
02360 	FDB LITER-CFAOFF
*/
static character_t sLIMIT[] = "\x5" "LIMIT";
definition_header_s hLIMIT =
{	{ (natural_t) sLIMIT },
	{ 0 },
	{ (natural_t) &hFIRST },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hLEAVE },
	{ (natural_t) &hLITER },
	{ (natural_t) XUCON },
	{	{ ULIMIT }	}
};
/*
02370 LIMIT	DOUCON
02380 	FCB ULIMIT
02400 *
*/


/*
02410 BWID	EQU 256 bytes
02420 	FCC 'B/BUF'
02430 	FCB 5
02440 	FCB MFORE
02450 	FDB LIMIT-CFAOFF
02460 	FDB BIF+2
02470 	FDB ASMBLR-CFAOFF
02480 	FDB BPSCR-CFAOFF
*/
static character_t sBPBUF[] = "\x5" "B/BUF";
definition_header_s hBPBUF =
{	{ (natural_t) sBPBUF },
	{ 0 },
	{ (natural_t) &hLIMIT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hASMBLR },
	{ (natural_t) &hBPSCR },
	{ (natural_t) XCON },
	{	{ BWID }	}
};
/*
02490 BPBUF	DOCON
02500 	FDB BWID
02510 *
*/


/*
02520 BCT	EQU 4 buffers
02520 	FCC 'B/SCR'
02530 	FCB 5
02540 	FCB MFORE
02550 	FDB BPBUF-CFAOFF
02560 	FDB BIF+2
02570 	FDB 0
02580 	FDB 0
*/
static character_t sBPSCR[] = "\x5" "B/SCR";
definition_header_s hBPSCR =
{	{ (natural_t) sBPSCR },
	{ 0 },
	{ (natural_t) &hBPBUF },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCON },
	{	{ BCT }	}
};
/*
02590 BPSCR	DOCON
02600 	FDB BCT
02610 *
*/


/*
02620 	FCC '+ORIGIN'
02630 	FCB 7
02640 	FCB MFORE
02650 	FDB BPSCR-CFAOFF
02660 	FDB BIF+2
02670 	FDB 0
02680 	FDB 0
*/
static character_t sPORIG[] = "\x7" "+ORIGIN";
definition_header_s hPORIG =
{	{ (natural_t) sPORIG },
	{ 0 },
	{ (natural_t) &hBPSCR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) PORIG }
};
/*
02690 PORIG	LDD #ORIG
02700 	LBRA ADD+2
02710 *
*/
snatural_t PORIG( definition_header_s * wp )
{	/* Can't recall any reason for jumping into ADD rather than invoking the macro. 
	** Moreover, the order of operands looks kind of wrong for the type promotion.
	*/
	/* ADDTOP( (natural_t) &ORIG ); This ought to work, really. */
	( * SP ).bytep = ( (byte_p) &ORIG ) +  ( * SP ).integer;
}

/*
02715 * some USER vars hidden
02720 * fig-FORTH USER vars not present:
02722 * WIDTH VOC-LINK CONTEXT CURRENT
02724 *
*/


/*
02730 	FCC 'TIB'
02740 	FCB 3
02750 	FCB MFORE
02760 	FDB PORIG-CFAOFF
02770 	FDB BIF+2
02780 	FDB 0
02790 	FDB 0
*/
static character_t sTIB[] = "\x3" "TIB";
definition_header_s hTIB =
{	{ (natural_t) sTIB },
	{ 0 },
	{ (natural_t) &hPORIG },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UTIB }	}
};
/*
02800 TIB	DOUSER
02810 	FCB UTIB
02820 *
*/


/*
02930 	FCC 'WARNING'
02940 	FCB 7
02950 	FCB MFORE
02960 	FDB TIB-CFAOFF
02970 	FDB BIF+2
02980 	FDB 0
02990 	FDB 0
*/
static character_t sWARN[] = "\x7" "WARNING";
definition_header_s hWARN =
{	{ (natural_t) sWARN },
	{ 0 },
	{ (natural_t) &hTIB },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UWARN }	}
};
/*
03000 WARN	DOUSER
03010 	FCB UWARN
03020 *
*/


/*
03030 	FCC 'FENCE'
03040 	FCB 5
03050 	FCB MFORE
03060 	FDB WARN-CFAOFF
03070 	FDB BIF+2
03080 	FDB 0
03090 	FDB 0
*/
static character_t sFENCE[] = "\x5" "FENCE";
definition_header_s hFENCE =
{	{ (natural_t) sFENCE },
	{ 0 },
	{ (natural_t) &hWARN },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UFENCE }	}
};
/*
03100 FENCE	DOUSER
03110 	FCB UFENCE
03120 *
*/


/*
03130 	FCC 'DP'
03140 	FCB 2
03150 	FCB MFORE
03160 	FDB FENCE-CFAOFF
03170 	FDB BIF+2
03180 	FDB DOES-CFAOFF
03190 	FDB 0
*/
static character_t sDPC[] = "\x2" "DP";
definition_header_s hDPC =
{	{ (natural_t) sDPC },
	{ 0 },
	{ (natural_t) &hFENCE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDOES },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UDP }	}
};
/*
03200 DPC	DOUSER
03210 	FCB UDP
03220 *
*/


/*
03230 	FCC 'ROOT'
03240 	FCB 4
03250 	FCB MFORE
03260 	FDB DPC-CFAOFF
03270 	FDB BIF+2
03280 	FDB 0
03290 	FDB 0
*/
static character_t sROOT[] = "\x4" "ROOT";
definition_header_s hROOT =
{	{ (natural_t) sROOT },
	{ 0 },
	{ (natural_t) &hDPC },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UROOT }	}	/* not fig */
};
/*
03300 ROOT	DOUSER	not fig
03310 	FCB UROOT
03320 *
*/


/*
03330 	FCC 'BLK'
03340 	FCB 3
03350 	FCB MFORE
03360 	FDB ROOT-CFAOFF
03370 	FDB BIF+2
03380 	FDB BLANKS-CFAOFF
03390 	FDB BLOCK-CFAOFF
*/
static character_t sBLK[] = "\x3" "BLK";
definition_header_s hBLK =
{	{ (natural_t) sBLK },
	{ 0 },
	{ (natural_t) &hROOT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hBLANKS },
	{ (natural_t) &hBLOCK },
	{ (natural_t) XUSER },
	{	{ UBLK }	}
};
/*
03400 BLK	DOUSER
03410 	FCB UBLK
03420 *
*/


/*
03430 	FCC 'IN'
03440 	FCB 2
03450 	FCB MFORE
03460 	FDB BLK-CFAOFF
03470 	FDB BIF+2
03480 	FDB IMMED-CFAOFF
03490 	FDB INTERP-CFAOFF
*/
static character_t sIN[] = "\x2" "IN";
definition_header_s hIN =
{	{ (natural_t) sIN },
	{ 0 },
	{ (natural_t) &hBLK },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hIMMED },
	{ (natural_t) &hINTERP },
	{ (natural_t) XUSER },
	{	{ UIN }	}
};
/*
03500 IN	DOUSER
03510 	FCB UIN
03520 *
*/


/*
03530 	FCC 'OUT'
03540 	FCB 3
03550 	FCB MFORE
03560 	FDB IN-CFAOFF
03570 	FDB BIF+2
03580 	FDB 0
03590 	FDB 0
*/
static character_t sOUT[] = "\x3" "OUT";
definition_header_s hOUT =
{	{ (natural_t) sOUT },
	{ 0 },
	{ (natural_t) &hIN },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UOUT }	}
};
/*
03600 OUT	DOUSER
03610 	FCB UOUT
03620 *
*/


/*
03630 	FCC 'SCR'
03640 	FCB 3
03650 	FCB MFORE
03660 	FDB OUT-CFAOFF
03670 	FDB BIF+2
03680 	FDB 0
03690 	FDB 0
*/
static character_t sSCR[] = "\x3" "SCR";
definition_header_s hSCR =
{	{ (natural_t) sSCR },
	{ 0 },
	{ (natural_t) &hOUT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ USCR }	}
};
/*
03700 SCR	DOUSER
03710 	FCB USCR
03720 *
*/


/*
03730 	FCC 'OFFSET'
03740 	FCB 6
03750 	FCB MFORE
03760 	FDB SCR-CFAOFF
03770 	FDB BIF+2
03780 	FDB 0
03790 	FDB 0
*/
static character_t sOFFSET[] = "\x6" "OFFSET";
definition_header_s hOFFSET =
{	{ (natural_t) sOFFSET },
	{ 0 },
	{ (natural_t) &hSCR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UOFFS }	}
};
/*
03800 OFFSET	DOUSER
03810 	FCB UOFFS
03820 *
*/


/*
03830 	FCC 'STATE'
03840 	FCB 5
03850 	FCB MFORE
03860 	FDB OFFSET-CFAOFF
03870 	FDB BIF+2
03880 	FDB SPACES-CFAOFF
03890 	FDB SWAB-CFAOFF
*/
static character_t sSTATE[] = "\x5" "STATE";
definition_header_s hSTATE =
{	{ (natural_t) sSTATE },
	{ 0 },
	{ (natural_t) &hOFFSET },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hSPACES },
	{ (natural_t) &hSWAB },
	{ (natural_t) XUSER },
	{	{ USTATE }	}
};
/*
03900 STATE	DOUSER
03910 	FCB USTATE
03920 *
*/


/*
03930 	FCC 'BASE'
03940 	FCB 4
03950 	FCB MFORE
03960 	FDB STATE-CFAOFF
03970 	FDB BIF+2
03980 	FDB 0
03990 	FDB 0
*/
static character_t sBASE[] = "\x4" "BASE";
definition_header_s hBASE =
{	{ (natural_t) sBASE },
	{ 0 },
	{ (natural_t) &hSTATE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UBASE }	}
};
/*
04000 BASE	DOUSER
04010 	FCB UBASE
04020 *
*/


/*
04030 	FCC 'DPL'
04040 	FCB 3
04050 	FCB MFORE
04060 	FDB BASE-CFAOFF
04070 	FDB BIF+2
04080 	FDB DPC-CFAOFF
04090 	FDB DROFFS-CFAOFF
*/
static character_t sDPL[] = "\x3" "DPL";
definition_header_s hDPL =
{	{ (natural_t) sDPL },
	{ 0 },
	{ (natural_t) &hBASE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDPC },
	{ (natural_t) &hDROFFS },
	{ (natural_t) XUSER },
	{	{ UDPL }	}
};
/*
04100 DPL	DOUSER
04110 	FCB UDPL
04120 *
*/


/*
04130 	FCC 'FLD'
04140 	FCB 3
04150 	FCB MFORE
04160 	FDB DPL-CFAOFF
04170 	FDB BIF+2
04180 	FDB 0
04190 	FDB 0
*/
static character_t sFLD[] = "\x3" "FLD";
definition_header_s hFLD =
{	{ (natural_t) sFLD },
	{ 0 },
	{ (natural_t) &hDPL },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UFLD }	}
};
/*
04200 FLD	DOUSER
04210 	FCB UFLD
04220 *
*/


/*
04230 	FCC 'CSP'
04240 	FCB 3
04250 	FCB MFORE
04260 	FDB FLD-CFAOFF
04270 	FDB BIF+2
04280 	FDB 0
04290 	FDB CURR-CFAOFF
*/
static character_t sCSP[] = "\x3" "CSP";
definition_header_s hCSP =
{	{ (natural_t) sCSP },
	{ 0 },
	{ (natural_t) &hFLD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hCURR },
	{ (natural_t) XUSER },
	{	{ UCSP }	}
};
/*
04300 CSP	DOUSER
04310 	FCB UCSP
04320 *
*/


/*
04330 	FCC 'R#'
04340 	FCB 2
04350 	FCB MFORE
04360 	FDB CSP-CFAOFF
04370 	FDB BIF+2
04380 	FDB 0
04390 	FDB RW-CFAOFF
*/
static character_t sRNUM[] = "\x2" "R#";
definition_header_s hRNUM =
{	{ (natural_t) sRNUM },
	{ 0 },
	{ (natural_t) &hCSP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hRW },
	{ (natural_t) XUSER },
	{	{ URNUM }	}
};
/*
04400 RNUM	DOUSER
04410 	FCB URNUM
04420 *
*/


/*
04430 	FCC 'HLD'
04440 	FCB 3
04450 	FCB MFORE
04460 	FDB RNUM-CFAOFF
04470 	FDB BIF+2
04480 	FDB HEX-CFAOFF
04490 	FDB HOLD-CFAOFF
*/
static character_t sHLD[] = "\x3" "HLD";
definition_header_s hHLD =
{	{ (natural_t) sHLD },
	{ 0 },
	{ (natural_t) &hRNUM },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hHEX },
	{ (natural_t) &hHOLD },
	{ (natural_t) XUSER },
	{	{ UHLD }	}
};
/*
04500 HLD	DOUSER
04510 	FCB UHLD
04520 *
*/


/*
04530 	FCC 'FOREWARD'
04540 	FCB 8
04550 	FCB MFORE
04560 	FDB HLD-CFAOFF
04570 	FDB BIF+2
04580 	FDB 0
04590 	FDB 0
*/
static character_t sFORE[] = "\x8" "FOREWARD";
definition_header_s hFORE =
{	{ (natural_t) sFORE },
	{ 0 },
	{ (natural_t) &hHLD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UFORE }	}	/* not fig */
};
/*
04600 FORE	DOUSER	not fig
04610 	FCB UFORE
04620 *
*/


/*
04630 	FCC 'CURRENT'
04640 	FCB 7
04650 	FCB MFORE
04660 	FDB FORE-CFAOFF
04670 	FDB BIF+2
04680 	FDB 0
04690 	FDB 0
*/
static character_t sCURR[] = "\x7" "CURRENT";
definition_header_s hCURR =
{	{ (natural_t) sCURR },
	{ 0 },
	{ (natural_t) &hFORE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UCURR }	}	/* not fig */
};
/*
04700 CURR	DOUSER	not fig
04710 	FCB UCURR
04720 *
*/


/*
04730 	FCC 'PREV'
04740 	FCB 4
04750 	FCB MFORE
04760 	FDB CURR-CFAOFF
04770 	FDB BIF+2
04780 	FDB 0
04790 	FDB 0
*/
static character_t sPREV[] = "\x4" "PREV";
definition_header_s hPREV =
{	{ (natural_t) sPREV },
	{ 0 },
	{ (natural_t) &hCURR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UPREV }	}	/* moved */
};
/*
04800 PREV	DOUSER	moved
04810 	FCB UPREV
04820 *
*/


/*
04830 	FCC 'USE'
04840 	FCB 3
04850 	FCB MFORE
04860 	FDB PREV-CFAOFF
04870 	FDB BIF+2
04880 	FDB 0
04890 	FDB 0
*/
static character_t sUSE[] = "\x3" "USE";
definition_header_s hUSE =
{	{ (natural_t) sUSE },
	{ 0 },
	{ (natural_t) &hPREV },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UUSE }	}	/* moved */
};
/*
04900 USE	DOUSER	moved
04910 	FCB UUSE
04920 *
*/


/*
04930 	FCC 'DROOT'
04940 	FCB 5
04950 	FCB MFORE
04960 	FDB USE-CFAOFF
04970 	FDB BIF+2
04980 	FDB 0
04990 	FDB 0
*/
static character_t sDROOT[] = "\x5" "DROOT";
definition_header_s hDROOT =
{	{ (natural_t) sDROOT },
	{ 0 },
	{ (natural_t) &hUSE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUSER },
	{	{ UDROOT }	}	/* not fig */
};
/*
05000 DROOT	DOUSER	not fig
05010 	FCB UDROOT
05020 *
*/
