/*
 *  bif6b_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/07/29.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF6B/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bif7b_a.h"	/* To link into the BIF vocabulary. */
#include "bif6b_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
05200 	FCC 'NAME,'
05210 	FCB 5
05220 	FCB MFORE
05230 	FDB DIFIND-CFAOFF
05240 	FDB BIF+2
05250 	FDB 0
05260 	FDB 0
*/
static character_t sNCOMMA[] = "\x5" "NAME,";
definition_header_s hNCOMMA = 
{	{ (natural_t) sNCOMMA },
	{ 0 },
	{ (natural_t) &hDIFIND },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL },
/*
05270 NCOMMA	DOCOL
05280 	FDB WORDPD
05300 	FDB COUNT
05310 	FDB TOR
05330 	FDB HERE
05340 	FDB R
05350 	FDB ALLOT
05360 	FDB R
05370 	FDB CMOVE name
05380 	FDB HERE node
05390 	FDB RFROM
05400 	FDB SEMIS
05490 *
*/
	{
		{ (natural_t) &hWORDPD	},
		{ (natural_t) &hCOUNT	},
		{ (natural_t) &hTOR	},
		{ (natural_t) &hHERE	},
		{ (natural_t) &hR	},
		{ (natural_t) &hALLOT	},
		{ (natural_t) &hR	},
		{ (natural_t) &hCMOVE	},	/* name */
		{ (natural_t) &hHERE	},	/* node */
		{ (natural_t) &hRFROM	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
05500 	FCC 'FORE-MARK'
05510 	FCB 9
05520 	FCB MFORE
05530 	FDB NCOMMA-CFAOFF
05540 	FDB BIF+2
05550 	FDB FIRST-CFAOFF
05560 	FDB FORGET-CFAOFF
*/
static character_t sFOREMK[] = "\x9" "FORE-MARK";
definition_header_s hFOREMK = 
{	{ (natural_t) sFOREMK },
	{ 0 },
	{ (natural_t) &hNCOMMA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hFIRST },
	{ (natural_t) &hFORGET },
	{ (natural_t) FOREMK }
};
/*
05570 FOREMK	LDX <UP
05580 	LDD UFORE,X
05590 	BEQ FOREMN
05600 	LDX UCURR,X
05610 	LDB 1,X
05620 	ORB #MFORE
05630 	STB 1,X
05640 FOREMN	NEXT
05690 *
*/
void FOREMK( void )
{	if ( UP.task->forewardBlock.integer != 0 )
	{	( * UP.task->lastDefined.cellp ).integer |= MFORE;
	}
}


/*
05700 	FCC '(INSTALL)'
05710 	FCB MCOMP.OR.9
05720 	FCB MFORE
05730 	FDB DIFIND-CFAOFF
05740 	FDB BIF+2
05750 	FDB 0
05760 	FDB 0
*/
static character_t sPINSTA[] = "\x9" "(INSTALL)";
definition_header_s hPINSTA = 
{	{ (natural_t) sPINSTA },
	{ MCOMP },
	{ (natural_t) &hFOREMK },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) PINSTA }
};
/*
05770 PINSTA	LDX ,U vocab
05772 	BNE PINSTV
05774 	LDD #$18
05776 	PSHU D
05778 	JMP ERROR
05780 PINSTV	PSHS Y
05784 	LDY 2,U nfa
05788 	LDB ,Y
05792 	ANDB #NLMASK
05796 	TFR B,A
05800 	NEGA
05804 	LEAY A,Y name
05808 	DECA for NUL
05812 	LEAS A,S allocate
05816 	CLRA
05820 	STA B,S term
05824 	PSHU Y
05828 	PSHU D,S
05832 	PSHS B mark
05836 	DOCOL
05840 	FDB CMOVE
05844 	FDB XMACH
05848 	LDX ,U vocab
05852 	LEAY 1,S
05856 PINSTL	PSHU X,Y
05860 	DOCOL
05864 	FDB PFIND slot?
05868 	FDB XMACH
05872 	LDD ,U++ flag
05876 	BEQ PINSTI
05880 	LDX [,U++] old nfa
05884 	CMPX #NUBLK-CFAOFF
05888 	BNE *+7
05892 	LDD #$1C
05896 	BRA PINSTV-5
05900 	LDB ,X
05904 	ORB #MHID hide old
05908 	STB ,X
05912 	LEAX RTOFF,X fake voc
05916 	BRA PINSTL
05920 PINSTI	PULS B
05924 	INCB
05928 	LEAS B,S
05932 	LDX ,U insert point
05936 	BNE PINSTG
05940 	LDD #$19
05944 	BRA PINSTV-5
05948 PINSTG	LDD 2,U vocab
05952 	LDY 4,U nfa
05956 	STY ,X link in
05960 	STD GFAOFF,Y
05964 PINSTX	LEAU 6,U
05970 	PULS Y
05980 	NEXT
06290 *
*/
void PINSTA( void )
{
	if ( SP[ 0 ].integer == 0 )
	{	mERROR( DECLARE_VOCABULARY );
		return;
	}
	
/*
05780 PINSTV	PSHS Y
05784 	LDY 2,U nfa
05788 	LDB ,Y
05792 	ANDB #NLMASK
05796 	TFR B,A
05800 	NEGA
05804 	LEAY A,Y name
05808 	DECA for NUL
05812 	LEAS A,S allocate
05816 	CLRA
05820 	STA B,S term
05824 	PSHU Y
05828 	PSHU D,S
05832 	PSHS B mark
05836 	DOCOL
05840 	FDB CMOVE
05844 	FDB XMACH
05848 	LDX ,U vocab
05852 	LEAY 1,S
05856 PINSTL	PSHU X,Y
05860 	DOCOL
05864 	FDB PFIND slot?
05868 	FDB XMACH
05872 	LDD ,U++ flag
05876 	BEQ PINSTI
05880 	LDX [,U++] old nfa
05884 	CMPX #NUBLK-CFAOFF
05888 	BNE *+7
05892 	LDD #$1C
05896 	BRA PINSTV-5
05900 	LDB ,X
05904 	ORB #MHID hide old
05908 	STB ,X
05912 	LEAX RTOFF,X fake voc
05916 	BRA PINSTL
05920 PINSTI	PULS B
05924 	INCB
05928 	LEAS B,S
05932 	LDX ,U insert point
05936 	BNE PINSTG
05940 	LDD #$19
05944 	BRA PINSTV-5
05948 PINSTG	LDD 2,U vocab
05952 	LDY 4,U nfa
05956 	STY ,X link in
05960 	STD GFAOFF,Y
05964 PINSTX	LEAU 6,U
05970 	PULS Y
05980 	NEXT
06290 *
*/
}


/*
06300 	FCC '0!'
06310 	FCB 2
06320 	FCB MFORE
06330 	FDB PINSTA-CFAOFF
06340 	FDB BIF+2
06350 	FDB 0
06360 	FDB 0
*/
static character_t sINULL[] = "\x2" "0!";
definition_header_s hINULL = 
{	{ (natural_t) sINULL },
	{ 0 },
	{ (natural_t) &hPINSTA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) INULL }
};
/*
06370 INULL	LDD #0
06380 	STD >0
06390 	NEXT
06395 *
*/
void INULL( void )
{	
#if !defined SYSTEM_TRAPS_NULLS
	* ( (natural_t * ) 0 ) = 0;
#endif
}


/*
06400 	FCC '?0'
06410 	FCB 2
06420 	FCB MFORE
06430 	FDB INULL-CFAOFF
06440 	FDB BIF+2
06450 	FDB 0
06460 	FDB 0
*/
static character_t sTNULL[] = "\x2" "?0";
definition_header_s hTNULL = 
{	{ (natural_t) sTNULL },
	{ 0 },
	{ (natural_t) &hINULL },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) TNULL }
};
/*
06470 TNULL	LDD >0
06480 	BNE *+4
06490 	NEXT
06500 	LDD #5
06510 	PSHU D
06520 	LDX <UP
06530 	LDA UWARN,X
06540 	ORA #$80 abort
06550 	STA UWARN,X
06560 	JMP ERROR
06590 *
*/
void TNULL( void )
{
#if !defined SYSTEM_TRAPS_NULLS
	if ( * ( (natural_t * ) 0 ) != 0 )
	{	( * --SP ).integer = NULL_VECTOR_WRITTEN;
		UP.task->initialTerminalInputBuffer.integer |= LONG_MIN;	/* Negative forces abort. Must fix this flag. */
		ERROR();
	}
#endif
}


/*
07000 	FCC 'QUICK'
07010 	FCB 5
07020 	FCB MFORE
07030 	FDB TNULL-CFAOFF
07040 	FDB EDITOR+2
07050 	FDB QSYNC-CFAOFF
07060 	FDB 0
*/
static character_t sQUICK[] = "\x5" "QUICK";
definition_header_s hQUICK = 
{	{ (natural_t) sQUICK },
	{ 0 },
	{ (natural_t) &hTNULL },
	{ MFORE },
	{ (natural_t) &hEDITOR },
	{ (natural_t) &hQSYNC },
	{ 0 },
	{ (natural_t) QUICK }
};
/*
07070 QUICK	PSHS Y
07080 	LDY <UP
07090 	LDD UEBLK,Y
07100 	LDX URNUM,Y
07110 	PSHS D,X nest
07120 	PULU D
07130 	STD UEBLK,Y
07140 	LDD #0
07150 	STD URNUM,Y
07160 	DOCOL
07170 	FDB CURSOR
07180 	FDB QDUMP fill screen
07190 	FDB QSYNC
07200 QUICKL	FDB KEY
07210 	FDB XMACH
07220 	LDB 1,U
07230 	CMPB #3 break?
07240 	BEQ QUICKB
07250 	DOCOL
07260 	FDB QARROW
07270 	FDB QSYNC
07280 	FDB CURSOR
07290 	FDB XMACH
07300 	LDD 2,U
07310 	BNE QUICKC
07320 	LDB [,U++] from buffer
07330 	BRA QUICKE
07340 QUICKC	CMPB #'\
07350 	BNE *+10
07360 	DOCOL
07370 	FDB KEY literal
07380 	FDB XMACH
07390 	PULU D
07400 	STB [,U++] in buffer
07410 	INC URNUM+1,Y bump
07420 	LDA [UPREV,Y] update
07430 	ORA #$80
07440 	STA [UPREV,Y]
07450 QUICKE	CLRA
07460 	STD ,U
07470 	DOCOL
07480 	FDB EMIT
07485 	FDB QSYNC
07490 	FDB BRANCH
07500 	FDB QUICKL-*-2
07510 QUICKB	LEAU 2,U
07520 	PULS D,X un-nest
07530 	STD UEBLK,Y
07540 	STX URNUM,Y
07550 	PULS Y
07560 	NEXT
07570 *
*/
void QUICK( void )
{
}


/*
07800 	FCC 'NODE.'
07810 	FCB 5
07820 	FCB MFORE
07830 	FDB QUICK-CFAOFF
07840 	FDB BIF+2
07850 	FDB 0
07860 	FDB 0
*/
static character_t sNDOT[] = "\x5" "NODE.";
definition_header_s hNDOT = 
{	{ (natural_t) sNDOT },
	{ 0 },
	{ (natural_t) &hQUICK },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL },
/*
07870 NDOT	DOCOL
07880 	FDB DUP
07890 	FDB IDDOT
07900 	FDB SPACE
07910 	FDB ZERO
07920 	FDB DDOT
07930 	FDB CR
07940 	FDB QTERM
07943 	FDB DUP
07945 	FDB ZLESS break?
07950 	FDB ZBR
07955 	FDB 4
07960 	FDB DROP
07965 	FDB KEY
07970 	FDB SEMIS
07990 *
*/
	{
		{ (natural_t) &hDUP	},
		{ (natural_t) &hIDDOT	},
		{ (natural_t) &hSPACE	},
		{ (natural_t) &hZERO	},
		{ (natural_t) &hDDOT	},
		{ (natural_t) &hCR	},
		{ (natural_t) &hQTERM	},
		{ (natural_t) &hDUP	},
		{ (natural_t) &hZLESS	},	/* break? */
		{ (natural_t) &hZBR	},
		{ (natural_t) 2 * sizeof (cell_u)	},	/* 4 */
		{ (natural_t) &hDROP	},
		{ (natural_t) &hKEY	},
		{ (natural_t) &hSEMIS	},
	}
};
/*
08000 	FCC 'VISIT'
08010 	FCB 5
08020 	FCB MFORE
08030 	FDB NDOT-CFAOFF
08040 	FDB BIF+2
08050 	FDB 0
08060 	FDB 0
*/
static character_t sVISIT[] = "\x5" "VISIT";
definition_header_s hVISIT = 
{	{ (natural_t) sVISIT },
	{ 0 },
	{ (natural_t) &hNDOT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) VISIT }
};
/*
08070 VISIT	PSHS Y
08080 	LDY <UP
08090 	LDX UVMK,Y save
08100 	PSHS D,X allocate
08110 	STS UVMK,Y
08120 	LDX ,U++
08130 	PULU D
08140 	BEQ VISITX vocab
08150 	LDX ,X
08160 	BEQ VISITX
08170 	ADDD #CFAOFF function
08180 	STD ,S
08190 VISITL	PSHS X
08200 	CMPS US0,Y overflow?
08210 	BHI *+7
08220 	LDB #$0B
08230 	JMP QSTERR
08240 	LDX LFTOFF,X
08250 VISITR	BNE VISITL
08260 	CMPS UVMK,Y
08270 	BHS VISITX
08280 	LDX ,S node
08290 	LDD [UVMK,Y] function
08300 	PSHU D,X
08310 	DOCOL
08320 	FDB EXEC
08330 	FDB QSTACK
08340 	FDB XMACH
08343 	LDD ,U++
08346 	BMI VISITX terminate?
08350 	PULS X
08360 	LDX RTOFF,X
08370 	BRA VISITR
08375 VISITX	LDS UVMK,Y
08380 	PULS D,X
08390 	STX UVMK,Y
08400 	PULS Y
08410 	NEXT
08490 *
*/
void VISIT( void )
{
}


/*
08500 	FCC 'VLIST'
08510 	FCB 5
08520 	FCB MFORE
08530 	FDB VISIT-CFAOFF
08540 	FDB EDITOR+2
08550 	FDB VISIT-CFAOFF
08560 	FDB VOCAB-CFAOFF
*/
static character_t sVLIST[] = "\x5" "VLIST";
definition_header_s hVLIST =	
{	{ (natural_t) sVLIST },
	{ 0 },
	{ (natural_t) &hVISIT },
	{ MFORE },
/* Should this have actually been in EDITOR? */
	{ (natural_t) &hBIF },
	{ (natural_t) &hVISIT },
	{ (natural_t) &hVOCAB },
	{ (natural_t) DOCOL },
/*
08570 VLIST	DOCOL
08580 	FDB LIT
08590 	FDB NDOT-CFAOFF
08600 	FDB ROOT
08610 	FDB FETCH
08620 	FDB VISIT
08630 	FDB SEMIS
08690 *
*/
	{
		{ (natural_t) &hLIT	},
		{ (natural_t) &hNDOT	},	/* &hNDOT-CFAOFF */
		{ (natural_t) &hROOT	},
		{ (natural_t) &hFETCH	},
		{ (natural_t) &hVISIT	},
		{ (natural_t) &hSEMIS	}
	}
};

void VLIST(void)
{
}
