/*
**  bif3b_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF3B/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bifb_a.h"
#include "bif7b_a.h"	/* To link into the BIF vocabulary. */
#include "bif3b_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
04110 	FCC 'TYPE'
04112 	FCB 4
04114 	FCB MFORE
04116 	FDB XMACH-CFAOFF
04118 	FDB BIF+2
04120 	FDB 0
04122 	FDB 0
*/
static character_t sTYPE[] = "\x4" "TYPE";
definition_header_s hTYPE =	
{	{ (natural_t) sTYPE },
	{ 0 },
	{ (natural_t) &hXMACH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) TYPE }
};
/*
04130 TYPE	LDD ,U
04132 	BEQ TYPEQ
04135 	ADDD 2,U
04140 	STD ,U for compare
04145 	LDX 2,U
04150 TYPEL	LDB ,X+
04155 	STX 2,U
04160 	CLRA
04165 	PSHU D
04170 	DOCOL
04175 	FDB EMIT
04180 	FDB XMACH
04185 	LDX 2,U
04190 	CMPX ,U
04195 	BLO TYPEL
04197 TYPEQ LEAU 4,U
04200 	NEXT
04205 *
*/
void TYPE(void)
{	character_t * string = SP[ 1 ].chString;
	character_t * boundary = string + SP[ 0 ].integer;
	if ( SP[ 0 ].integer > 0 )
	{	do 
		{	( * -- SP ).integer = * string++;
			EMIT();
		} while ( string < boundary );
	}
	SP += 2;
}


static character_t sCTS_TYPE[] = "\x7" "CT-TYPE";
definition_header_s hCTS_TYPE =	
{	{ (natural_t) sCTS_TYPE },
	{ MHID },	/* This was an interesting definition, but I found COUNT! */
	{ (natural_t) &hTYPE },
	{ MFORE },
	{ (natural_t) &hUTIL },
	{ (natural_t) &hPHABORT },
	{ 0 },
	{ (natural_t) XCOL },
	{
		{ (natural_t) &hDUP	},
		{ (natural_t) &hADD1	},
		{ (natural_t) &hOVER	},
		{ (natural_t) &hCFEH	},
		{ (natural_t) &hTYPE	},
		{ (natural_t) &hSEMIS	}
	}
};


/*
04210 	FCC '(.")'
04212 	FCB MCOMP.OR.4
04214 	FCB MFORE
04216 	FDB TYPE-CFAOFF
04218 	FDB BIF+2
04220 	FDB XPLOOP-CFAOFF
04222 	FDB XSCODE-CFAOFF
*/
static character_t sXDOTQ[] = "\x4" "(.\")";
definition_header_s hXDOTQ = 
{	{ (natural_t) sXDOTQ },
	{ MCOMP },
	{ (natural_t) &hCTS_TYPE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hXPLOOP },
	{ (natural_t) &hXSCODE },
	{ (natural_t) XDOTQ }
};
/*
04230 XDOTQ	LDB ,Y+ count
04235 	CLRA
04240 	TFR Y,X string
04245 	LEAY D,Y past it
04250 	PSHU D,X
04255 	BRA TYPE
04300 *
*/
void XDOTQ( void )
{	byte_p string = (byte_p) IP;
	natural_t count = *string++;
	( * --SP ).bytep = string;
	( * --SP ).integer = count;
	/* Skip to word boundaries, and compiling needs the corresponding code. */
	/* ** This assumes sizeof (cell_u) is always a power of two. ** */
	count += ( ( sizeof (cell_u) ) - 1 );
	/* Masking out the low bits of the address is aesthetically preferable, 
	// but gcc doesn't like masking dressed integers onto addresses. 
	// So we assume that string is already allocated on boundary.
	*/
	count &= ~( ( sizeof (cell_u) ) - 1 );	
	string += count;
	IP = (cell_u *) string;
	TYPE();
}


/*
04310 	FCC 'ID.'
04312 	FCB 3
04314 	FCB MFORE
04316 	FDB XDOTQ-CFAOFF
04318 	FDB BIF+2
04320 	FDB 0
04322 	FDB 0
*/
static character_t sIDDOT[] = "\x3" "ID.";
definition_header_s hIDDOT = 
{	{ (natural_t) sIDDOT },
	{ 0 },
	{ (natural_t) &hXDOTQ },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) IDDOT }
};
/*
04330 IDDOT	PULU X nfa
04335 	LDB ,X
04340 	ANDB #NLMASK
04350 	NEGB
04360 	LEAX B,X past it
04370 	NEGB
04380 	CLRA
04390 	PSHU D,X
04400 	BRA TYPE
04410 *
*/
void IDDOT( void )
{	cell_u name = ( SP[ 0 ].definitionp )->nameLink;
	SP[ 0 ] = name;
	COUNT();
	TYPE();
}


/*
04510 	FCC 'FILL-IN'
04512 	FCB MCOMP.OR.7
04514 	FCB MFORE
04516 	FDB IDDOT-CFAOFF
04518 	FDB BIF+2
04520 	FDB 0
04522 	FDB 0
*/
static character_t sFILLIN[] = "\x7" "FILL-IN";
definition_header_s hFILLIN = 
{	{ (natural_t) sFILLIN },
	{ MCOMP },
	{ (natural_t) &hIDDOT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) FILLIN }
};
/*
04530 FILLIN	LDX <UP
04540 	LDD UDP,X
04550 	SUBD ,U adr
04555 	SUBD #2 past
04560 	STD [,U++]
04570 	NEXT
04590 *
*/
void FILLIN( void )
{	byte_t * here = UP.task->dictionaryAllocationPointer.bytep;
	byte_t * addressField = ( * SP++ ).bytep;
	* addressField = here - addressField - sizeof (cell_u);
}


/*
04610 	FCC 'BEGIN'
04612 	FCB MCOMP.OR.MIMM.OR.5
04614 	FCB MFORE
04616 	FDB FILLIN-CFAOFF
04618 	FDB BIF+2
04620 	FDB BASE-CFAOFF
04622 	FDB 0
*/
static character_t sBEGIN[] = "\x5" "BEGIN";
definition_header_s hBEGIN = 
{	{ (natural_t) sBEGIN },
	{ MCOMP | MIMM },
	{ (natural_t) &hFILLIN },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hBASE },
	{ 0 },
	{ (natural_t) XCOL },
/*
04630 BEGIN	DOCOL	see fig-FORTH model
04640 	FDB QCOMP
04650 	FDB HERE target
04660 	FDB LIT
04670 	FDB ('B)*256+'E
04680 	FDB SEMIS
04690 *
*/
	{	{ (natural_t) &hQCOMP	},
		{ (natural_t) &hHERE	},	/* target */
		{ (natural_t) &hLIT	},
		{ BEGIN_FLAG	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
04710 	FCC 'AGAIN'
04712 	FCB MCOMP.OR.MIMM.OR.5
04714 	FCB MFORE
04716 	FDB BEGIN-CFAOFF
04718 	FDB BIF+2
04720 	FDB 0
04722 	FDB 0
*/
static character_t sAGAIN[] = "\x5" "AGAIN";
definition_header_s hAGAIN = 
{	{ (natural_t) sAGAIN },
	{ MCOMP | MIMM },
	{ (natural_t) &hBEGIN },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL },
/*
04730 AGAIN	DOCOL	see fig-FORTH model
04740 	FDB LIT
04750 	FDB ('B)*256+'E
04760 	FDB QPAIRS
04765 	FDB COMP
04770 	FDB BRANCH
04775 	FDB BACK
04780 	FDB SEMIS
04790 *
*/
	{	{ (natural_t) &hLIT	},
		{ BEGIN_FLAG	},
		{ (natural_t) &hQPAIRS	},
		{ (natural_t) &hCOMP	},
		{ (natural_t) &hBRANCH	},
		{ (natural_t) &hBACK	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
04810 	FCC 'UNTIL'
04812 	FCB MCOMP.OR.MIMM.OR.5
04814 	FCB MFORE
04816 	FDB AGAIN-CFAOFF
04818 	FDB BIF+2
04820 	FDB USLASH-CFAOFF
04822 	FDB 0
*/
static character_t sUNTIL[] = "\x5" "UNTIL";
definition_header_s hUNTIL = 
{	{ (natural_t) sUNTIL },
	{ MCOMP | MIMM },
	{ (natural_t) &hAGAIN },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hUSLASH },
	{ 0 },
	{ (natural_t) XCOL },
/*
04830 UNTIL	DOCOL	see fig-FORTH model
04840 	FDB LIT
04850 	FDB ('B)*256+'E
04860 	FDB QPAIRS
04865 	FDB COMP
04870 	FDB ZBR
04875 	FDB BACK
04880 	FDB SEMIS
04890 *
*/
	{
		{ (natural_t) &hLIT	},
		{ BEGIN_FLAG	},
		{ (natural_t) &hQPAIRS	},
		{ (natural_t) &hCOMP	},
		{ (natural_t) &hZBR	},
		{ (natural_t) &hBACK	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
04910 	FCC 'WHILE'
04912 	FCB MCOMP.OR.MIMM.OR.5
04914 	FCB MFORE
04916 	FDB UNTIL-CFAOFF
04918 	FDB BIF+2
04920 	FDB WARM-CFAOFF
04922 	FDB WORDPD-CFAOFF
*/
static character_t sWHILE[] = "\x5" "WHILE";
definition_header_s hWHILE = 
{	{ (natural_t) sWHILE },
	{ MCOMP | MIMM },
	{ (natural_t) &hUNTIL },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hWARM },
	{ (natural_t) &hWORDPD },
	{ (natural_t) XCOL },
/*
04930 WHILE	DOCOL
04940 	FDB DUP
04950 	FDB LIT
04960 	FDB ('B)*256+'E
04970 	FDB QPAIRS
04980 	FDB COMP
04990 	FDB ZBR
05000 	FDB HERE adr
05010 	FDB ZERO
05020 	FDB COMMA
05030 	FDB LIT
05040 	FDB ('W)*256+'H
05050 	FDB SEMIS
05090 *
*/
	{
		{ (natural_t) &hDUP	},
		{ (natural_t) &hLIT	},
		{ BEGIN_FLAG	},
		{ (natural_t) &hQPAIRS	},
		{ (natural_t) &hCOMP	},
		{ (natural_t) &hZBR	},
		{ (natural_t) &hHERE	},	/* adr */
		{ (natural_t) &hZERO	},
		{ (natural_t) &hCOMMA	},
		{ (natural_t) &hLIT	},
		{ WHILE_FLAG	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
05110 	FCC 'REPEAT'
05112 	FCB MCOMP.OR.MIMM.OR.6
05114 	FCB MFORE
05116 	FDB WHILE-CFAOFF
05118 	FDB BIF+2
05120 	FDB REPEAL-CFAOFF
05122 	FDB ROOT-CFAOFF
*/
static character_t sREPEAT[] = "\x6" "REPEAT";
definition_header_s hREPEAT = 
{	{ (natural_t) sREPEAT },
	{ MCOMP | MIMM },
	{ (natural_t) &hWHILE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hREPEAL },
	{ (natural_t) &hROOT },
	{ (natural_t) XCOL },
/*
05130 REPEAT	DOCOL
05140 	FDB LIT
05150 	FDB ('W)*256+'H
05160 	FDB QPAIRS
05170 	FDB TOR
05180 	FDB AGAIN
05190 	FDB RFROM
05200 	FDB FILLIN
05210 	FDB SEMIS
05290 *
*/
	{
		{ (natural_t) &hLIT	},
		{ WHILE_FLAG	},
		{ (natural_t) &hQPAIRS	},
		{ (natural_t) &hTOR	},
		{ (natural_t) &hAGAIN	},
		{ (natural_t) &hRFROM	},
		{ (natural_t) &hFILLIN	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
05310 	FCC 'DO'
05312 	FCB MCOMP.OR.MIMM.OR.2
05314 	FCB MFORE
05316 	FDB WHILE-CFAOFF
05318 	FDB BIF+2
05320 	FDB CFEH-CFAOFF
05322 	FDB ENDIF-CFAOFF
*/
static character_t sDO[] = "\x2" "DO";
definition_header_s hDO = 
{	{ (natural_t) sDO },
	{ MCOMP | MIMM },
	{ (natural_t) &hREPEAT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hCFEH },
	{ (natural_t) &hENDIF },
	{ (natural_t) XCOL },
/*
05330 DO	DOCOL	see fig-FORTH model
05340 	FDB COMP
05350 	FDB XDO
05360 	FDB HERE
05370 	FDB LIT
05380 	FDB ('D)*256+'O
05390 	FDB SEMIS
05400 *
*/
	{
		{ (natural_t) &hCOMP	},
		{ (natural_t) &hXDO	},
		{ (natural_t) &hHERE	},
		{ (natural_t) &hLIT	},
		{ LOOP_FLAG	},
		{ (natural_t) &hSEMIS	}
	}
};
