/*
**  bifu_inc.h
**  bif-c
**
**  Created by Joel Rees on 2009/07/21.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIFU/I, as mechanically as possible.
*/


#if !defined BIFU_I_H
#define BIFU_I_H


#include <limits.h>


#include "tools_g00.h"

#define	DEBUGGING	2	/* So I can build some stub stuff to test the most basic stuff. */
#define DBG_BOOTSTRAP_TESTING
#define DBG_SHOW_SYMBOL_TABLE
/* 1 is for DOCOL (starting a colon definition), DOVAR, etc. */


/* #define btdbg_printf fprintf */
/* Can't just undefine it because of the parameters problem. Parameter count must match in definition and call! 
// Guess I'll have to define a function and use the variable parameters stuff, to do it. 
// Or just bury the debug stuff in #ifdef -- #endif blocks.
*/

/*
00010 * USER variable definitions for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00100 * INCLUDE THIS BEFORE SETTING DPR
00110 * ORG used here for offsets only
*/

/* Need some typedefs to describe things like the natural integer:
*/


/* What I want here is to define double_t appropriately for the architecture.
// If C provides a long long, I want to use that.
// Hopefully, the long long C provides will be both optimal 
// and in keeping with the proper byte order for the CPU.
// (Not attempting to deal with VAX order at this point.)
		typedef unsigned long long double_t;
		typedef signed long long sdouble_t;
#		define	DOUBLE_BITS	64
*/


#if defined USHRT_MAX
#	if USHRT_MAX == 0xFFFF
#		define	USHRT_MAX_AVAILABLE	16
#	else
#		define	USHRT_MAX_AVAILABLE	0
#		error "Not ready for short not 16 bits."
#	endif
#else
#	define	USHRT_MAX_AVAILABLE	0
#	error "Not ready for a lack of short."
#endif

#if defined ULONG_MAX
#	if ULONG_MAX == 0xFFFFFFFF
#		define	ULONG_MAX_AVAILABLE	32
#	else
#		define	ULONG_MAX_AVAILABLE	0
#		error "Not ready for long not 32 bits."
#	endif
#else
#	define	ULONG_MAX_AVAILABLE	0
#	error "Not ready for a lack of long."
#endif

#if defined ULLONG_MAX
#	if ULLONG_MAX == 0xFFFFFFFFFFFFFFFF
#		define	ULONG_LONG_MAX_AVAILABLE	64
#	else
#		define	ULONG_LONG_MAX_AVAILABLE	0
#		error "Not ready for long long not 64 bits."
#	endif
#else
#	define	ULONG_LONG_MAX_AVAILABLE	0
#	error "Not ready for a lack of long long."
#endif


/* This may not work if you are trying to define 
** a smaller natural integer than your CPU's natural integer.
** Set it to 
**	2 for 16 bit CPUs, eight bit bytes,
**	4 for 32 bit CPUs, eight bit bytes,
**	8 for 64 bit CPUs, eight bit bytes.
*/
#define BYTESPERCELL 4

/* Set this to the number of bits per byte.
*/
#define BITSPERBYTE 8

/* Note that I haven't tested the source for any case but 32 bit cells, 
** and 8 bit bytes, yet.
** You'll need to work through the source code to be sure, for other sizes.
*/

#if BYTESPERCELL == 2
	typedef unsigned short natural_t;
	typedef signed short snatural_t;
	typedef unsigned long double_t;
	typedef signed long sdouble_t;
#elif BYTESPERCELL == 4
	typedef unsigned long natural_t;
	typedef signed long snatural_t;
	typedef unsigned long long double_t;
	typedef signed long long sdouble_t;
#elif BYTESPERCELL == 8
	typedef unsigned long long natural_t;
	typedef signed long long snatural_t;
#else
#	error "Need to define the types for your strange or large architecture!"
#endif

#define BITSPERCELL	( BITSPERBYTE * BYTESPERCELL )
#define BYTESPERDOUBLE	( 2 * BYTESPERCELL )
#define BITSPERDOUBLE	( BITSPERBYTE *  BYTESPERDOUBLE )

#if BYTESPERCELL != 4
#	error "Not ready for the cell size specified."
#endif


#define SYSTEM_TRAPS_NULLS	/* Need to make this conditional on architecture. Mac OS 10.3 traps. */



/* semantic sugar:
*/
typedef unsigned char byte_t;
typedef signed char sbyte_t;
typedef unsigned char * byte_p;
typedef signed char * sbyte_p;

/* characters should be 32 bit, 
** but that's for a later iteration.
** For now, expect multi-byte, with minimal parsing.
** I suppose multibyte parsing will be the best for 16-bit CPUs.
// Don't forget to fix EMIT and related code if character_t is not char or unsigned char.
*/
typedef unsigned char character_t;
typedef signed char scharacter_t;
typedef character_t packed_cell_a[ BYTESPERCELL ];
typedef character_t spacked_cell_a[ BYTESPERCELL ];

/* When it's time to implement bit arrays, I will add appropriate types here.
*/


typedef void (* icode_f)(void);


typedef union cell_u
{	natural_t integer;
	snatural_t sinteger;
	void * voidp;
	byte_p bytep;
	sbyte_p sbytep;
	union cell_u * cellp;
	struct taskrecord_s * task;
	struct boot_constants_s * bootConstantsp;
	icode_f	icode;
	icode_f * icodep;
	character_t character;
	character_t * chString;
	scharacter_t * schString;
	packed_cell_a packed_character;
	spacked_cell_a spacked_character; /* Primarily for the most significant character. */
	struct definition_header_s * definitionp;
} cell_u;


/* Since a cell can point to a definition header, the definitions are (partially) interdependent.
** Moved here from bif_m.h .
** Usages during initialization are different from usages at run time.
*/
typedef struct definition_header_s
{	cell_u	nameLink;	/* Bits above length are mode flags. Name is not far from header. C init with pointer. */
	cell_u	interpMode;	/* Making the mode bits explicit to help the C source-level initializations. */
	cell_u	allocLink;	/* Want to separate the allocation fields. */
	cell_u	allocMode;	/* Decoupling the allocation, making the C initializations easier. */
	cell_u	vocabLink;	/* Root of this definition's vocabulary. */
	cell_u	leftLink;	/* Binary tree, left child in order. */
	cell_u	rightLink;	/* Right child in order. */
	cell_u	codeLink;	/* Interpretation code for this definition. */
	cell_u	parameterLink[];	/* Parameters for the code for this definition. */
} definition_header_s;

/* During initializations, the allocation pointer will be used to form a linked list within the file.
** COLD will overwrite this per-file list after using it to build the tree.
** The list will be terminated by pointing back to the first entry.
** But that alters the semantics of COLD subtly, so I may want to add a third temperature of boot.
** This initialization of the symbol table at start-up is necessitated by the macro.
** Maybe I'll just not use the macro, after all, but leave it here for the comments.
*/

#define HEADER( name, mode, next, papa, code, param0 )	\
character_t s##name[] = "\0" #name;		/* Lead byte is length. */	\
definition_header_s h##name =	\
{	{ (natural_t) s##name },	/* May later overwrite with relative pointer? */	\
	{ mode },	/* No special modes. */	\
	{ (natural_t) &h##next },	/* Will link backwards within the allocation block, but who knows for C? */	\
	{ MFORE },	/* Do not allow it to be FORGET-forgotten. */	\
	{ (natural_t) &h##papa },	/* parent vocabulary, must set. */	\
	{ 0 },	/* left link, will be set during cold boot. */	\
	{ 0 },	/* right link, will be set during cold boot. */	\
	{ (natural_t) name },	/* The code this definition calls. */	\
	{ { param0 } }	/* Dummy first parameter to make the C macro easier. */	\
}	\

/* Something like this was useful when debugging the macro:
// HEADER( 1, 2, 3, 4, 5, 6 );
*/

/* If I build the symbol tables by hand, 
** I'll have to make three passes through 16+ files:
** One pass to paste in all the headers and link them into the allocation list,
** a second pass to link them to their parent vocabularies
** (Figuring out what I did to the vocabularies is necessary either way.),
** and a third pass to build the trees in each vocabulary.
** If I let the initialization code build it during the pre-COLD boot-up stage, 
** I have to write and debug a C language function to string it together.
** Probably take about the same time, by the time I'm finished debugging?
** Building the table at boot will require adding a symbol list link to each file, 
** and then require dumping said list to an array for sorting, 
** and then I can finally process it, sort it, optimize it, build it up.
** And the routine has to work for every vocabulary.
** Not that bad, but it will take debugging.
** So will the hand-built tree, particulary, as I see I have mixed vocabularies leftover from BIF6809.
*/


/* To use a struct or not to use a struct, that was the question.
** #define US0	0
** #define UR0	( US0 + sizeof (cell_u) )
** Naw, let's not fight the C that much.
*/
#define UP_SPARE_COUNT 8
/*
00120 	ORG 0
*/
typedef struct taskrecord_s
{
/* 00130 US0	RMB 2	base of data stack (6809 U) */
	cell_u	dataStackBase;	/* upside down */
#define US0 ( offsetof( struct taskrecord_s, dataStackBase ) )

/* 00140 UR0	RMB 2	base of control stack (6809 S) */
	cell_u	returnStackBase;	/* upside down */
#define UR0 ( offsetof( struct taskrecord_s, returnStackBase ) )

/* 00150 UTIB	RMB 2	terminal buffer */
	cell_u	terminalInputBuffer;
#define UTIB ( offsetof( struct taskrecord_s, terminalInputBuffer ) )

/* 00160 	RMB 2	width is not used */
	cell_u	reserved_NameLengthMask;
#define UWIDTH ( offsetof( struct taskrecord_s, reserved_width ) )

/* 00170 UWARN	RMB 2	disk on line? */
	cell_u	diskOnLine;
#define UWARN ( offsetof( struct taskrecord_s, diskOnLine ) )

/* 00180 UFENCE	RMB 2	for FORGET */
	cell_u	forgetFence;
#define UFENCE ( offsetof( struct taskrecord_s, forgetFence ) )

/* 00190 UDP	RMB 2	first available byte in dictionary */
	cell_u	dictionaryAllocationPointer;
#define UDP ( offsetof( struct taskrecord_s, dictionaryAllocationPointer ) )

/* 00200 UROOT	RMB 2	current dictionary root pointer */
	cell_u	searchContextRoot;
#define UROOT ( offsetof( struct taskrecord_s, searchContextRoot ) )

/* 00210 UDROOT	RMB 2	defining dictionary root pointer */
	cell_u	definitionContextRoot;
#define UDROOT ( offsetof( struct taskrecord_s, definitionContextRoot ) )

/* 00220 UCURR	RMB 2	NFA of last definition */
	cell_u	lastDefined;
#define UCURR ( offsetof( struct taskrecord_s, lastDefined ) )

/* 00230 UPAD	RMB 2	text, numeric scratch buffers */
	cell_u	numericConversionScratchPad;
#define UPAD ( offsetof( struct taskrecord_s, numericConversionScratchPad ) )

/* 00240 UWP	RMB 2	WORD buffer pointer */
	cell_u	wordBufferPointer;
#define UWP ( offsetof( struct taskrecord_s, wordBufferPointer ) )

/* 00250 UCOLUM	RMB 2	columns per lineon terminal */
	cell_u	terminalColumns;	/* This is faked. */
#define UCOLUM ( offsetof( struct taskrecord_s, terminalColumns ) )

/* 00260 UFIRST	RMB 2	byte of buffers */
	cell_u	firstByteOfBuffers;
#define UFIRST ( offsetof( struct taskrecord_s, firstByteOfBuffers ) )

/* 00270 ULIMIT	RMB 2	of buffer ram */
	cell_u	limitOfBufferRAM;
#define ULIMIT ( offsetof( struct taskrecord_s, limitOfBufferRAM ) )

/* 00280 UBASE	RMB 2	of numeric conversion */
	cell_u	numericBase;
#define UBASE ( offsetof( struct taskrecord_s, numericBase ) )

/* 00290 UCSP	RMB 2	stack pointer check */
	cell_u	compilerStackMarker;
#define UCSP ( offsetof( struct taskrecord_s, compilerStackMarker ) )

/* 00300 UHLD	RMB 2	character mark in pad */
	cell_u	padMarker;
#define UHLD ( offsetof( struct taskrecord_s, padMarker ) )

/* 00310 UUSE	RMB 2	Least Recently Used buffer */
	cell_u	leastRecentBuffer;
#define UUSE ( offsetof( struct taskrecord_s, leastRecentBuffer ) )

/* 00320 UPREV	RMB 2	Most Recently Used buffer */
	cell_u	mostRecentBuffer;
#define UPREV ( offsetof( struct taskrecord_s, mostRecentBuffer ) )

/* 00330 UBS	RMB 2	BackSpace */
	cell_u	backSpaceConstant;
#define UBS ( offsetof( struct taskrecord_s, backSpaceConstant ) )

/* 00340 UIN	RMB 2	input buffer offset */
	cell_u	bufferInputOffset;
#define UIN ( offsetof( struct taskrecord_s, bufferInputOffset ) )

/* 00350 UOUT	RMB 2	output buffer offset (cursor) */
	cell_u	bufferOutputOffset;
#define UOUT ( offsetof( struct taskrecord_s, bufferOutputOffset ) )

/* 00360 UBLK	RMB 2	active disc block */
	cell_u	activeDiscBlock;
#define UBLK ( offsetof( struct taskrecord_s, activeDiscBlock ) )

/* 00370 UEBLK	RMB 2	active edit block */
	cell_u	activeEditBlock;
#define UEBLK ( offsetof( struct taskrecord_s, activeEditBlock ) )

/* 00380 USCR	RMB 2	active disc screen */
	cell_u	activeDiscScreen;
#define USCR ( offsetof( struct taskrecord_s, activeDiscScreen ) )

/* 00390 URNUM	RMB 2	editing offset (cursor) */
	cell_u	editingOffset;
#define URNUM ( offsetof( struct taskrecord_s, editingOffset ) )

/* 00400 UOFFS	RMB 2	to active drive */
	cell_u	activeDriveOffset;
#define UOFFS ( offsetof( struct taskrecord_s, activeDriveOffset ) )

/* 00410 USTATE	RMB 2	of compiler */
	cell_u	compilerState;
#define USTATE ( offsetof( struct taskrecord_s, compilerState ) )

/* 00420 UDPL	RMB 2	output Decimal Point Location */
	cell_u	decimalPoint;
#define UDPL ( offsetof( struct taskrecord_s, decimalPoint ) )

/* 00430 UFLD	RMB 2	output field width */
	cell_u	outputFieldWidth;
#define UFLD ( offsetof( struct taskrecord_s, outputFieldWidth ) )

/* 00440 UVMK	RMB 2	stack mark and function for VISIT */
	cell_u	visitedMark;
#define UVMK ( offsetof( struct taskrecord_s, visitedMark ) )

/* 00450 UFORE	RMB 2	FOREWARD reference block link */
	cell_u	forewardBlock;
#define UFORE ( offsetof( struct taskrecord_s, forewardBlock ) )

/* 00460 UDPR	RMB 2	Direct Page Emulator for Assembler */
	cell_u	directPageEmulator;
#define UDPR ( offsetof( struct taskrecord_s, directPageEmulator ) )

/* For changing the FENCE techniques, maybe, eventually. */
	cell_u	tailFence;
#define UDPR ( offsetof( struct taskrecord_s, directPageEmulator ) )

/* 00990 	RMB 16	8 spares  */
	cell_u	spare[ UP_SPARE_COUNT ];
#define USPARE ( offsetof( struct taskrecord_s, spare ) )

/* 01000 UEND	EQU *  */
} taskrecord_s;
#define UEND ( sizeof (taskrecord_s) )


/* Moved here from the tail of bif_a.c, for the obvious reasons.
// Don't need them all in every file, but they'll save us some trouble here,
// at least until I get to the refactoring. 
// At that point, I can move the necessary includes to the necessary non-headers.
// I hope.
*/
#include	"bifst_a.h"
#include	"bif_a.h"
#include	"bifb_a.h"
#include	"bif1_a.h"
#include	"bif1b_a.h"
#include	"bif2_a.h"
#include	"bif2b_a.h"
#include	"bif3_a.h"
#include	"bif3b_a.h"
#include	"bif4_a.h"
#include	"bif4b_a.h"
#include	"bif5_a.h"
#include	"bif5b_a.h"
#include	"bif6_a.h"
#include	"bif6b_a.h"
#include	"bif7_a.h"
#include	"bif7b_a.h"


#endif /* !defined BIFU_I_H */
