/*
**  bif5b_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/07/24.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF5B/A, as mechanically as possible.
*/

#if !defined BIF5B_A_H
#define BIF5B_A_H


#include "bifu_i.h"


/* #define ARRAY_BOUNDS_ERROR	0xC	//	in tools_g00.h */


extern definition_header_s hIABORT;

/* stub, will take a message number, dump the message to the error console and abort. 
*/
extern definition_header_s hERROR;
extern void ERROR(void);

/* Macro to make calling ERROR a little more foolproof.
*/
#define mERROR( number )	\
{	( * --SP ).integer = number;	\
	ERROR();	\
}

extern definition_header_s hEDITOR;

extern definition_header_s hQSYNC;
extern void QSYNC(void);

extern definition_header_s hEBLK;

extern definition_header_s hCURSOR;

extern definition_header_s hQDUMP;
extern void QDUMP(void);

extern definition_header_s hQARROW;
extern void QARROW(void);


#endif /* !defined BIF5B_A_H */
