/*
**  bif5b_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/07/24.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF5B/A, as mechanically as possible.
*/

#include <stdio.h>	/* for a temporary definition of ERROR. */

#include "bif_m.h"
#include "bifst_a.h"

#include "bif7b_a.h"

#include "bif5b_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (See BIF/ASM)
00030 *
05200 	FCC '(ABORT)'
05210 	FCB 7
05220 	FCB MFORE
05230 	FDB MESS-CFAOFF
05240 	FDB BIF+2
05250 	FDB XDOTQ-CFAOFF
05260 	FDB XDO-CFAOFF
*/
static character_t sIABORT[] = "\x7" "(ABORT)";
definition_header_s hIABORT = 
{	{ (natural_t) sIABORT },
	{ 0 },
	{ (natural_t) &hMESS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hXDOTQ },
	{ (natural_t) &hXDO },
	{ (natural_t) XCOL },
/*
05270 IABORT DOCOL	see fig-FORTH model
05280 	FDB ABORT
05290 	FDB SEMIS
05390 *
*/
	{
		{ (natural_t) &hABORT	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
05400 	FCC 'ERROR'
05410 	FCB 5
05420 	FCB MFORE
05430 	FDB IABORT-CFAOFF
05440 	FDB BIF+2
05450 	FDB ERASE-CFAOFF
05460 	FDB EXEC-CFAOFF
*/
static character_t sERROR[] = "\x5" "ERROR";
definition_header_s hERROR =
{	{ (natural_t) sERROR },
	{ 0 },
	{ (natural_t) &hIABORT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hERASE },
	{ (natural_t) &hEXEC },
	{ (natural_t) DOCOL }, 
/*
05470 ERROR DOCOL
05480 	FDB WORDPD last WORD
05490 	FDB COUNT
05500 	FDB TYPE
05510 	FDB XDOTQ
05520 	FCB 3
05530 	FCC ' ? '
05540 	FDB MESS
05550 	FDB WARN
05560 	FDB FETCH
05570 	FDB ZLESS
05580 	FDB ZBR
05590 	FDB 2
05600 	FDB IABORT
05610 	FDB SPSTO
05620 	FDB IN
05630 	FDB FETCH
05640 	FDB BLK
05650 	FDB FETCH
05660 	FDB QUIT
05670 	FDB SEMIS
05680 *
*/
	{ /* { (natural_t) 0 Need to check what we're gonna do here! }  */
		{ (natural_t) &hWORDPD	},	/* last WORD */
		{ (natural_t) &hCOUNT	},
		{ (natural_t) &hTYPE	},
/* This is why I wanted to write C source to compile the strings.
		{ (natural_t) &hXDOTQ	},
// But in-line strings are a serious pain in C source, because they move.
05520 	FCB 3
05530 	FCC ' ? '
05540 	FDB MESS
05550 	FDB WARN
05560 	FDB FETCH
05570 	FDB ZLESS
05580 	FDB ZBR
05590 	FDB 2
05600 	FDB IABORT
05610 	FDB SPSTO
05620 	FDB IN
05630 	FDB FETCH
05640 	FDB BLK
05650 	FDB FETCH
05660 	FDB QUIT
*/
		{ (natural_t) &hSEMIS	}
	}
};
void ERROR(void)	/* temporary definition, just write out the error number. */
{	fprintf( standardError, " ? %ld\n", ( * SP++ ).integer );
}


/*
05700 	FCC 'EDITOR'
05710 	FCB MIMM.OR.6
05720 	FCB MFORE
05730 	FDB ERROR-CFAOFF
05740 	FDB BIF+2 parent voc
05750 	FDB 0
05760 	FDB 0
*/
static character_t sEDITOR[] = "\x3" " ? ";
definition_header_s hEDITOR = 
{	{ (natural_t) sEDITOR },
	{ MIMM },
	{ (natural_t) &hERROR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XVOC },
/*
05770 EDITOR	DOVOC
05780 	FDB EBLK-CFAOFF (NFA)
05790 *
*/
	{
		{ (natural_t) &hEBLK	}	/* (NFA) */
	}
};
/*
05800 	FCC 'QSYNC'
05810 	FCB 5
05820 	FCB MFORE
05830 	FDB EDITOR-CFAOFF
05840 	FDB EDITOR+2
05850 	FDB 0
05860 	FDB 0
*/
static character_t sQSYNC[] = "\x5" "QSYNC";
definition_header_s hQSYNC = 
{	{ (natural_t) sQSYNC },
	{ 0 },
	{ (natural_t) &hEDITOR },
	{ MFORE },
	{ (natural_t) &hEDITOR },
	{ 0 },
	{ 0 },
	{ (natural_t) QSYNC }
};
/*
05870 QSYNC	LDX <UP
05880 	LDB URNUM+1,X
05890 	LDA #4
05900 	STD $88
05910 	NEXT
05990 *
*/
void QSYNC( void )
{
}


/*
06000 	FCC 'EBLK'
06010 	FCB 4
06020 	FCB MFORE
06030 	FDB QSYNC-CFAOFF
06040 	FDB EDITOR+2
06050 	FDB CURSOR-CFAOFF
06060 	FDB QDUMP-CFAOFF
*/
static character_t sEBLK[] = "\x4" "EBLK";
definition_header_s hEBLK = 
{	{ (natural_t) sEBLK },
	{ 0 },
	{ (natural_t) &hQSYNC },
	{ MFORE },
	{ (natural_t) &hEDITOR },
	{ (natural_t) &hCURSOR },
	{ (natural_t) &hQDUMP },
	{ (natural_t) XUSER },
/*
06070 EBLK	DOUSER
06080 	FCB UEBLK
*/
	{	{ UEBLK }	}
};
/*
06090 *
06000 	FCC 'CURSOR'
06010 	FCB 6
06020 	FCB MFORE
06030 	FDB QSYNC-CFAOFF
06040 	FDB EDITOR+2
06050 	FDB 0
06060 	FDB 0
*/
static character_t sCURSOR[] = "\x6" "CURSOR";
definition_header_s hCURSOR = 
{	{ (natural_t) sCURSOR },
	{ 0 },
	{ (natural_t) &hEBLK },
	{ MFORE },
	{ (natural_t) &hEDITOR },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL },
/*
06070 CURSOR	DOCOL
06080 	FDB EBLK
06090 	FDB FETCH
06100 	FDB BLOCK
06110 	FDB RNUM
06120 	FDB FETCH
06130 	FDB ADD
06140 	FDB SEMIS
06190 *
*/
	{
		{ (natural_t) &hEBLK	},
		{ (natural_t) &hFETCH	},
		{ (natural_t) &hBLOCK	},
		{ (natural_t) &hRNUM	},
		{ (natural_t) &hFETCH	},
		{ (natural_t) &hADD	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
06200 	FCC 'QDUMP'
06210 	FCB 5
06220 	FCB MFORE
06230 	FDB CURSOR-CFAOFF
06240 	FDB EDITOR+2
06250 	FDB QARROW-CFAOFF
06260 	FDB QUICK-CFAOFF
*/
static character_t sQDUMP[] = "\x5" "QDUMP";
definition_header_s hQDUMP = 
{	{ (natural_t) sQDUMP },
	{ 0 },
	{ (natural_t) &hCURSOR },
	{ MFORE },
	{ (natural_t) &hEDITOR },
	{ (natural_t) &hQARROW },
	{ (natural_t) &hQUICK },
	{ (natural_t) QDUMP }
};
/*
06270 QDUMP	PSHS Y
06280 	PULU Y
06290 	LDX #$400 screen
06300 	CLRA
06310 QDUMPL	LDB ,Y+
06320 	STB ,X+
06330 	DECA
06340 	BNE QDUMPL
06350 	PULS Y
06360 	NEXT
06390 *
*/
void QDUMP( void )
{
}


/*
06400 	FCC 'QARROW'
06410 	FCB 6
06420 	FCB MFORE
06430 	FDB QDUMP-CFAOFF
06440 	FDB EDITOR+2
06450 	FDB 0
06460 	FDB 0
*/
static character_t sQARROW[] = "\x6" "QARROW";
definition_header_s hQARROW = 
{	{ (natural_t) sQARROW },
	{ 0 },
	{ (natural_t) &hQDUMP },
	{ MFORE },
	{ (natural_t) &hEDITOR },
	{ 0 },
	{ 0 },
	{ (natural_t) QARROW }
};
/*
06470 QARROW	LDB 1,U
06480 	LDA #4
06490 	LEAX QTBL,PCR
06500 QAROL	CMPB ,X+
06510 	BEQ QARODO
06520 	DECA
06530 	BNE QAROL
06540 	CMPB #21 shifted BS?
06550 	BNE QAROX
06552 	DOCOL
06554 	FDB CURSOR
06556 	FDB XMACH
06560 	LDD #$2060 spaces
06565 	STA [,U++] buffer
06570 	STB [$88] video
06580 	LDB #-1
06590 	BRA *+4
06600 QARODO	LDB 3,X
06610 	LDX <UP
06620 	ADDB URNUM+1,X
06630 	STB URNUM+1,X
06650 	LDD #0
06660 	STD ,U
06670 QAROX	NEXT
// This is a table of the cursor keys and the respective offests in the buffer. 
// Can I make an editor this simple using ANSI control characters, as in the early vi?
06700 QTBL	FCB '^ up
06710 	FCB 10 down
06720 	FCB 8 back
06730 	FCB 9 front
06740 	FCB -32 offsets
06750 	FCB 32
06760 	FCB -1
06770 	FCB 1
06790 *
*/
void QARROW( void )
{
}
