/*
**  bif5_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF5/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bifst_a.h"

#include "bif7b_a.h"	/* To link into the BIF vocabulary. */
#include "bif5_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (See BIF/ASM)
00030 *
00900 	FCC 'IP,'
00910 	FCB MCOMP.OR.3
00920 	FCB MFORE
00930 	FDB SCODE-CFAOFF
00940 	FDB BIF+2
00950 	FDB 0
00960 	FDB 0
00970 IPCOM	JMP COMPIP
00980 *
01000 	FCC '?STACK'
01010 	FCB 6
01020 	FCB MFORE
01030 	FDB IPCOM-CFAOFF
01040 	FDB BIF+2
01050 	FDB 0
01060 	FDB 0
01070 QSTACK	LDX <UP
01080 	CMPS UR0,X
01090 	BLS *+6
01100 QSTACU	LDB #$0A
01110 	BRA QSTERR
01115 	LDD [UR0,X] hole
01116 	BNE QSTACU
01120 	CMPS US0,X
01130 	BHI *+6
01140 QSTACO	LDB #$0B
01150 	BRA QSTERR
01155 	LDD [US0,X] hole
01156 	BNE QSTACE
01160 	CMPU US0,X
01170 	BLS *+6
01180 QSTACE	LDB #1
01190 	BRA QSTERR
01240 	CMPU UDP,X
01260 	BLS *+4
01270 	NEXT
01280 	LDB #7
01290 QSTERR	CLRA
01300 	PSHU D
01310 	JMP ERROR
01320 *
01400 	FCC 'BUFFER'
01410 	FCB 6
01420 	FCB MFORE
01430 	FDB QSTACK-CFAOFF
01440 	FDB BIF+2
01450 	FDB BLK-CFAOFF
01460 	FDB CCOMMA-CFAOFF
01470 BUFFER	PSHS Y
01480 	LDY <UP
01490 	LDD UUSE,Y
01495 	PSHS D save it
01500 	PSHU D
01510 	DOCOL
01520 	FDB ADDBUF
01530 	FDB ZBR prev?
01540 	FDB -6
01550 	FDB XMACH
01560 	PULU D
01570 	STD UUSE,Y new use
01580 	LDX ,S buffer
01590 	LDD ,X block
01600 	BPL BUFNW
01610 	ANDA #$7F mask update
01620 	LEAX 2,X data
01630 	PSHU D,X
01640 	LDD #0 write
01650 	PSHU D
01660 	DOCOL
01670 	FDB RW
01680 	FDB XMACH
01690 BUFNW	PULU D new block
01700 	PULS X
01710 	STD ,X
01720 	STX UPREV,Y
01730 	LEAX 2,X data
01740 	PSHU X
01750 	PULS Y
01760 	NEXT
01790 *
01800 	FCC 'BLOCK'
01810 	FCB 5
01820 	FCB MFORE
01830 	FDB BUFFER-CFAOFF
01840 	FDB BIF+2
01850 	FDB 0
01860 	FDB BS-CFAOFF
01870 BLOCK	PSHS Y
01880 	LDY <UP
01890 	LDD UOFFS,Y
01900 	ADDD ,U
01910 	STD ,U
01920 	LDX UPREV,Y
01930 BLOKL	LDD ,X block
01940 	ANDA #$7F mask update
01950 	CMPD ,U this buffer?
01960 	BEQ BLOKFD
01970 	PSHU X
01980 	DOCOL
01990 	FDB ADDBUF
02000 	FDB TBR
02010 	FDB BLOKLE-*-2
02020 	FDB DROP buffer
02030 	FDB DUP block
02040 	FDB BUFFER lru
02050 	FDB OVER
02060 	FDB OVER
02070 	FDB SWAP
02080 	FDB MONE
02090 	FDB RW get block
02100 	FDB SUB2
02110 BLOKLE	FDB XMACH
02120 	PULU X buffer
02130 	BRA BLOKL
02140 BLOKFD	STX UPREV,Y
02150 	LEAX 2,X data
02160 	STX ,U
02165 	PULS Y
02170 	NEXT
02180 *
02200 	FCC '(LINE)'
02210 	FCB 6
02220 	FCB MFORE
02230 	FDB BLOCK-CFAOFF
02240 	FDB BIF+2
02250 	FDB PINSTA-CFAOFF
02260 	FDB XLOOP-CFAOFF
02270 XLINE	DOCOL	see fig-FORTH model
02280 	FDB TOR
02290 	FDB CPERL line width
02300 	FDB BPBUF
02310 	FDB SSMOD byte in sector
02320 	FDB RFROM
02330 	FDB BPSCR
02340 	FDB STAR base of screen
02350 	FDB ADD
02360 	FDB BLOCK
02370 	FDB ADD byte of buffer
02380 	FDB CPERL
02390 	FDB SEMIS
02400 *
02500 	FCC '.LINE'
02510 	FCB 5
02520 	FCB MFORE
02530 	FDB XLINE-CFAOFF
02540 	FDB BIF+2
02550 	FDB DOTQ-CFAOFF
02560 	FDB DOTR-CFAOFF
02570 DOTLIN	DOCOL	see fig-FORTH model
02580 	FDB XLINE
02590 	FDB DTRAIL
02600 	FDB TYPE
02610 	FDB SEMIS
02690 *
02700 	FCC 'SPACES'
02710 	FCB 6
02720 	FCB MFORE
02730 	FDB DOTLIN-CFAOFF
02740 	FDB BIF+2
02750 	FDB 0
02760 	FDB 0
02770 SPACES	LDD ,U	see fig-FORTH model
02780 	BGT SPACEY
02783 	LEAU 2,U
02785 	NEXT
02790 SPACEY	DOCOL
02800 	FDB ZERO
02810 	FDB XDO
02820 	FDB SPACE
02830 	FDB XLOOP
02840 	FDB -6
02850 	FDB SEMIS
02890 *
02900 	FCC '<#'
02910 	FCB 2
02920 	FCB MFORE
02930 	FDB SPACES-CFAOFF
02940 	FDB BIF+2
02950 	FDB 0
02960 	FDB BUILDS-CFAOFF
02970 BEGHSH	LDX <UP
02980 	LDD UPAD,X
02990 	STD UHLD,X
03000 	NEXT
03090 *
03100 	FCC '#>'
03110 	FCB 2
03120 	FCB MFORE
03130 	FDB BEGHSH-CFAOFF
03140 	FDB BIF+2
03150 	FDB STORE-CFAOFF
03160 	FDB TICK-CFAOFF
03170 ENDHSH	LDX <UP
03180 	LDD UPAD,X
03190 	SUBD UHLD,X
03200 	STD ,U count
03210 	LDD UHLD,X
03220 	STD 2,U
03230 	NEXT
03290 *
03300 	FCC 'SIGN'
03310 	FCB 4
03320 	FCB MFORE
03330 	FDB ENDHSH-CFAOFF
03340 	FDB BIF+2
03350 	FDB SCR-CFAOFF
03360 	FDB 0
03370 SIGN	DOCOL	see fig-FORTH model
03380 	FDB ROT
03390 	FDB ZLESS
03400 	FDB ZBR
03410 	FDB SIGNP-*-2
03420 	FDB LIT
03430 	FDB $2D
03440 	FDB HOLD
03450 SIGNP	FDB SEMIS
03490 *
03500 	FCC '#'
03510 	FCB 1
03520 	FCB MFORE
03530 	FDB SIGN-CFAOFF
03540 	FDB BIF+2
03550 	FDB 0
03560 	FDB 0
03570 HASH	DOCOL	see fig-FORTH model
03580 	FDB BASE
03590 	FDB FETCH
03600 	FDB MSMOD
03610 	FDB ROT
03620 	FDB XMACH
03630 	LDB 1,U
03640 	CMPB #9
03650 	BLS HASHX+4
03660 	CMPB #'A-'Z+10
03670 	BLS HASHX+2
03680 HASHX	ADDB #'a-'Z-1
03690 	ADDB #'A-'9-1
03700 	ADDB #'0
03710 	STB 1,U
03720 	DOCOL
03730 	FDB HOLD
03740 	FDB SEMIS
03790 *
03800 	FCC '#S'
03810 	FCB 2
03820 	FCB MFORE
03830 	FDB HASH-CFAOFF
03840 	FDB BIF+2
03850 	FDB 0
03860 	FDB 0
03870 HASHS	DOCOL
03880 	FDB HASH
03890 	FDB XMACH
03900 	LDD 2,U
03910 	BNE HASHS
03920 	LDD ,U
03930 	BNE HASHS
03940 	NEXT
03950 *
04000 	FCC 'D.R'
04010 	FCB 3
04020 	FCB MFORE
04030 	FDB HASHS-CFAOFF
04040 	FDB BIF+2
04050 	FDB 0
04060 	FDB 0
04070 DDOTR	DOCOL	see fig-FORTH model
04080 	FDB TOR
04090 	FDB SWAP save sign
04100 	FDB OVER
04110 	FDB DABS
04120 	FDB BEGHSH
04130 	FDB HASHS
04140 	FDB SIGN
04150 	FDB ENDHSH
04160 	FDB RFROM field width
04170 	FDB OVER
04180 	FDB SUB
04190 	FDB SPACES <0 => no spaces
04200 	FDB TYPE
04210 	FDB SEMIS
04220 *
04230 	FCC 'D.'
04240 	FCB 2
04250 	FCB MFORE
04260 	FDB DDOTR-CFAOFF
04270 	FDB BIF+2
04280 	FDB 0
04290 	FDB DDOTR-CFAOFF
04300 DDOT	DOCOL	see fig-FORTH model
04310 	FDB ZERO
04320 	FDB DDOTR
04330 	FDB SPACE
04340 	FDB SEMIS
04350 *
04360 	FCC '.R'
04370 	FCB 2
04380 	FCB MFORE
04390 	FDB DDOT-CFAOFF
04400 	FDB BIF+2
04410 	FDB 0
04420 	FDB 0
04430 DOTR	DOCOL	see fig-FORTH model
04440 	FDB TOR
04450 	FDB STOD
04460 	FDB RFROM
04470 	FDB DDOTR
04480 	FDB SEMIS
04490 *
04500 	FCC '.'
04510 	FCB 1
04520 	FCB MFORE
04530 	FDB DOTR-CFAOFF
04540 	FDB BIF+2
04550 	FDB DDUP-CFAOFF
04560 	FDB DOTLIN-CFAOFF
*/
static character_t sDOT[] = "\x1" ".";
definition_header_s hDOT =	
{	{ (natural_t) sDOT },
	{ 0 },
	{ /* (natural_t) &hDOTR */ 0 },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
#if defined DEBUGGING && DEBUGGING >= 2 && DEBUGGING < 0x10
	{ (natural_t) DOT }
#endif /* defined DEBUGGING && DEBUGGING >= 2 && DEBUGGING < 0x10 */
};
/*
04570 DOT	DOCOL	see fig-FORTH model
04580 	FDB STOD
04590 	FDB DDOT
04600 	FDB SEMIS
04610 *
*/
#if defined DEBUGGING && DEBUGGING >= 2 && DEBUGGING < 0x10
void DOT(void)
{	/* kludge it now for debugging because there's a lot of nested reference here. */
	/* By the time we want base conversion, we probably will already have the referenced words ready, */
	/* So we'll hard code it to unsigned hexadecimal. */
	natural_t integer = ( * SP++ ).integer;
	fprintf( standardOutput, "%lx", integer );
}
#endif /* defined DEBUGGING && DEBUGGING >= 2 && DEBUGGING < 0x10 */


/*
04620 	FCC '?'
04630 	FCB 1
04640 	FCB MFORE
04650 	FDB DOT-CFAOFF
04660 	FDB BIF+2
04670 	FDB TOVID-CFAOFF
04680 	FDB TNULL-CFAOFF
04690 QDOT	LDD [,U++]
04700 	PSHU D
04710 	BRA DOT
04720 *
04800 	FCC 'MESSAGE'
04810 	FCB 7
04820 	FCB MFORE
04830 	FDB DOTLIN-CFAOFF
04840 	FDB BIF+2
04850 	FDB MAX-CFAOFF
04860 	FDB 0
04870 MESS	DOCOL	see fig-FORTH model
04880 	FDB WARN
04890 	FDB FETCH print text?
04893 	FDB ONE
04896 	FDB AND
04900 	FDB ZBR
04910 	FDB MESSN-*-2
04920 	FDB DDUP not 0?
04930 	FDB ZBR
04940 	FDB MESSX-*-2
04950 	FDB LIT
04960 	FDB 4
04970 	FDB OFFSET
04980 	FDB FETCH
04990 	FDB BPSCR
05000 	FDB SLASH screen offset
05010 	FDB SUB
05020 	FDB DOTLIN
05030 	FDB BRANCH
05040 	FDB MESSX-*-2
05050 MESSN	FDB XDOTQ
05060 	FCB 6
05070 	FCC 'MSG # '
05080 	FDB DOT
05090 MESSX	FDB SEMIS
05190 *
*/