/*
**  bif3b_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF3B/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bifb_a.h"
#include "bif7b_a.h"	/* To link into the BIF vocabulary. */
#include "bif3b_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
04110 	FCC 'TYPE'
04112 	FCB 4
04114 	FCB MFORE
04116 	FDB XMACH-CFAOFF
04118 	FDB BIF+2
04120 	FDB 0
04122 	FDB 0
*/
static character_t sTYPE[] = "\x4" "TYPE";
definition_header_s hTYPE =	
{	{ (natural_t) sTYPE },
	{ 0 },
	{ /* (natural_t) &hXMACH */ 0 },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) TYPE }
};
/*
04130 TYPE	LDD ,U
04132 	BEQ TYPEQ
04135 	ADDD 2,U
04140 	STD ,U for compare
04145 	LDX 2,U
04150 TYPEL	LDB ,X+
04155 	STX 2,U
04160 	CLRA
04165 	PSHU D
04170 	DOCOL
04175 	FDB EMIT
04180 	FDB XMACH
04185 	LDX 2,U
04190 	CMPX ,U
04195 	BLO TYPEL
04197 TYPEQ LEAU 4,U
04200 	NEXT
04205 *
*/
void TYPE(void)
{	character_t * string = SP[ 1 ].chString;
	character_t * boundary = string + SP[ 0 ].integer;
	if ( SP[ 0 ].integer > 0 )
	{	do 
		{	( * -- SP ).integer = * string++;
			EMIT();
		} while ( string < boundary );
	}
	SP += 2;
}


/*
04210 	FCC '(.")'
04212 	FCB MCOMP.OR.4
04214 	FCB MFORE
04216 	FDB TYPE-CFAOFF
04218 	FDB BIF+2
04220 	FDB XPLOOP-CFAOFF
04222 	FDB XSCODE-CFAOFF
04230 XDOTQ	LDB ,Y+ count
04235 	CLRA
04240 	TFR Y,X string
04245 	LEAY D,Y past it
04250 	PSHU D,X
04255 	BRA TYPE
04300 *
04310 	FCC 'ID.'
04312 	FCB 3
04314 	FCB MFORE
04316 	FDB XDOTQ-CFAOFF
04318 	FDB BIF+2
04320 	FDB 0
04322 	FDB 0
04330 IDDOT	PULU X nfa
04335 	LDB ,X
04340 	ANDB #NLMASK
04350 	NEGB
04360 	LEAX B,X past it
04370 	NEGB
04380 	CLRA
04390 	PSHU D,X
04400 	BRA TYPE
04410 *
04510 	FCC 'FILL-IN'
04512 	FCB MCOMP.OR.7
04514 	FCB MFORE
04516 	FDB IDDOT-CFAOFF
04518 	FDB BIF+2
04520 	FDB 0
04522 	FDB 0
04530 FILLIN	LDX <UP
04540 	LDD UDP,X
04550 	SUBD ,U adr
04555 	SUBD #2 past
04560 	STD [,U++]
04570 	NEXT
04590 *
04610 	FCC 'BEGIN'
04612 	FCB MCOMP.OR.MIMM.OR.5
04614 	FCB MFORE
04616 	FDB FILLIN-CFAOFF
04618 	FDB BIF+2
04620 	FDB BASE-CFAOFF
04622 	FDB 0
04630 BEGIN	DOCOL	see fig-FORTH model
04640 	FDB QCOMP
04650 	FDB HERE target
04660 	FDB LIT
04670 	FDB ('B)*256+'E
04680 	FDB SEMIS
04690 *
04710 	FCC 'AGAIN'
04712 	FCB MCOMP.OR.MIMM.OR.5
04714 	FCB MFORE
04716 	FDB BEGIN-CFAOFF
04718 	FDB BIF+2
04720 	FDB 0
04722 	FDB 0
04730 AGAIN	DOCOL	see fig-FORTH model
04740 	FDB LIT
04750 	FDB ('B)*256+'E
04760 	FDB QPAIRS
04765 	FDB COMP
04770 	FDB BRANCH
04775 	FDB BACK
04780 	FDB SEMIS
04790 *
04810 	FCC 'UNTIL'
04812 	FCB MCOMP.OR.MIMM.OR.5
04814 	FCB MFORE
04816 	FDB AGAIN-CFAOFF
04818 	FDB BIF+2
04820 	FDB USLASH-CFAOFF
04822 	FDB 0
04830 UNTIL	DOCOL	see fig-FORTH model
04840 	FDB LIT
04850 	FDB ('B)*256+'E
04860 	FDB QPAIRS
04865 	FDB COMP
04870 	FDB ZBR
04875 	FDB BACK
04880 	FDB SEMIS
04890 *
04910 	FCC 'WHILE'
04912 	FCB MCOMP.OR.MIMM.OR.5
04914 	FCB MFORE
04916 	FDB UNTIL-CFAOFF
04918 	FDB BIF+2
04920 	FDB WARM-CFAOFF
04922 	FDB WORDPD-CFAOFF
04930 WHILE	DOCOL
04940 	FDB DUP
04950 	FDB LIT
04960 	FDB ('B)*256+'E
04970 	FDB QPAIRS
04980 	FDB COMP
04990 	FDB ZBR
05000 	FDB HERE adr
05010 	FDB ZERO
05020 	FDB COMMA
05030 	FDB LIT
05040 	FDB ('W)*256+'H
05050 	FDB SEMIS
05090 *
05110 	FCC 'REPEAT'
05112 	FCB MCOMP.OR.MIMM.OR.6
05114 	FCB MFORE
05116 	FDB WHILE-CFAOFF
05118 	FDB BIF+2
05120 	FDB REPEAL-CFAOFF
05122 	FDB ROOT-CFAOFF
05130 REPEAT	DOCOL
05140 	FDB LIT
05150 	FDB ('W)*256+'H
05160 	FDB QPAIRS
05170 	FDB TOR
05180 	FDB AGAIN
05190 	FDB RFROM
05200 	FDB FILLIN
05210 	FDB SEMIS
05290 *
05310 	FCC 'DO'
05312 	FCB MCOMP.OR.MIMM.OR.2
05314 	FCB MFORE
05316 	FDB WHILE-CFAOFF
05318 	FDB BIF+2
05320 	FDB CFEH-CFAOFF
05322 	FDB ENDIF-CFAOFF
05330 DO	DOCOL	see fig-FORTH model
05340 	FDB COMP
05350 	FDB XDO
05360 	FDB HERE
05370 	FDB LIT
05380 	FDB ('D)*256+'O
05390 	FDB SEMIS
05400 *
*/