/* The cheapest, quickest to write program I can make up to strip line numbers.
// The line number field is variable width and has optional leading whitespace.
// Written by Joel Rees, Takino, Hyogo, Japan, January 2000.
// Too Q&D to bother copyrighting, assigned to the public domain.
// Since it is in the public domain, it can't be copyrighted. 
// Your personal expression of it may be copyrightable, however.
//
// The changes in my programing style prove that I am turning Japanese.
// Current e-mail: joel_rees@sannet.ne.jp, reiisi@nettaxi.com
*/


/* #define ON_Macintosh */


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>


#if defined ON_Macintosh
#	pragma		push
#	pragma		only_std_keywords off
#	include		<Types.h>
#	include		<Fonts.h>
#	pragma		pop
#endif


#if defined ON_Macintosh
#	include		<sioux.h>
#	include		<console.h>
#endif


#define BUFFERCHARS	1024
#define BUFFSIZE	( 1024 + 1 )	/* One shot, should be no lines this large anyway. */


int nocaseCompare( char * range, char * object )
{	int difference = 0;
	printf( "comparing %s in %s:", object, range );
	do
	{	difference = ( toupper( * range++ ) - toupper( * object++ ) );
		printf( "%d,", difference );
	} while ( ( difference == 0 ) && ( * object != '\0' ) );	/* terminating NUL is convenient in the math. */
	printf( "%d\n", difference );
	return difference;
}


char * nocaseScan( char * range, char * object )
{	char * inObject = object;
	while ( ( * range != '\0' ) && ( nocaseCompare( range, object ) != 0 ) )	/* Not going for speed. */
	{	++range;
	}
	return ( * range == '\0' ) ? NULL : range;
}


#if defined NOT_USING_THIS
/* Decided I want to try to matche fgets(). */
size_t readline( FILE * file, char buffer[], size_t limit )
{	size_t i;
	int ch;
	int lookahead;
	for ( i = 0; i < limit; ++i )
	{	ch = fgetc( file );
		if ( ch == EOF )
		{	buffer[ i ] = '\0';
			--i;	/* Report the count of stored characters. */
			break;
		}
		else if ( ( ch == '\n') || ( ch == '\r' ) )
		{	if ( i == limit - 1 )
			{	ungetc( ch, file );
				buffer[ i ] = '\0';
				--i;	/* Report the count of stored characters. */
			}
			else 
			{	buffer[ i ] = '\n';	/* convert to standard C library new line */
				buffer[ i + 1 ] = '\0';
				lookahead = fgetc( file );
				if ( ( ( ch == '\n' ) && ( lookahead != '\r' ) )
					 || ( ( ch == '\r' ) && ( lookahead != '\n' ) ) )
				{	ungetc( lookahead );	/* Don't drop it. */
				}
				/* If it was a CRLF or LFCR, drop the second of the pair. */
			}
			break;
		}
		else
		{	buffer[ i ] = (char) ch;
		}
	}
	return i;
}
#endif /* defined NOT_USING_THIS */
size_t readline( FILE * file, char buffer[], size_t limit )
{	size_t i;
	int ch;
	int lookahead;
	--limit;	/* store limit - 1 characters */
	for ( i = 0; i < limit; ++i )
	{	ch = fgetc( file );
		if ( ch == EOF )
		{	break;
		}
		else if ( ( ch == '\n') || ( ch == '\r' ) )
		{
			buffer[ i++ ] = '\n';	/* convert to standard C library new line for the platform */
			lookahead = fgetc( file );
			if ( ( ( ch == '\n' ) && ( lookahead != '\r' ) )
				 || ( ( ch == '\r' ) && ( lookahead != '\n' ) ) )
			{	ungetc( lookahead, file );	/* Not a pair, don't drop it. */
			}
			/* If it was a CRLF or LFCR, drop the second of the pair. */
			break;
		}
		else
		{	buffer[ i ] = (char) ch;
		}
	}
	buffer[ i ] = '\0';
	return i;
}


int main( int argc, char * argv[] )
{
	int ch;
	FILE * input = stdin;
	int fdbFlag = 0;
/* */
#	if defined ON_Macintosh
	{	Str31 name = "\pOsaka|";
		short familyID = 0;
	/* */
		GetFNum( name, &familyID );
		SIOUXSettings.fontsize = 12;
		SIOUXSettings.fontid = familyID;
		SIOUXSettings.showstatusline = 1;
		argc = ccommand( &argv );
	}
#	endif
	/* Use the pseudo-command-line as simple file interface
	// argc = ccommand( &argv ); 
	*/
	if ( argc > 1 )
	{	int arg;
		for ( arg = 1; arg < argc; ++arg )
		{	if ( ( argc == 2 ) || ( ( strcmp( argv[ arg ], "-f" ) == 0 ) && ( ++arg < argc ) ) )
			{	input = fopen( argv[ arg ], "rb" );
				if ( input == NULL )
				{	fprintf( stderr, "Failed to open %s\n", argv[ arg ] );
					return EXIT_FAILURE;
				}
			}
			else if ( strcmp( argv[ arg ], "-fdb" ) == 0 )
			{	fdbFlag = 1;
			}
			/* else if ( ( strcmp( argv[ arg ], "-e" ) == 0 ) && ( ++arg < argc ) )
			{
			} 
			*/
			else
			{	fprintf( stderr, "Unknown option #%d: %s\n", arg, argv[ arg ] );
			}
		}
	}
/* */
	while ( !feof( input ) )
	{
		char buffer[ BUFFSIZE ];
		char * scan = buffer;
		char * firstmark = buffer;
		size_t lineLength;
		
		buffer[ 0 ] = '\0';	/* In case EOF comes on a completely empty line. */
		lineLength = readline( input, buffer, BUFFSIZE );
		/* printf( "length of buffer: %d\n\n", strlen( buffer ) ); */
		while ( isspace( * scan ) )
		{	++scan; 
		}
		while ( isdigit( * scan ) )	/* Kill the line number. */
		{	++scan;
		}
		if ( !fdbFlag )
		{	fputs( scan, stdout );
		}
		else
		{
			int foundFDB = 0;
			char * labelMark = NULL;

			while ( isspace( * scan ) )
			{	++scan;
			}
			firstmark = scan;
			if ( nocaseCompare( scan, "FDB" ) == 0 )
			{	foundFDB = 1;	printf( "found first time at %s\n", scan );
			}
			else
			{	char * tokenEnd = NULL;
				while ( ( * scan != '\n' ) && !isspace( * scan ) )	
				{	++scan; 
				}
				tokenEnd = scan;
				while ( isspace( * scan ) )
				{	++scan; 
				}
				if ( nocaseCompare( scan, "FDB" ) == 0 )
				{	foundFDB = 1;	/* And we assume printpoint is pointing to a label. */
					* tokenEnd = '\0';	/* Make the label its own string. */
					labelMark = firstmark;
					printf( "found second time at %s\n", scan );
				}
			}
			if ( foundFDB )
			{	scan += 3;
				while ( isspace( * scan ) )
				{	++scan; 
				}
				if ( labelMark != NULL )
				{	printf( "/* %s: */\n", labelMark );
				}
			}
			buffer[ lineLength - 1 ] = '\0';
			fputs( "\t\t{ (natural_t) &h", stdout );
			fputs( scan, stdout ); 
			fputs( "\t},\n", stdout );
		}
	}
	return EXIT_SUCCESS;
}

