/*
**  bif1_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF1/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bif7b_a.h"	/* To link into the BIF vocabulary. */
#include "bif1_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
01000 	FCC 'MOVE'
01010 	FCB 4
01020 	FCB MFORE
01030 	FDB PREF-CFAOFF
01040 	FDB BIF+2
01050 	FDB MINUS-CFAOFF
01060 	FDB NFA-CFAOFF
01070 MOVE	LDD ,U++ count=0?
01080 	BEQ MOVEX
01090 	PSHS Y,U
01100 	LDY ,U
01110 	LDU 2,U
01120 MOVELP	PULU X
01130 	STX ,Y++
01140 	SUBD #1
01150 	BNE MOVELP
01160 	PULS Y,U
01170 MOVEX	LEAU 4,U
01180 	NEXT
01190 *
01200 	FCC 'CMOVE'
01210 	FCB 5
01220 	FCB MFORE
01225 	FDB MOVE-CFAOFF
01230 	FDB BIF+2
01240 	FDB CFA-CFAOFF
01250 	FDB COMP-CFAOFF
01260 CMOVE	LDD #0
01270 	SUBD ,U++
01280 	PSHS A,Y
01290 	PULU X,Y
01300 	BEQ CMOVEX
01310 CMOVEL	LDA ,Y+
01320 	STA ,X+
01330 	INCB
01340 	BNE CMOVEL
01350 	INC ,S
01360 	BNE CMOVEL
01370 CMOVEX	PULS A,Y
01380 	NEXT
01390 *
01400 	FCC 'U*'
01410 	FCB 2
01420 	FCB MFORE
01430 	FDB CMOVE-CFAOFF
01440 	FDB BIF+2
01450 	FDB TOG-CFAOFF
01460 	FDB UPDATE-CFAOFF
01470 USTAR	LEAS -4,S
01480 	LDA 1,U LEAST
01490 	LDB 3,U
01500 	MUL
01510 	STD 2,S
01520 	LDA ,U most
01530 	LDB 2,U
01540 	MUL
01550 	STD ,S
01560 	LDD 1,U inner
01570 	MUL
01580 	ADDD 1,S
01590 	BCC *+4
01600 	INC ,S
01605 	STD 1,S
01610 	LDA ,U
01620 	LDB 3,U
01630 	MUL
01640 	ADDD 1,S
01650 	BCC *+4
01660 	INC ,S
01670 	STD 1,S
01680 	PULS D,X
01690 	STD ,U
01700 	STX 2,U
01710 	NEXT
01720 *
01730 	FCC 'U/'
01740 	FCB 2
01750 	FCB MFORE
01760 	FDB USTAR-CFAOFF
01770 	FDB BIF+2
01780 	FDB 0
01790 	FDB 0
01800 USLASH	LDA #17 bit ct
01810 	PSHS A
01820 	LDD 2,U dividend
01830 USLDIV	CMPD ,U divisor
01840 	BHS USLSUB
01850 	ANDCC #.NOT.1
01860 	BRA USLBIT
01870 USLSUB	SUBD ,U
01880 	ORCC #1 quotient,
01890 USLBIT	ROL 5,U save it
01900 	ROL 4,U
01910 	DEC ,S more bits?
01920 	BEQ USLR
01930 	ROLB remainder
01940 	ROLA
01950 	BCC USLDIV
01960 	BRA USLSUB
01970 USLR	LEAS 1,S
01980 	LEAU 2,U
01990 	LDX 2,U
02000 	STD 2,U
02010 	STX ,U
02020 	NEXT
02030 *
02200 	FCC 'AND'
02210 	FCB 3
02220 	FCB MFORE
02230 	FDB USLASH-CFAOFF
02240 	FDB BIF+2
02250 	FDB ABS-CFAOFF
02260 	FDB BACK-CFAOFF
02270 AND	PULU D
02280 	ANDB 1,U
02290 	ANDA ,U
02300 	STD ,U
02310 	NEXT
02320 *
02330 	FCC 'OR'
02340 	FCB 2
02350 	FCB MFORE
02360 	FDB AND-CFAOFF
02370 	FDB BIF+2
02380 	FDB OCT-CFAOFF
02390 	FDB OUT-CFAOFF
02400 OR	PULU D
02410 	ORB 1,U
02420 	ORA ,U
02430 	STD ,U
02440 	NEXT
02450 *
02460 	FCC 'XOR'
02470 	FCB 3
02480 	FCB MFORE
02490 	FDB OR-CFAOFF
02500 	FDB BIF+2
02510 	FDB 0
02520 	FDB 0
02530 XOR	PULU D
02540 	EORB 1,U
02550 	EORA ,U
02560 	STD ,U
02570 	NEXT
02580 *
02590 	FCC 'SP@'
02600 	FCB 3
02610 	FCB MFORE
02620 	FDB XOR-CFAOFF
02630 	FDB BIF+2
02640 	FDB SPSTO-CFAOFF
02660 	FDB 0
02670 SPFEH	TFR U,X
02680 	PSHU X
02690 	NEXT
02700 *
02710 	FCC 'SP!'
02720 	FCB 3
02730 	FCB MFORE
02740 	FDB SPFEH-CFAOFF
02750 	FDB BIF+2
02760 	FDB 0
02770 	FDB 0
02780 SPSTO LDX <UP
02790 	LDU US0,X
02793 	CLR ,U hole
02796 	CLR 1,U
02800 	NEXT
02810 *
02820 	FCC 'RP!'
02830 	FCB 3
02840 	FCB MFORE
02850 	FDB SPSTO-CFAOFF
02860 	FDB BIF+2
02870 	FDB 0
02880 	FDB 0
02890 RPSTO LDX <UP
02900 	LDS UR0,X
02903 	CLR ,S hole
02906 	CLR 1,S
02910 	NEXT
02920 *
*/


/*
02930 	FCC ';S'
02940 	FCB MIMM.OR.2
02950 	FCB MFORE
02960 	FDB RPSTO-CFAOFF
02970 	FDB BIF+2
02980 	FDB 0
02990 	FDB 0
*/
static character_t sSEMIS[] = "\x2" ";S";
definition_header_s hSEMIS =
{	{ (natural_t) sSEMIS },
	{ MIMM },
	{ (natural_t) /* &hRPSTO */ 0 },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) SEMIS }
};
/*
03000 SEMIS	PULS Y un-nest
03010 	NEXT
03020 *
*/
void SEMIS(void)
{	IP = ( * RP++ ).cellp;
}


/*
03030 	FCC 'LEAVE'
03040 	FCB MCOMP.OR.5
03050 	FCB MFORE
03060 	FDB SEMIS-CFAOFF
03070 	FDB BIF+2
03080 	FDB LATEST-CFAOFF
03090 	FDB LFA-CFAOFF
03100 LEAVE	LDD ,S index
03110 	STD 2,S to limit
03120 	NEXT
03130 *
03140 	FCC '>R'
03150 	FCB MCOMP.OR.2
03160 	FCB MFORE
03170 	FDB LEAVE-CFAOFF
03180 	FDB BIF+2
03190 	FDB GT-CFAOFF
03200 	FDB QDOT-CFAOFF
03210 TOR	PULU D
03220 	PSHS D
03230 	NEXT
03240 *
03250 	FCC 'R>'
03260 	FCB MCOMP.OR.2
03270 	FCB MFORE
03280 	FDB TOR-CFAOFF
03290 	FDB BIF+2
03300 	FDB R-CFAOFF
03310 	FDB REPEAT-CFAOFF
03320 RFROM	JMP <XVAR not JSR!
03350 *
03360 	FCC 'R'
03370 	FCB 1
03380 	FCB MFORE
03390 	FDB RFROM-CFAOFF
03400 	FDB BIF+2
03410 	FDB QUIT-CFAOFF
03420 	FDB RNUM-CFAOFF
03430 R	JMP I
03431 *
03432 	FCC '='
03433 	FCB 1
03434 	FCB MFORE
03435 	FDB R-CFAOFF
03436 	FDB BIF+2
03437 	FDB LT-CFAOFF
03438 	FDB QCOMP-CFAOFF
03439 EQ	PULU D
03440 	CMPD ,U
03441 	BEQ TRUE
03442 	BRA FALSE
03451 *
03452 	FCC '<'
03453 	FCB 1
03454 	FCB MFORE
03455 	FDB EQ-CFAOFF
03456 	FDB BIF+2
03457 	FDB SCODE-CFAOFF
03458 	FDB BEGHSH-CFAOFF
03459 LT	LDD 2,U
03460 	CMPD ,U++
03461 	BLT TRUE
03462 	BRA FALSE
03463 *
03490 	FCC '0='
03491 	FCB 2
03492 	FCB MFORE
03493 	FDB LT-CFAOFF
03494 	FDB BIF+2
03500 	FDB 0
03510 	FDB ONE-CFAOFF
03520 ZEQ	LDD ,U
03530 	BNE FALSE
03540 TRUE	LDD #-1
03550 	STD ,U
03560 	NEXT
03570 *
03580 	FCC '0<'
03590 	FCB 2
03600 	FCB MFORE
03610 	FDB ZEQ-CFAOFF
03620 	FDB BIF+2
03630 	FDB ZERO-CFAOFF
03640 	FDB ZEQ-CFAOFF
03650 ZLESS	LDA ,U
03660 	BMI TRUE
03665 FALSE	LDD #0
03670 	STD ,U
03680 	NEXT
03681 *
03682 	FCC '>'
03683 	FCB 1
03684 	FCB MFORE
03685 	FDB ZLESS-CFAOFF
03686 	FDB BIF+2
03687 	FDB 0
03688 	FDB TOPRT-CFAOFF
03689 GT	LDD 2,U
03690 	CMPD ,U++
03691 	BGT TRUE
03692 	BRA FALSE
03693 *
03700 	FCC '+'
03710 	FCB 1
03720 	FCB MFORE
03730 	FDB GT-CFAOFF
03740 	FDB BIF+2
03750 	FDB PAREN-CFAOFF
03760 	FDB SLASH-CFAOFF
03770 ADD	PULU D
03780 	ADDTOP
03810 *
03820 	FCC '-'
03830 	FCB 1
03840 	FCB MFORE
03850 	FDB ADD-CFAOFF
03860 	FDB BIF+2
03870 	FDB 0
03880 	FDB 0
03890 SUB	LDD 2,U
03900 	SUBD ,U++
03910 	STD ,U
03920 	NEXT
03930 *
03940 	FCC 'D+'
03950 	FCB 2
03960 	FCB MFORE
03970 	FDB SUB-CFAOFF
03980 	FDB BIF+2
03990 	FDB CONST-CFAOFF
04000 	FDB DABS-CFAOFF
04010 DADD	LDD 6,U
04020 	ADDD 2,U
04030 	STD 6,U
04040 	LDD 4,U
04050 	ADCB 1,U
04060 	ADCA ,U
04070 	LEAU 4,U
04080 	STD ,U
04090 	NEXT
04100 *
04120 	FCC 'D-'
04130 	FCB 2
04140 	FCB MFORE
04150 	FDB DADD-CFAOFF
04160 	FDB BIF+2
04170 	FDB DCHS-CFAOFF
04180 	FDB DDOT-CFAOFF
04190 DSUB	LDD 6,U
04200 	SUBD 2,U
04210 	STD 6,U
04220 	LDD 4,U
04230 	SBCB 1,U
04240 	SBCA ,U
04250 	LEAU 4,U
04260 	STD ,U
04270 	NEXT
04280 *
04290 	FCC 'MINUS'
04300 	FCB 5
04310 	FCB MFORE
04320 	FDB DSUB-CFAOFF
04330 	FDB BIF+2
04340 	FDB 0
04350 	FDB MOD-CFAOFF
04360 MINUS	LDD #0
04370 	SUBD ,U
04380 	STD ,U
04390 	NEXT
04400 *
04410 	FCC 'DMINUS'
04420 	FCB 6
04430 	FCB MFORE
04440 	FDB MINUS-CFAOFF
04450 	FDB BIF+2
04460 	FDB 0
04470 	FDB 0
04480 DMINUS	LDD #0
04490 	SUBD 2,U
04500 	STD 2,U
04510 	LDD #0
04520 	SBCB 1,U
04530 	SBCA ,U
04570 	STD ,U
04580 	NEXT
04590 *
04600 	FCC 'OVER'
04610 	FCB 4
04620 	FCB MFORE
04630 	FDB DMINUS-CFAOFF
04640 	FDB BIF+2
04650 	FDB OR-CFAOFF
04660 	FDB PFA-CFAOFF
04670 OVER	LDD 2,U
04680 	PSHU D
04690 	NEXT
04700 *
04710 	FCC 'DROP'
04720 	FCB 4
04730 	FCB MFORE
04740 	FDB OVER-CFAOFF
04750 	FDB BIF+2
04760 	FDB DPL-CFAOFF
04770 	FDB EMIT-CFAOFF
04780 DROP	LEAU 2,U
04790 	NEXT
04800 *
04810 	FCC 'SWAP'
04820 	FCB 4
04830 	FCB MFORE
04840 	FDB DROP-CFAOFF
04850 	FDB BIF+2
04860 	FDB ROT-CFAOFF
04870 	FDB VAR-CFAOFF
04880 SWAP	PULU D,X
04890 	PSHU D
04900 	PSHU X
04910 	NEXT
04920 *
04930 	FCC 'DUP'
04940 	FCB 3
04940 	FCB MFORE
04950 	FDB SWAP-CFAOFF
04960 	FDB BIF+2
04970 	FDB 0 * DUMP-CFAOFF
04980 	FDB ELSE-CFAOFF
*/
static character_t sDUP[] = "\x3" "DUP";
definition_header_s hDUP =	
{	{ (natural_t) sDUP },
	{ 0 },
	{ /* (natural_t) &hSWAP */ 0 },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) DUP }
};
/*
04990 DUP	LDD ,U
05000 	PSHU D
05010 	NEXT
05020 *
*/
void DUP(void)
{	cell_u cell = SP[ 0 ];
	( * --SP ) = cell;
}


/*
05030 	FCC '+!'
05040 	FCB 2
05050 	FCB MFORE
05060 	FDB DUP-CFAOFF
05070 	FDB BIF+2
05080 	FDB 0
05090 	FDB 0
05100 ADDSTO	PULU X
05110 	LDD ,X
05120 	ADDD ,U++
05130 	STD ,X
05140 	NEXT
05150 *
*/