/*
**  bifst_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/07/25.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIFST/A, as mechanically as possible.
**
*/


#include <stddef.h>


#include "bifst_a.h"
#include "bif_m.h"
#include "bif7b_a.h"


static byte_t memoryImage[ ILIM ];
/* For bifst_a.h:
00000010 * Start up routines for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00100 *
00105 ILIM	EQU $8000 memory
00110 IBUFF	EQU ILIM-BCT*(BWID+4)
00120 IPAD	EQU IBUFF-TWID max
00130 IHASH	EQU IPAD-34
00140 IWPAD	EQU IHASH-NLMASK-2
00150 ITIB	EQU IWPAD-TWID
00160 IUSER	EQU ITIB-UEND
00170 IRP0	EQU IUSER-2
00180 ISP0	EQU IRP0-258
00190 * dictionary below here
00400 *
*/

/* This is not organized well, at all. I'm just going to use it as it is, for now.
** 
00410 ORIG	EQU * initials for task 0, offsets
00420 	NOP 0
00430 	JMP COLD 1
00440 	NOP 4
00450 	JMP WARM 5
00460 	FDB $6809 cpu 8
00470 	FDB 0 rev $0A
00480 	FDB FORGET-CFAOFF CURRENT for COLD $0C
00490 	FDB 8 backspace $0E
00500 	FDB IUSER task 0 user area $10
00510 	FDB ISP0 $12
00520 	FDB IRP0 $14
00530 	FDB ITIB $16
00540 	FDB NLMASK not used $18
00550 	FDB 1 WARNING $1A
00560 	FDB FOLLOW-1 FENCE for COLD $1C
00570 	FDB FOLLOW DP for COLD $1E
00580 	FDB BIF+2 defs root $20
00590 	FDB IPAD $22
00600 	FDB IWPAD $24
00610 	FDB 32 terminal columns $26
00620 	FDB IBUFF $28
00630 	FDB ILIM $2A
01000 *
*/
boot_constants_s	ORIG =
{	COLD,
	WARM,
	{ 0x43 },	/* CPUid is 'C' */
	{ 0 },	/* version */
	{ (natural_t) &hFORGET },	/* initial current */
	{ '\b' },
	{ (natural_t) ( memoryImage + IUSER ) },	/* This cast is not the best idea, but should get me running. */
	{ (natural_t) ( memoryImage + ISP0 ) },
	{ (natural_t) ( memoryImage + IRP0 ) },
	{ (natural_t) ( memoryImage + ITIB ) },
	{ NLMASK },
	{ 1 },	/* disk on-line flag */
	/* Either I change the fence to see a flag or a link, or I copy the headers into memoryImage. */
	{ 0 /* flag, since we don't know where the headers end up, was FOLLOW - 1 */ },	/* FENCE for FORGET ** wrong value? ** */
	{ (natural_t) ( memoryImage ) /* was FOLLOW */ },	/* initial allocation pointer. */
	{ (natural_t) &hBIF },	/* initial context root, both contexts. */
	{ (natural_t) ( memoryImage + IPAD ) },
	{ (natural_t) ( memoryImage + IWPAD ) },
	{ 32 },
	{ (natural_t) ( memoryImage + IBUFF ) },
	{ (natural_t) ( memoryImage + ILIM ) }
};


/* Initially, one big (so to speak) array of bytes, following the 6809 code (so to speak). 
*/


/* Could declare the function here, but want to follow the 6809 code order where I can. */
static void DOREGS(void);
static void PRUNE(void);


/*
01010 	FCC 'COLD'
01020 	FCB 4
01030 	FCB MFORE
01040 	FDB 0
01050 	FDB BIF+2
01060 	FDB 0
01070 	FDB 0
*/
static character_t sCOLD[] = "\x4COLD";
definition_header_s hCOLD =	
{	{ (natural_t) sCOLD },
	{ 0 },
	{ 0 },	/* This is the very first definition in the initial base vocabulary. */
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },	/* Full leaf node. */
	{ 0 },
	{ (natural_t) COLD }
};
//HEADER( COLD, 0 /* no special modes. */, WARM, BIF, COLD, 0 );
void COLD(void)
{
/* 01080 COLD	LEAY DOREGS,PCR */
/* 01090 	EXG PC,Y call */ /* Set up the essential registers, called without stack. */
	DOREGS();	/* Points W to the initialization table instead of Y, use UP instead of X. */
/* 01100 	SETDP VDP */
/* 01110 	CLR $71 for BASIC reset */ /* We aren't taking over the whole machine. */
/* 01120 	LDD -4,Y */
/* 01130 	STD UCURR,X */
	UP.task->lastDefined = W.bootConstantsp->initialCurrent;
/* 01140 	LDD $0C,Y */
/* 01150 	STD UFENCE,X */	/* work from here, fixing the initialization table as I go */
	UP.task->forgetFence = W.bootConstantsp->initialForgetFence;
/* 01160 	LDD $0E,Y */
/* 01170 	STD UDP,X */
	UP.task->dictionaryAllocationPointer = W.bootConstantsp->initialDictionaryAllocationPointer;
/* 01180 	LDD $10,Y */
/* 01190 	STD UROOT,X */
/* 01200 	STD UDROOT,X */
	UP.task->definitionContextRoot = UP.task->searchContextRoot = W.bootConstantsp->initialDefinitionContextRoot;
	/* Before we can prune, we must make the tree. By hand or by code? ** Must come back here! ** **************** */
/* 01210 	PSHU D     Initial vocabularies */
/* 01220 	BSR PRUNE  must ALL be PRUNEd! */
	( * --SP ) = W.bootConstantsp->initialDefinitionContextRoot;
	PRUNE();
/* 01230 	LDD #EDITOR+2 */
/* 01240 	PSHU D */
/* 01250 	BSR PRUNE */
/* 01260 	LDD #ASMBLR+2 */
/* 01270 	PSHU D */
/* 01280 	BSR PRUNE */
/* 01290 	JMP WARM+5 */
	WARM();
}


/* 01300 	SETDP 0 */
/* 01310 * Watch stack (vocabulary) depth! */
/* 01315 	SETDP VDP */
static void PRUNE(void)
{
/* 01320 PRUNE	PSHS D,X,Y */
/* 01330 	LDY <UP */
/* 01340 	LDX ,U++ vocab */
/* 01344 	BEQ PRUNEX+2 */
/* 01348 	LDD ,X root */
/* 01352 	BEQ PRUNEX+2 */
/* 01356 	CMPD UFENCE,Y */
/* 01360 	BLS PRUNSK */
/* 01364 	LDD #0 */
/* 01368 	STD ,X */
/* 01372 	BRA PRUNEX+2 */
/* 01376 PRUNSK	TFR D,X */
/* 01380 	LDD #0 */
/* 01386 	PSHS D mark */
/* 01390 PRUNL	LDD RTOFF,X */
/* 01400 	BEQ PRUNLF */
/* 01410 	CMPD UFENCE,Y */
/* 01420 	BLS PRUNLF-2 */
/* 01430 	LDD #0 make leaf */
/* 01440 	STD RTOFF,X */
/* 01450 	BRA PRUNLF */
/* 01460 	PSHS D for later */
/* 01470 PRUNLF	LDD LFTOFF,X */
/* 01480 	BEQ PRUNEX-2 */
/* 01490 	CMPD UFENCE,Y */
/* 01500 	BHI PRUNL0 */
/* 01510 	TFR D,X go left */
/* 01520 	BRA PRUNL */
/* 01530 PRUNL0	LDD #0 make leaf */
/* 01540 	STD LFTOFF,X */
/* 01550 	LDX ,S++ go right? */
/* 01560 PRUNEX	BNE PRUNL */
/* 01570 	PULS D,X,Y,PC */
}
/* 01580 	SETDP 0 */
/* 01590 * 
*/


/* Point the essential registers to real/available memory.
*/
/* 02000 	SETDP 0 */
static void DOREGS(void)
{
/* 02010 DOREGS	LDS #IRP0 */
	/* These are to make the CPU sane. Need to get these from the initializations table, instead? */
	RP = (cell_u *) memoryImage + IRP0;
/* 02020 	PSHS CC save */ /* Not real registers, no need to mask interrupts. */
/* 02030 	ORCC #$50 mask ints */
/* 02040 	PSHS Y return adr */ /* Using a standard C call, no need to manipulate the return address. */
/* 02050 	LDD #DPAGE */
/* 02060 	TFR A,DP */
/* 02070 	SETDP VDP */ /* Not messing with short (DP) addressing. */
/* 02080 	LDY #ORIG+$10 */ /* We'll point at with W, instead. */
	W.bytep = (byte_p) &ORIG;
/* 02090 	LDX ,Y */
/* 02100 	STX <UP */
	UP = W.bootConstantsp->initialTaskBase;
/* 02110 	LDU #ISP0 */
	SP = (cell_u *) memoryImage + ISP0;
/* 02120 	LDD #0 */
/* 02130 	STD >0 trap [NULL]s */
	/* Can't really do this portably, need to conditionally compile for architectures that don't trap NULL refs. */
#if defined TRAPS_NULLS
	* ( (natural_t * ) 0 ) = 0;
#endif
/* 02140 	RTS */
}
/* 02150 	SETDP 0 */
/* 02160 * 
*/


/*
02230 	FCC 'WARM'
02240 	FCB 4
02250 	FCB MFORE
02260 	FDB COLD-CFAOFF
02270 	FDB BIF+2
02280 	FDB VLIST-CFAOFF
02290 	FDB WARN-CFAOFF
*/
static character_t sWARM[] = "\x4WARM";
definition_header_s hWARM =	
{	{ (natural_t) sWARM },
	{ 0 },
	{ (natural_t) &hCOLD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) COLD }
};
void WARM(void)
{
//HEADER( WARM, 0 /* no special modes. */, COLD, BIF, WARM, 0 );
/* 02300 WARM	LEAY <DOREGS,PCR */
/* 02310 	EXG PC,Y call */
	DOREGS();
/* 02320 	SETDP VDP */
/* 02360 	LDD 2,Y */
/* 02370 	STD US0,X */
	UP.task->dataStackBase = W.bootConstantsp->initialParameterStackBase;
/* 02380 	STD UCSP,X */
	UP.task->compilerStackMarker = W.bootConstantsp->initialParameterStackBase;
/* 02390 	LDD 4,Y */
/* 02400 	STD UR0,X */
	UP.task->returnStackBase = W.bootConstantsp->initialReturnStackBase;
/* 02410 	LDD -2,Y */
/* 02420 	STD UBS,X */
	UP.task->backSpaceConstant = W.bootConstantsp->terminalBackSpace;
/* 02430 	LDD 6,Y */
/* 02440 	STD UTIB,X */
	UP.task->terminalInputBuffer = W.bootConstantsp->initialTerminalInputBuffer;
/* 02450 	LDD $0A,Y */
/* 02460 	STD UWARN,X */
	UP.task->diskOnLine = W.bootConstantsp->initialDiskOnLine;
/* 02470 	LEAY $10,Y */
/* 02480 	LDD 2,Y */
/* 02490 	STD UPAD,X */
/* 02500 	STD UHLD,X */
	UP.task->numericConversionScratchPad = UP.task->padMarker = W.bootConstantsp->initialNumericConversionScratchPad;
/* 02510 	LDD 4,Y */
/* 02520 	STD UWP,X */
	UP.task->wordBufferPointer = W.bootConstantsp->initialWordBufferPointer;
/* 02530 	LDD 6,Y */
/* 02540 	STD UCOLUM,X */
	UP.task->terminalColumns = W.bootConstantsp->initialTerminalColumns;
/* 02550 	LDD 8,Y */
/* 02560 	STD UFIRST,X */
/* 02570 	STD UUSE,X */
/* 02580 	STD UPREV,X */
	UP.task->firstByteOfBuffers = UP.task->leastRecentBuffer = UP.task->mostRecentBuffer = W.bootConstantsp->initialDiskBuffers;
/* 02590 	LDD $0A,Y */
/* 02600 	STD ULIMIT,X */
	UP.task->limitOfBufferRAM = W.bootConstantsp->initialLimitOfBufferRAM;
/* 02610 	LDD #16 */
/* 02620 	STD UBASE,X */
	UP.task->numericBase.integer = 16;
/* 02630 	LDD #0 */
/* 02640 	STD [UR0,X] hole */
	( * UP.task->returnStackBase.cellp ).integer = 0;
/* 02650 	STD [US0,X] hole */
	( * UP.task->dataStackBase.cellp ).integer = 0;
	{
/* 02660 	LDA #(UEND-UIN) */
		natural_t count = UEND - UIN;
/* 02670 	LEAY UIN,X */
		byte_t * ptr = (byte_t *) ( UP.task + UIN );
/* 02680 WARMLY	STB ,Y+ */ /* was safe because I knew it was non-zero. */
/* 02690 	DECA */
		while ( --count >= 0 )
		{	* ptr++ = 0;	/* Clear out the rest. Bytewise is not as fast, fix it later. */
/* 02700 	BNE WARMLY */
		}
	}
/* 02740 	PULS CC */	/* Not messing with interrupts. */
/* 02745 	ANDCC #$EF enable IRQ (disc) */
	/* And this is another place I end up stuck. empty-buffers, yes. 
	// ABORT Could be a security hole to (C subroutine) call from here. 
	*/
/* 02750 	DOCOL */
/* 02760 	FDB EMTBUF */	/* bif4/a was assembly language in my 6809 version */
/* 02770 	FDB ABORT */	/* bif7b/a --> many, of course */
}
/* 02780 	SETDP 0 */
/* 02890 * */
