//
//	base.js
//
//		1. This source code is MIT licence.
//		2. Copyright(C) All rights 2012 blueskis
//		3. If you find bugs that I have to fix , Please send mail blueskis382 @ gmail.com
//
//		1. このソースコードはMIT licenceとして配布します。
//		3. もしバグを見つけたら、 blueskis382 @ gmail.com にメールを送っていただけたらうれしいです。
//

var Invariant = new Array() ;	//定数
Invariant["APP_NAME"] = "BIEditor" ;
Invariant["APP_VERSION"] = "0.31" ;
Invariant["EditorHeightMines"] = 20 ;

Invariant["UnSupportedEncodeErrorMessage"] = "このWebブラウザでサポートされていないエンコードの指定です" ;
Invariant["UnSupportedFileReadingMessage"] = "このWebブラウザではファイルの読み込みができません" 
Invariant["UnSupportedCopyToClipBoardMessage"] = "このWebブラウザではコピーが出来ません。" ;
Invariant["ErrorMessage"] = "エラー :\n"
Invariant["UserScriptErrorWhenStart"] = "起動時スクリプトエラー :\n"
//タイトル関連
Invariant["File_Open"] = "ファイルを開く" ;
Invariant["Search"] = "検索" ;
Invariant["Replace"] = "置換" ;
Invariant["SettingEnvironment"] = "環境設定" ;
Invariant["Close_Message"] = "保存していないデータは失われますが、よろしいですか?" ;

var util = {	//ユーティリティ関数
	SupportedChecker : function(){	//サポートされているかのチェック
		var str = "" ;
		if(!window.File) str += "・ファイルを開く/保存する機能、画像を表示する機能\n" ;
		if(!str == "") alert("このWebブラウザでは以下の機能が利用できません。\n" + str) ;
	} ,
	TransmissionMIMETypeForCodeMirror : function(filePath){ 	//拡張子からCodeMirror用のMIME Typeに設定
		var querys = [
			[".bash" , "text/x-sh"] ,
			[".bat" , "text/plain"] ,
			[".c" , "text/x-csrc"] ,
			[".cfg" , "text/plain"] ,
			[".clj" , "text/x-clojure"] ,
			[".coffee" , "text/x-coffeescript"] ,
			[".conf" , "text/plain"] ,
			[".cpp" , "text/x-c++src"] ,
			[".cshape" , "text/x-csharp"] ,
			[".css" , "text/css"] ,
			[".csv" , "text/plain"] ,
			[".diff" , "text/x-diff"] ,
			[".docx" , "text/xml"] ,
			[".ks" , "text/plain"] , //KAG3(ノベルゲームスクリプトエンジン)
			[".go" , "text/x-go"] ,
			[".h" , "text/x-csrc"] ,
			[".hta" , "text/html"] ,
			[".htaccess" , "text/plain"] ,
			[".hs" , "text/x-haskell"] ,
			[".htm" , "text/html"] ,
			[".html" , "text/html"] ,
			[".hs" , "text/x-haskell"] ,
			[".hx" , "text/x-haxe"] ,
			[".ini" , "text/x-ini"] ,
			[".java" ,  "text/x-java"] ,
			[".js" , "text/javascript"] ,
			[".jse" , "text/javascript"] ,
			[".json" , "application/json"] ,
			[".l" , "text/x-ecl"] ,
			[".latex" , "text/x-stex"] ,
			[".less" , "text/x-less"] ,
			[".lisp" , "text/x-ecl"] ,
			[".log" , "text/plain"] ,
			[".lua" , "text/x-lua"] ,
			[".mac" , "text/plain"] , //秀丸エディタマクロ
			[".mark" , "text/markdown"] ,
			[".markdown" , "text/markdown"] ,
			[".md" , "text/x-markdown"] ,
			[".mdown" , "text/markdown"] ,
			[".mkd" , "text/markdown"] ,
			[".mkdn" , "text/markdown"] ,
			[".mo" , "text/plain"] ,
			[".ps1" , "text/plain"] ,
			[".ps1xml" , "application/xml"] ,
			[".psc1" , "text/plain"] ,
			[".psd1" , "text/plain"] ,
			[".psm1" , "text/plain"] ,
			[".py" , "text/x-python"] ,
			[".php" , "application/x-httpd-php"] ,
			[".pl" , "text/x-perl"] ,
			[".r" , "text/x-rsrc"] ,
			[".rb" , "text/x-ruby"] ,
			[".rs" , "text/x-rustsrc"] ,
			[".rss" , "application/xml"] ,
			[".s" , "text/x-rsrc"] ,
			[".scm" , "text/x-scheme"] ,
			[".scp" , "text/plain"] ,
			[".sct" , "text/plain"] ,
			[".sh" , "text/x-sh"] ,
			[".shtml" , "text/html"] ,
			[".sql" , "text/x-mysql"] ,
			[".sql" , "text/x-mysql"] ,
			[".svg" , "application/xml"] ,
			[".svn-base" , "text/plain"] ,
			[".sys" , "text/plain"] ,
			[".st" , "text/x-stsrc"] ,
			[".srx" , "application/x-sparql-query"] ,
			[".tex" , "text/x-stex"] ,
			[".txt" , "text/plain"] ,
			[".tpl" , "text/x-smarty"] ,
			[".v" , "text/x-verilog"] ,
			[".vb" , "text/vb"] ,
			[".vbe" , "text/vbscript"] ,
			[".vbs" , "text/vbscript"] ,
			[".vm" , "text/velocity"] ,
			[".wsc" , "text/plain"] ,
			[".wsf" , "text/plain"] ,
			[".wtx" , "text/plain"] ,
			[".xaml" , "application/xml"] ,
			[".xbap" , "text/plain"] ,
			[".xml" , "application/xml"] ,
			[".xquery" , "application/xquery"] ,
			[".xul" , "application/xml"]
		] ;
		for(var i=0;i<querys.length;i++){
			if(filePath.substring(
				filePath.length - querys[i][0].length  ,
				filePath.length 
			) == querys[i][0])
				return querys[i][1] ;
		}
		return "text/plain" ;
	} ,
	getFileFullPath : function(element){	//ファイルのフルパスを取得(※Chromeでは<input type="file">のvalueがC:\fakepath\みたいになるから
		if(window.File){
			return element.files[0].name
		}else{
			return element.value ; //For IE
		}
	} ,
	File : function(elem , encode){	//クロスブラウザ対応ファイルオブジェクト

		//IEのFileSystemObjectって、UTF-16かShift-JISしか対応していない
		if(window.ActiveXObject && encode != "utf-16" && encode != "shift-jis"){
			alert(Invariant["UnSupportedEncodeErrorMessage"]) ;
		}
		
		this.elem = elem ;
		this.encode = encode ;	
		this.getFileName = function(){	//ファイル名を取得
			var fileURL ;
			if(BrowsingMode.SupportedFileAPI){
				fileURL = this.elem.files[0].name ;
			}else{
				fileURL = this.elem.value ;
			}
			return url.match(/.*\/(.*)$/)[1] ;			
		}
		
		this.read = function(loadedFunc){	//ファイル読み込み	(loadedFunc : ファイル読み込み後に実行する関数)
			if(window.File){	//File API (Firefox , Google Chrome , IE10)
				var reader = new FileReader() ;
				reader.onload = function(event){
					loadedFunc(event.target.result) ;
				} ;
				reader.readAsText(this.elem.files[0] , this.encode) ;

			}else if(window.ActiveXObject){	//IE系
				try{
					var isUnicode = true ;
					if(this.encode == "shift-jis") isUnicode = false ;
					
					var stream = new ActiveXObject("FileSystemObject").OpenTextFile(this.elem.value , 2 , isUnicode) ;
					loadedFunc(stream.ReadAll()) ;
					
				}catch(e){
					alert(Invariant["ErrorMessage"] + e) ;
				}
			}else{
				alert(Invariant["UnSupportedFileReadingMessage"]) ;
			}
		}
		this.write = function(str){
			if(BrowsingMode.SupportedBlobBuilder){	//BlobBuider対応
				var blobBuilder;
				var blobURL ;
				if ("MozBlobBuilder" in window) {
					blobBuilder = new MozBlobBuilder();
					blobURL = URL ;
				} else if ("WebKitBlobBuilder" in window) {
					blobBuilder = new WebKitBlobBuilder();
					blobURL = webkitURL ;
				} else if ("BlobBuider" in window){
					blobBuilder = new window.BlobBuider() ;
					blobURL = URL ;
				}

				blobBuilder.append(str);
				var url = blobURL.createObjectURL(blobBuilder.getBlob()) ;
				
				var downloader = $("<a></a>") ;
				downloader[0].download = this.getFileName() ;
				downloader.attr("href" , url) ;
				
				downloader.click() ;
			}else if(BrowserMode.SuppotedActiveX){
				//ActiveX...
			}
		}
	} ,
	CopyToClipboard : function(text){
		var input, success;
		if ("console" in window && "notifyFirebug" in console) {
			console.notifyFirebug([text], "copy", "firebugExecuteCommand");
			success = true;
		} else {
			input = document.createElement("input");
			input.style.display = "none" ;
			input.value = text;
			document.body.appendChild(input);
			input.select();
			try {
				success = document.execCommand("copy", false, null);
			} catch (ex) {
				success = false;
			} finally {
				document.body.removeChild(input);
			}
		}
		if (!success) {
			alert(Invariant["UnSupportedCopyToClipBoardMessage"]) ;
		}
	} ,
	getFonts : function(){
		//対応していないブラウザ用(※プログラミングに適しているといわれているフォントたち)
		var default_fonts = ["Consolas" , "Courier" , "Courier New" , 
			"Andale Mono" ,"Monaco" , "Profont" ,"Monofur" ,
			"Proggy" , "Droid Sans Mono" , "Deja Vu Sans Mono" ,
			"Inconsolata" , "Ricty" , "Terminal" , "FixedSys" ,
			"M+2VM+IPAG circle" ,"VL ゴシック" , "VL Pゴシック" ,
			"KonatuTohaba" , "Osaka" , "ゆたぽん（コーディング)" ,
			"Mig 1M" , "M+ BITMAP FONTS" , "Bitstream Vera Sans Mono" ,
			"Anonymous" ,"Arial Monospaced" , "Aurulent Sans Mono" ,
			"BPMono" , "Century Schoolbook Mono BT" , "Crystal" ,
			"Dina" , "DPCustomMono2" , "Envy Code R" , "Lucida Console" ,
			"Lucida Sans Typewriter" , "Monospace 821 BT" ,
			"Nu Sans Mono" , "Onuava" , "Pragmata" , "ProFontWindows" ,
			"Proggy Clean with Slashed Zero" , "saxMono" , "Selectric" ,
			"Terminus" , "Ti92Pluspc" , "Verily Serif Mono" ,
			"Osaka 等幅" , "メイリオ" , "Arial" , "Dina" , "Lucida Sans" ,
			"MS Sans Serif" , "Menlo" ,
			"ＭＳ Ｐゴシック" , "ＭＳ　ゴシック"].sort() ;
		if(window.ActiveXObject){
			$("body").prepend('<OBJECT id="dlgHelper" CLASSID="clsid:3050f819-98b5-11cf-bb82-00aa00bdce0b" width="0px" height="0px"></OBJECT>') ;
			var fonts = [] ;
			try {
				for (var i = 1; i < dlgHelper.fonts.count; i++) {
					fonts.push(dlgHelper.fonts(i)) ;
				}
				fonts.sort() ;
				$("#dlgHelper").remove() ;
				return fonts ;
			}catch(e) { 
				return default_fonts ;
			} 
		}else
			return default_fonts ;
	} ,
	setSettingItem : function(){
		//テーマの設定
		Sys.storage.set("TextEditor.ThemeSelector" , $("#theme-selector option:selected").val()) ;
		//キーマップの設定
		Sys.storage.set("TextEditor.keyMap" , $("#keyMap option:selected").val()) ;
		//行番号の表示の有無
		Sys.storage.set("TextEditor.LineNumberShow" , $("#lineNumbers").is(":checked")) ;
		//行の表示の有無
		Sys.storage.set("TextEditor.LineVisible" , $("#line_symbol").is(":checked")) ;
		//タブの表示の有無
		Sys.storage.set("TextEditor.TabVisible" , $("#tab").is(":checked")) ;
		//下線の表示の有無
		Sys.storage.set("TextEditor.CurrentLineUnderLine" , $("#underline").is(":checked")) ;
		//EOF記号の表示の有無
		Sys.storage.set("TextEditor.EOFShow" , $("#eof_symbol").is(":checked")) ;
		//背景画像の設定
		Sys.storage.set("TextEditor.BackGroundImageSource" , $("#background_image_src").val()) ;
		//背景画像透過率の設定
		Sys.storage.set("TextEditor.BackGroundImageOpacity" , $("#background_opacity").val()) ;
		//タブサイズの設定
		Sys.storage.set("TextEditor.TabSize" , $("#TabSize").val()) ;
		//起動時スクリプト
		Sys.storage.set("TextEditor.BeginScript" , Sys.beginEditor.getValue()) ;
		//フォントファミリ
		Sys.storage.set("TextEditor.FontFamily" , $("#fonts").val()) ;
		//フォントサイズ
		Sys.storage.set("TextEditor.FontSize" , $("#fontSize").val()) ;
		//画像の幅指定
		Sys.storage.set("TextEditor.BackGroundImageStyle" , $("#background-style option:selected").val()) ;
		//エディタの背景色の指定
		Sys.storage.set("TextEditor.ThemeBackGroundApply" , $("#editor_background").is(":checked")) ;
		//初期化
		var value = Sys.commonEditor.getValue() ;
		var currentmode = Sys.commonEditor.getOption("mode") ;
		$(".CodeMirror").remove() ;
		Sys.init() ;
		Sys.commonEditor.setValue(value) ;
		Sys.commonEditor.setOption("mode" , currentmode) ;
		
		
		Sys.onSettingEnd() ;
	} ,
	setBackGroundImageSize : function(mode , width , height){
		$(".CodeMirror-scroll").css("height" , height)
		var left = $(".CodeMirror-gutter").width() ;
		if(Sys.storage.get("TextEditor.LineNumberShow") == "false") left = 0 ;
		switch(mode){
				case "fit_width_height" :
					$("#background_image")
						.css("text-align" , "left")
						.css("width" , width) 
						.css("height" , height)
						.css("left" , left) ;
					break ;
				case "fit_width" :
					$("#background_image")
						.css("text-align" , "left")
						.css("width" , width)
						.css("height" , "auto")
						.css("left" , left) ;
						break ;
				case "fit_height" :
					$("#background_image")
						.css("text-align" , "left")
						.css("width" , "auto")
						.css("height" , height) 
						.css("left" , left) ;
						break ;
				case "right_top" :
					$("#background_image")
						.css("text-align" , "left")
						.css("width" , "auto")
						.css("height" , "auto") 
						.css("left" , left) ;
						break ;
				case "right_center" : 
					$("#background_image")
						.css("text-align" , "center")
						.css("width" , "auto")
						.css("height" , "auto")
						.css("left" , left) ;
						break ;
			}	
	}
}
var Exception = {	//例外用オブジェクト
	File : {	//ファイル系エラー
		UnavaiableFileEncodingException : function(){	//ファイルのエンコードが利用不可
			this.message = Invariant["UnSupportedEncodeErrorMessage"] ;
			this.className = "UnavaiableFileEncodingException" ;
		} ,
		UnSupportedFileReading : function(){	//ファイル読み込みがサポートされていない
			this.message = Invariant["UnSupportedFileReadingMessage"] ;
			this.className = "UnSupportedFileReading" ;
		}
	}
}
var ui = {
	Window : function(str){	//JavaのJFrameっぽいかんじで作ってみた
		this.mainElement = $("<div id=\"temp_" + new Date().getTime() + "\"><div class=\"wrapper\"></div></div>") ;
		this.mainElement.dialog({
			title : str ,
			autoOpen : false ,
			draggable : true ,
			resizable : true ,
			modal : false
		}) ;
		this.remove = function(){
			this.mainElement.dialog("destroy") ;
		}
		this.setWidth = function(width){
			this.mainElement.dialog("option" , "width" , width) ;
		}
		this.setContent = function(s){
			this.mainElement.children(".wrapper").html(s)
		}
		this.setVisible = function(isvisible){
			if(isvisible) this.mainElement.dialog("open")
			else this.mainElement.dialog("close") ;
		}
		this.setHeight = function(height){
			this.mainElement.dialog("option" , "height" , height) ;
		}
		this.setButton = function(obj){
			this.mainElement.dialog("option" , "buttons" , obj) ;
		}
		this.setModal = function(ismodal){
			if(ismodal) this.mainElement.dialog("option" , "modal" , ismodal)
			else this.mainElement.dialog("option" , "modal" , ismodal) ;
		}
		this.setTitle = function(str){
			this.mainElement.dialog("option" , "title" , str) ;
		}
		this.setResizable = function(isresizable){
			this.mainElement.dialog("option" , isresizable) ;
		}
		this.setLocation = function(x , y){
			this.mainElement.dialog("position" , [x , y]) ;
		}
		this.setPosition = function(x , y){
			this.mainElement.dialog("position" , [x , y]) ;
		}
		this.addEventListener = function(str , func){
			this.mainElement.bind(str , func) ;
		}
		this.getTitle = function(str){
			return this.mainElement.dialog("option" , "title") ;
		}
		this.getWidth = function(){
			return this.mainElement.dialog("option" , "width") ;
		}
		this.getHeight = function(){
			return this.mainElement.dialog("option" , "height") ;
		}	
		this.isModal = function(){
			return this.mainElement.dialog("option" , "modal") ;
		}
		this.isResizable = function(){
			return this.mainElement.dialog("option" , "resizable") ;
		}
		this.getWindowElement = function(){
			return this.mainElement ;
		}
	}
}
var BrowsingMode = {
	InternetExplorer7 : navigator.userAgent.match(/MSIE 7/) ? true : false ,
	InternetExplorer8 : navigator.userAgent.match(/MSIE 8/) ? true : false ,
	InternetExplorer9 : navigator.userAgent.match(/MSIE 9/) ? true : false ,
	InternetExplorer10 : navigator.userAgent.match(/MSIE 10/) ? true : false ,

	Firefox : navigator.userAgent.match(/Firefox/) ? true : false ,
	SeaMonkey : navigator.userAgent.match(/SeaMonkey/) ? true : false ,

	Opera : window.opera ? true : false ,
	OperaExtension : window.opera && window.opera.extension ? true : false ,

	Chrome : window.chrome ? true : false ,
	ChromeExtension : window.chrome && window.chrome.extension ? true : false ,

	Safari : window.safari ? true : false ,
	
	SupportedBlobBuilder : window.MozBlobBuilder || window.WebKitBlobBuilder || window.BlobBuilder ? true : false ,
	SupportedFileAPI : window.opera || navigator.userAgent.match(/[Firefox|SeaMonkey]/) || window.chrome ? true : false ,
	SuppotedActiveX : navigator.userAgent.match(/MSIE [7-9]/) ? true : false,
	
	UnSupportedBrowser : navigator.userAgent.match(/MSIE 6/) ? true : false
}
var Sys = {									//テキストエディタのシステムに関わる関数
	initSettingItem : function(){			//設定項目の初期化
		if(Sys.storage.get("TextEditor.ThemeSelector")){
			$("#theme-selector").val(Sys.storage.get("TextEditor.ThemeSelector")) ;
			$("#keyMap").val(Sys.storage.get("TextEditor.keyMap")) ;
			$("#background_image_src").val(Sys.storage.get("TextEditor.BackGroundImageSource")) ;
			$("#background_opacity").val(Sys.storage.get("TextEditor.BackGroundImageOpacity")) ;
			$("#TabSize").val(Sys.storage.get("TextEditor.TabSize")) ;
			$("#fonts").val( Sys.storage.get("TextEditor.FontFamily")) 	;
			$("#fontSize").val( Sys.storage.get("TextEditor.FontSize")) ;
			$("#background-style").val( Sys.storage.get("TextEditor.BackGroundImageStyle")) ;
			
			if(Sys.storage.get("TextEditor.LineNumberShow") === "false") $("#lineNumbers")[0].checked = false ;
			if(Sys.storage.get("TextEditor.LineVisible") === "false") $("#line_symbol")[0].checked = false ;
			if(Sys.storage.get("TextEditor.TabShow") === "false") $("#tab")[0].checked = false ;
			if(Sys.storage.get("TextEditor.CurrentLineUnderLine") === "false") $("#underline")[0].checked = false ;
			if(Sys.storage.get("TextEditor.EOFShow") == "false") $("#eof_symbol")[0].checked = false ;
			
			$("#background_image").attr("src" , Sys.storage.get("TextEditor.BackGroundImageSource")) 
								.css("opacity" , Sys.storage.get("TextEditor.BackGroundImageOpacity")) ;
		}
		Sys.outputStorageData() ;
	} ,
	outputStorageData : function(){			//設定項目のストレージデータの読み込み
		var str = "" ;
		var import_text = "{" ;
		var cnt = 0 ;
		for(var s in Sys.storage.getAll()){
			if(cnt != 0) import_text += "," ;
			if(s.indexOf("TextEditor") != -1){
				str +=  "<tr><td>" + s + "</td><td><input type=\"text\" value=\"" + Sys.storage.get(s) + "\"></td></tr>" ;
				import_text += "\n\t\"" + s + "\" : \"" + Sys.storage.get(s).replace(/\t/g).replace(/\\t/g).replace(/\n/g , "\\n").replace(/\"/g , "\\\"") + "\"" 
			}
			cnt++ ;
		}
		$("#storage_result").html(str) ;
		$("#import_text").val(import_text + "\n}") ;
	} ,
	initCommonEditor : function(){			//メインのエディタの初期化
		var hlLine = null　, hlLine2 = null ;
		Sys.commonEditor = CodeMirror.fromTextArea(document.getElementById("editor"), {
			lineNumbers: (Sys.storage.get("TextEditor.LineNumberShow") == "false" ? false : true) ,
			tabSize: (Sys.storage.get("TextEditor.TabSize") ? Sys.storage.get("TextEditor.TabSize") : 4) ,
			indentUnit: 4,
			indentWithTabs: true ,
			theme : (Sys.storage.get("TextEditor.ThemeSelector") ? Sys.storage.get("TextEditor.ThemeSelector") : "eclipse") ,
			onCursorActivity: function() {
				Sys.commonEditor.setLineClass(hlLine, null, null);
				hlLine = Sys.commonEditor.setLineClass(Sys.commonEditor.getCursor().line, null, "activeline");
			} ,
			onGutterClick: function(cm, n) {
				var info = cm.lineInfo(n);
				if (info.markerText)
					cm.clearMarker(n);
				else
					cm.setMarker(n, "<span style=\"color: #900\">●</span> %N%");
			} ,
			mode: "text/plain" ,
			profile : "html" ,
			keyMap : (Sys.storage.get("TextEditor.KeyMap") ? Sys.storage.get("TextEditor.KeyMap") : "default")
		});
		Sys.commonEditor.setValue("") ;


		hlLine = Sys.commonEditor.setLineClass(0, "activeline");
		
		Sys.beginEditor = CodeMirror.fromTextArea(document.getElementById("stating-js-code"), {
			lineNumbers: (Sys.storage.get("TextEditor.LineNumberShow") == "false" ? false : true) ,
			tabSize: (Sys.storage.get("TextEditor.TabSize") ? Sys.storage.get("TextEditor.TabSize") : 4) ,
			indentUnit: 4,
			indentWithTabs: true ,
			theme : (Sys.storage.get("TextEditor.ThemeSelector") ? Sys.storage.get("TextEditor.ThemeSelector") : "eclipse") ,
			onCursorActivity: function() {
				Sys.commonEditor.setLineClass(hlLine2, null, null);
				hlLine2 = Sys.commonEditor.setLineClass(Sys.commonEditor.getCursor().line, null, "activeline");
			} ,
			onGutterClick: function(cm, n) {
				var info = cm.lineInfo(n);
				if (info.markerText)
					cm.clearMarker(n);
				else
					cm.setMarker(n, "<span style=\"color: #900\">●</span> %N%");
			} ,
			mode: "text/javascript" ,
			keyMap : (Sys.storage.get("TextEditor.KeyMap") ? Sys.storage.get("TextEditor.KeyMap") : "default")
		});
		hlLine2 = Sys.beginEditor.setLineClass(0 , "activeline") ;
		$(".CodeMirror")
							.css("font-family" , Sys.storage.get("TextEditor.FontFamily") ? Sys.storage.get("TextEditor.FontFamily") : "Courier") 
							.css("font-size" , Sys.storage.get("TextEditor.FontSize") ? Sys.storage.get("TextEditor.FontSize") + "px" : "11px") 
							.addClass("TabVisible")
							.addClass("LineVisible")
							.addClass("CurrentLineUnderLine") 
							.addClass("EOFShow")
		
		if(Sys.storage.get("TextEditor.ThemeBackGroundApply") == "true") $(".CodeMirror-scroll").css("background-color" , "transparent") ;
		if(Sys.storage.get("TextEditor.TabShow") == "false") $(".CodeMirror").removeClass("TabVisible") ;
		if(Sys.storage.get("TextEditor.LineVisible") == "false") $(".CodeMirror").removeClass("LineVisible") ;
		if(Sys.storage.get("TextEditor.CurrentLineUnderLine") == "false") $(".CodeMirror").removeClass("CurrentLineUnderLine") ;
		if(Sys.storage.get("TextEditor.EOFShow") == "false") $(".CodeMirror").removeClass("EOFShow") ;
	} ,
	initClickedWork : function(){			//クリックされた時の動作の初期化
			$('[data-create="Open"]').click(function(){
				Sys.commonEditor.setValue("") ;
				Sys.currentFile = null ;
			}) ;
			$('[data-action="Open"]').click(function(){
				$("#Open").dialog("open") ;
			}) ;
			$('[data-action="ReOpen"]').click(function(){
				var file = new File(currentFile) ;
				file.read(function(s){
					Sys.commonEditor.setValue(s) ;
				}) ;
			}) ;
			$('[data-action="About"]').click(function(){
				$("#About").dialog("open") ;
			}) ;
			$('[data-action="Save"]').click(function(){
				Sys.onFileSave() ;
				var file = new util.File() ;
				file.write(Sys.commonEditor.getValue()) ;

			}) ;
			$('[data-action="SaveAs"]').click(function(){
			}) ;
			$('[data-action="Print"]').click(function(){
				window.scroll(0 , 0) ;
				window.print() ;
				
			}) ;
			$('[data-action="Exit"]').click(function(){
				window.close() ;
			}) ;
			$('[data-action="Undo"]').click(Sys.commonEditor.undo)
			$('[data-action="Redo"]').click(Sys.commonEditor.redo)
			$('[data-action="Copy"]').click(function(){
				util.CopyToClipboard(editor.getSelection) ;
			}) ;
			$('[data-action="Paste"]').click(function(){
				document.execCommand("paste") ;
			}) ;
			$('[data-action="Delete"]').click(function(){
				document.execCommand("delete") ;
			}) ;
			$('[data-action="SelectAll"]').click(function(){
				document.execCommand("selectAll") ;
			}) ;
			$('[data-action="SettingEnvironment"]').click(function(){
				$("#SettingEnvironment").dialog("open") ;
			}) ;
			$('[data-action="Search"]').click(function(){
				$("#searchbox").dialog("open") ;
			}) ;
			$('[data-action="Replace"]').click(function(){
				$("#replacebox").dialog("open") ;
			}) ;
			$('[data-action="reload_Sys.storage_data"]').click(function(){
				Sys.outputStorageData() ;
			}) ;
			$('[data-action="NewDocument"]').click(function(){
				document.title = Invariant["APP_NAME"] ;
				Sys.commonEditor.setValue("") ;
			}) ;
			$('[data-action="New_Tab"]').click(function(){
				window.open(location.href) ;
			}) ;
			$('[data-action="SourceForge"]').click(function(){
				window.open("http://sourceforge.jp/projects/bieditor/simple/") ;
			}) ;
			$('[data-action="Export"]').click(function(){
				if(window.JSON){
					try{
						var obj = JSON.parse($("#export_text").val()) ;
					}catch(e){
						alert(Invariant["ErrorMessage"] + e) ;
					}
				}else{
					try{
						var obj = eval($("#export_text").val()) ;
					}catch(e){
						alert(Invariant["ErrorMessage"] + e) ;
					}
				}
				for(var n in obj){
					eval("Sys.storage.set(\"" + n + "\" , \"" + obj[n].replace(/\t/g).replace(/\\t/g).replace(/\n/g , "\\n").replace(/\"/g , "\\\"")  + "\")") ;
				}
				Sys.init() ;
				$("#SettingEnvironment").dialog("close") ;
				
			}) ;
		} ,
	initDialog : function(){					//ダイアログボックスの初期化
		$("#Open").dialog({
			modal : true ,
			draggable : true ,
			title : Invariant["File_Open"] ,
			height : 240 ,
			width : 320 ,
			autoOpen : false ,
			buttons : {
				"OK" : function(event){
					Sys.onFileOpen() ;
					var file = new util.File( document.getElementById("Open-file-chooser") , $("#Open-file-encode option:selected").val()) ;
					try{
						file.read(function(str){
							var mime = util.TransmissionMIMETypeForCodeMirror($("#Open-file-chooser")[0].value) ;
							Sys.commonEditor.setOption("mode" , mime) ;
							Sys.commonEditor.setValue(str) ;
							document.title = Invariant["APP_NAME"] + " -" + $("#Open-file-chooser")[0].value ;
							Sys.setWindowTitle(util.getFileFullPath($("#Open-file-chooser")[0]))
						}) ;
					}catch(e){
						alert(Invariant["ErrorMessage"] + e) ;
					}
					$("#Open").dialog("close") ;
				} ,
				"キャンセル" : function(event){
					$("#Open").dialog("close") ;
				}
			}
		}) ;
		$("#searchbox").dialog({
			modal : false ,
			draggable : true ,
			title : Invariant["Search"] ,
			height : 200 ,
			width : 300 ,
			autoOpen : false ,
			buttons : {
				"検索" : function(){
					CodeMirror.commands.find($("#search_query").val() , Sys.commonEditor) ;
				} ,
				"閉じる" : function(){
					$("#searchbox").dialog("close") ;
				}
			}
		}) ;
		$("#replacebox").dialog({
			modal : false ,
			draggable : true ,
			width : 530 ,
			height : 190 ,
			title : Invariant["Replace"] ,
			autoOpen : false ,
			buttons : {
				"検索" : function(){
					CodeMirror.commands.find($("#search_query_for_replace").val() , Sys.commonEditor) ;
				} ,
				"すべて置換" : function(){
					CodeMirror.commands.replace(Sys.commonEditor , true) ;
				}
			}
		}) ;
		
		var s = "" ;
		var fonts = util.getFonts() ;
		$("#fonts").html("") ;
		for(var i = 0 ; i < fonts.length;i++)
			s += "<option value=\"" + fonts[i] + "\" style=\"font-family:'" + fonts[i] + "'\">" + fonts[i] + "</option>\n" ;
		$("#fonts").append(s) ;
		$("#fonts").val( Sys.storage.get("TextEditor.FontFamily")) 	;
		$("#SettingEnvironment").dialog({
			modal : true ,
			draggable : true ,
			title : Invariant["SettingEnvironment"] ,
			height : 400 ,
			width : 500 ,
			autoOpen : false ,
			buttons : {
				"OK" : function(){
					util.setSettingItem() ;
					$("#SettingEnvironment").dialog("close") ;
				} ,
				"適用" : function(){
					util.setSettingItem() ;
				} ,
				"キャンセル" : function(){
					$("#SettingEnvironment").dialog("close") ;
				}
			}
		}) ;
		$("#FontTesterResult")
				.css("font-family" , $("#fonts option:selected").val())
				.css("font-size" , $("#fontSize").val() + "px") ;
		$("#fonts , #fontSize").change(function(){
			$("#FontTesterResult")
				.css("font-family" , $("#fonts option:selected").val())
				.css("font-size" , $("#fontSize").val() + "px") ;
		}) ;
		$("#About").dialog({
			modal : false ,
			draggable : true ,
			title : Invariant["APP_NAME"]  ,
			height : 400 ,
			width : 320 ,
			buttons : {
				"OK" : function(e){
					$("#About").dialog("close") ;
				}
			} ,
			autoOpen : false
		}) ;
		$("#setenv-tabs").tabs() ;
	} ,
	init : function(){							//全体の初期化
		
		
		Sys.outputStorageData() ;
		Sys.initCommonEditor() ;
		Sys.initClickedWork() ;
		Sys.initSettingItem() ;
		Sys.initDialog() ;
		var imgStyle = (Sys.storage.get("TextEditor.BackGroundImageStyle") ? Sys.storage.get("TextEditor.BackGroundImageStyle") : "fit_width_height") ;
		if(window.ActiveXObject){
			util.setBackGroundImageSize(imgStyle , document.documentElement.clientWidth + "px", (document.documentElement.clientHeight - Invariant["EditorHeightMines"] ) + "px") ;
		}else{
			util.setBackGroundImageSize(imgStyle , window.innerWidth + "px" , (window.innerHeight- Invariant["EditorHeightMines"] ) + "px" );
		}
		$(window).resize(function(){
			if(window.ActiveXObject){
				util.setBackGroundImageSize(imgStyle , document.documentElement.clientWidth + "px", (document.documentElement.clientHeight - Invariant["EditorHeightMines"] )+ "px" );
			}else{
				util.setBackGroundImageSize(imgStyle , window.innerWidth + "px" , (window.innerHeight - Invariant["EditorHeightMines"] )+ "px") ;
			}
		}) ;
		Sys.commonEditor.setValue("\n") ;	//行番号の幅がおかしいからこうしてやる。
		

		
		Sys.beginEditor.setValue(
			(Sys.storage.get("TextEditor.BeginScript") ? Sys.storage.get("TextEditor.BeginScript") : "//起動時に実行されるスクリプト(JavaScript)を書いてください\n")
		) ;
		
		Sys.onInitLoaded() ;

	} ,
	setWindowTitle : function(filePath){		//ウィンドウタイトルの設定
		document.title = Invariant["APP_NAME"] + " -" + filePath ;
	} ,
	commonEditor : null ,						//メインエディタのCodeMirrorオブジェクト
	storage : null　,							//ストレージデータ
	beginEditor : null ,						//開始時実行のスクリプトのエディタ
	currentFile : null ,						//現在開いているファイル
	addEventListener : function(name , func){	//イベントリスナの追加
		var events = [
			["mainloaded" , "onMainLoaded"] ,
			["fileopen" , "onFileOpen"] ,
			["filesave" , "onFileSave"] ,
			["windowclose" , "onWindowClose"] ,
			["settingend" , "onSettingEnd"] ,
			["exit" , "onExit"] ,
			["keyevent" , "onkeyEvent"] ,
			["initloaded" , "onInitLoaded"]
		]
		name = name.toLowerCase() ;
		for(var i=0;i<events.length;i++){
			if(name == events[i][0]){
				var frontfunc = eval("Sys." + events[i][1]) ;
				eval("Sys." + events[i][1] + "= function(){frontfunc();func();} " ) ;
			}
		}
	} ,
	onMainLoaded : function(){} ,
	onFileOpen : function(){} ,
	onFileSave : function(){} ,
	onWindowClose : function(){} ,
	onSettingEnd : function(){} ,
	onExit : function(){} ,
	onkeyEvent : function(){} ,
	onInitLoaded : function(){}
}

window.xstorage = function(uu , storage){	//ストレージ利用可能後(window.onloadより後)
	Sys.storage = storage ;
	if(Sys.storage.get("TextEditor.BeginScript")){
		try{
			eval(Sys.storage.get("TextEditor.BeginScript")) ;
		}catch(e){
			alert(Invariant["UserScriptErrorWhenStart"] + e) ;
		}
	}
	Sys.init(storage) ;	
	Sys.onMainLoaded() ;
}

$(function(){	
	document.title = Invariant["APP_NAME"] + " -無題" ;

	//jQueryで実装するメニューバー
	$("ul.sub").hide();
	$("ul.menubar li").hover(
		function(){
			$(">ul:not(:animated)",this).show() ;
		},
		function(){
			$(">ul",this).hide();
		}
	)
	//IE7とか8はvimスタイルに対応していない。
	if(!navigator.userAgent.match(/MSIE [7-8]/)){
		$("head").append('<script type="text/javascript" src="js/codemirror-util.vim.js"></scr' + 'ipt>')
		$("#keyMap").append('<option value="vim">vim</option>') ;
	}
	$(window).bind('beforeunload', function(){
		return Invariant["Close_Message"] ;
	}) ;

}) ;

