<%@ page pageEncoding="UTF-8" contentType="text/html;charset=UTF-8" import="java.util.*, java.sql.*, bibliophilia.*, javax.naming.*, javax.sql.*" %>
<%!
public String join(String[] src){
    StringBuilder sb = new StringBuilder(src[0]);
    for(int i = 1; i<src.length; i++){
        sb.append(",");
        sb.append(src[i]);
    }
    return sb.toString();
}
%>
<html>
<head>
<!-- 複数冊ある場合はユーザに選ばせる -->
<jsp:include page="../htitle.jsp" />
<style type="text/css">
TH {
    background-color: #DDFFDD
}
</style>
<link rel="stylesheet" href="../style/common.css" TYPE="text/css">
<script language="Javascript">
function rent(){
    if(0 == document.getElementsByName("user_id")[0].selectedIndex){
        alert("ユーザを指定してください。");
    }else {
        document.rent_form.submit();
    }
}

</script>
</head>
<BODY>
<jsp:include page="../title.jsp" />
<TABLE>
<jsp:include page="../menu.jsp"/>
<TD valign="TOP">
<H2>以下の書籍で宜しいですか？</H2>
同じ本が複数冊表示されている場合は、ラジオボタンで選んでください。
<form name="rent_form" method="POST" action="rent_register.jsp">
<table width="100%" cellspacing=0 border=1>
<%
    String isbn_list = request.getParameter("isbn_list");
    String[] isbn_str = isbn_list.split("[\n\r]");
    Vector<String> tmp = new Vector<String>();
    for(int i = 0; i<isbn_str.length; i++){
        if(isbn_str[i] != null && isbn_str[i].trim().length() > 0){
            tmp.add(isbn_str[i].trim());
        }
    }
    String[] isbns = tmp.toArray(new String[tmp.size()]);
    boolean error = false;
    String message = "";
    Connection con = null;
    Vector<String> v = new Vector<String>();
    HashMap<String, Integer> userMap = new HashMap<String, Integer>();
    int found = 0;
    try {
        InitialContext ic = new InitialContext();
        DataSource ds = (DataSource)ic.lookup("java:comp/env/jdbc/bibliophilia");
        con = ds.getConnection();
        String sql = "select book_id, isbn, title, reg_date, manufacturer, user_info.name, books.user_id "
                + " from books left join user_info on books.user_id=user_info.user_id where isbn=? order by books.user_id desc";
        PreparedStatement stmt = 
           con.prepareStatement(sql);
        PreparedStatement stmt_count = con.prepareStatement("select count(book_id) from books where isbn=?");
        PreparedStatement user_stmt = con.prepareStatement("select user_id, name from user_info");
        ResultSet rs = user_stmt.executeQuery();
        while(rs.next()){
            userMap.put(rs.getString(2), rs.getInt(1));
        }
        rs.close();
        user_stmt.close();
        for(int i = 0; i<isbns.length; i++){
            String isbn = isbns[i];
            if(isbn.length() == 13){
                isbn = IsbnUtil.toOldSystem(isbn);
            }else if(isbn.length() == 0){
                continue;
            }
            // 書籍情報の取得 for 画像
            BookInfo book = BookInfo.getInfoByISBN(isbn.trim());
            if(null == book.getISBN() ||  book.getISBN().equals("")){
                book = null;
            }
            // 書籍情報の取得 for 貸出
            stmt_count.setString(1, isbn);
            rs = stmt_count.executeQuery();
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            if(count == 0){
                out.println("<TR bgcolor='#FFDDDD'><TD>" + (i+1) 
                    + "<TD colspan='5'>ISBN=" + isbn + "に該当する書籍がありませんでした。");
                out.println("この書籍は未登録かバーコードの読み取りに失敗した可能性があります。");
                continue;
            }else {
                out.println("<TR><TD rowspan='" + count + "'>" + (i + 1));
                v.add(isbn);
            }
            stmt.setString(1, isbn);
            rs = stmt.executeQuery();
            int line = 0;
            String[] imageURL = book.getImage();
            while(count != 0 && rs.next()){
                found++;
                if(line != 0){
                    out.println("<TR>");
                }
                int bookid = rs.getInt(1);
                String title = rs.getString(3);
                String date = rs.getString(4);
                String publisher = rs.getString(5);
                String userName = rs.getString(6);
                int userId = rs.getInt(7);
                if(count == 1){
                    out.println("<TD><input type='hidden' name='isbn_" + isbn + "' value='"+bookid+"'/>");
                    if(imageURL[2] != null){
                        out.println("<TD><img src='" + imageURL[0] + "'/>");
                    }else {
                        out.println("<TD>[No Image]");
                    }
                    out.println("<TD>" + title + "<TD>" + publisher + "<TD>" + date + "<TD>");
                }else if(count > 1){
                    out.println("<TD><input type='radio' name='isbn_" + isbn + "' value='" + bookid +"' " 
                        + ((line==0)? "CHECKED":"" ) + "/>");
                    if(imageURL[2] != null){
                        out.println("<TD><img src='" + imageURL[0] + "'/>");
                    }else {
                        out.println("<TD>[No Image]");
                    }
                    out.println("<TD>" + title + "<TD>" + publisher + "<TD>" + date);
                    if(userName != null){
                        out.println("<TD>貸出中: " + userName);
                    }else {
                        out.println("<TD><BR>");
                    }
                }
                line++;
            }
            rs.close();
        }
        out.println("</table>");
        if(found > 0){
            out.println("<select name='user_id'>");
                out.println("<option value='x'>選んでください");
            for(String name: userMap.keySet()){
                out.println("<option value='" + userMap.get(name) + "'>" + name);
            }
            out.println("</select>");
        }else {
            error = true;
            out.println("貸出可能な書籍がありません。");
        }
        out.println("<input name='isbn' type='hidden' value='"+ join(v.toArray(new String[v.size()]))+"'>");
        stmt.close();
        stmt_count.close();
        con.close();
    }catch(Exception e){
        error = true;
        e.printStackTrace();
        message = e.getMessage();
    }
    if(error){
        out.println("</table>エラーが発生しました。やり直してください。: " + message );
    }else if(found > 0){
        out.println("<input type='button' value='登録' onClick='javascript:rent()'/>");
    }
%>
</form>
</body>
</html>
<%
/*
    Column    |          Type          | Modifiers
--------------+------------------------+-----------
 book_id      | integer                | not null
 isbn         | character varying(16)  |
 title        | character varying(512) |
 reg_date     | date                   |
 manufacturer | character varying(256) |
 user_id      | integer                |
 */
%>
