<%@ page pageEncoding="UTF-8" contentType="text/html;charset=UTF-8" import="java.util.*, java.sql.*, bibliophilia.*, javax.naming.*, javax.sql.*" %>
<%
    BookInfo book = null;
    String isbn = request.getParameter("isbn");

    if(isbn == null){
        isbn = "";
    }else {
        // find books
        isbn = isbn.replaceAll("-", "");
        isbn = isbn.replaceAll(" ", "");
    }
    if(isbn.length() == 13){
        isbn = IsbnUtil.toOldSystem(isbn);
    }
%>
<html>
<head>
<jsp:include page="../htitle.jsp" />
<link rel="stylesheet" href="../style/common.css" TYPE="text/css">
<style type="text/css">
TH {
    background-color: #DDFFDD
}
</style>
</head>
<BODY>
<jsp:include page="../title.jsp" />
<TABLE>
<jsp:include page="../menu.jsp"/>
<TD valign="TOP">
<H2>ISBN/ASINコードで登録</H2>
<form method="POST" action="reg_isbn.jsp">
    ISBN/ASIN <input type="text" value="<%=isbn%>" name="isbn" size="60">
    <input type="submit" value="確認">
    <p>
</form>
<p>
<%
    if(!isbn.trim().equals("")){
        book = BookInfo.getInfoByISBN(isbn.trim());
        if(null == book.getISBN() ||  book.getISBN().equals("")){
            out.println("該当する書籍はありませんでした");
            out.println("<p>");
        }else {
            out.println("<table><TD rowspan='6'>");
            String[] images = book.getImage();
            if(images[1] != null){
                out.println("<a href='" + images[2]+ "'><img src='"+ images[1] +"'></A>");
            }else {
                out.println("[No Image]");
            }
            %>
            <TR><TH>タイトル
            <TD><%=book.getTitle() %>
            <TR><TH>ISBN
            <TD><%=book.getISBN() %>
            <TR><TH>出版社
            <TD><%=book.getManufacturer() %>
            <TR><TH>詳細
            <TD><a href='http://www.amazon.co.jp/exec/obidos/ASIN/<%=book.getISBN()%>'>Amazonの情報</A>
            <TR><TH>著者
            <TD><%
                Vector<Creator> creators = book.getCreators();
                for(Creator c: creators){
                    out.println(c.getName() + "<BR>");
                }
            %>
            </table>
            <form method="post" action="reg_book.jsp">
              <input type="hidden" name="isbn" value="<%=book.getISBN()%>" />
              <input type="submit" value="これを登録"/>
            </form>
            <%
        }
    }
%>
<div style="background: #EFEFEF">
<H3>入力方法</H3>
<ul>
	<img src="isbn.png">
<p>
    ハイフンは入れても入れなくてもかまいません。<p>
    978-で始まる13桁の新ISBNコードは旧10桁に自動的に変換されます。
</UL>
</div>
</TABLE>
</body>
</html>
<%
/*
    Column    |          Type          | Modifiers
--------------+------------------------+-----------
 book_id      | integer                | not null
 isbn         | character varying(16)  |
 title        | character varying(512) |
 reg_date     | date                   |
 manufacturer | character varying(256) |
 user_id      | integer                |
 */
%>
