<%@ page pageEncoding="UTF-8" contentType="text/html;charset=UTF-8" import="java.util.*, java.sql.*, bibliophilia.*, javax.naming.*, javax.sql.*" %>
<%
    int book_id = Integer.parseInt(request.getParameter("book_id"));
    boolean error = false;

    String title = "";
    String isbn = "";
    String manuf = "";
    java.sql.Date date = null;
    StringBuilder buf = new StringBuilder();
    String comment = "";
    try {
        InitialContext ic = new InitialContext();
        DataSource ds = (DataSource)ic.lookup("java:comp/env/jdbc/bibliophilia");
        Connection con = ds.getConnection();
        PreparedStatement stmt = con.prepareStatement("select book_id, title, isbn, reg_date, manufacturer, comment from books where book_id=?");
        stmt.setInt(1, book_id);
        ResultSet rs = stmt.executeQuery();

        while(rs.next()){
            title = rs.getString(2);
            if(title == null){
                title = "";
            }
            isbn = rs.getString(3);
            if(isbn == null){
                isbn = "";
            }
            date = rs.getDate(4);
            manuf = rs.getString(5);
            if(manuf == null){
                manuf = "";
            }
            comment = rs.getString(6);
            if(comment == null){
                comment = "";
            }
        }
        rs.close();
        stmt.close();
        stmt = con.prepareStatement("select arole, name from author where book_id=?");
        stmt.setInt(1, book_id);
        rs = stmt.executeQuery();
        while(rs.next()){
            buf.append(rs.getString(1) + ":" + rs.getString(2) + "\n");
        }
        stmt.close();
        rs.close();
        con.close();
    }catch(Exception e){
        e.printStackTrace();
        error = true;
    }
%>
<html>
<head>
<jsp:include page="../htitle.jsp" />
<style type="text/css">
TH {
    background-color: #DDFFDD
}
</style>
<link rel="stylesheet" href="../style/common.css" TYPE="text/css">
<script language="JavaScript">
function regbook(){
    if(document.getElementsByName("title")[0].value == ""){
        alert("書籍のタイトルが未入力です。");
        return false;
    }
    if(document.getElementsByName("publisher")[0].value == ""){
        alert("出版社名が未入力です。");
        return false;
    }
    if(document.getElementsByName("reg_date")[0].value == ""){
        alert("登録日が未入力です。");
        return false;
    }
    if(document.getElementsByName("authors")[0].value == ""){
        alert("著者名が未入力です。");
        return false;
    }
    document.update_form.submit();
}
</script>
</head>
<BODY>
<jsp:include page="../title.jsp" />
<TABLE>
<jsp:include page="../menu.jsp"/>
<TD valign="TOP">
<H2>手作業による登録</H2>
<form name="update_form" method="post" action="update_book.jsp" />
<input type="hidden" name="book_id" value="<%=book_id%>"/>
<TABLE>
    <TH>書籍名
    <TD><input name="title" type="text" value="<%=title%>" size="80" /><font color="orange">*</font>
<TR>
    <TH>ISBN/ASIN
    <TD><input name="isbn" type="text" value="<%=isbn%>" size="60" />
    <input name="auto_isbn_completion" type="checkbox"  />ISBN自動修正
<TR>
    <TH>登録日
    <TD><input name="reg_date" type="text" value="<%= date %>" size="20" />
    <font color="orange">*</font>
<TR>
    <TH>出版社
    <TD><input name="publisher" type="text" value="<%=manuf%>" size="60">
    <font color="orange">*</font>
<TR>
    <TH>著者
    <TD><TEXTAREA name="authors" rows="5" cols="40"><%=buf.toString()%></TEXTAREA><font color="orange">*</font>
    <br>
    著者情報は次のような形式で入力してください
    <BR>「著:」などの指定が無かった場合はデフォルトで著者として
    登録されます。
    <div style="border: solid; border-width: thin; background-color: #EFEFEF" >
    <pre>著:Radia Perlman
著:Phil Mars
翻訳:ハラパン・メディアテック
監修:加藤朗</pre</div>
<TR><TH>コメント
<TD><TEXTAREA name="comment" rows="5" cols="40"><%=comment.toString()%></TEXTAREA>
<TR>
    <TH>
    <TD><input type="button" onClick="javascript:regbook()" value="確認" />
</TABLE>
<font color="orange">*</font>は必須です。
</form>
</body>
</html>
<%
/*
    Column    |          Type          | Modifiers
--------------+------------------------+-----------
 book_id      | integer                | not null
 isbn         | character varying(16)  |
 title        | character varying(512) |
 reg_date     | date                   |
 manufacturer | character varying(256) |
 user_id      | integer                |
 */
%>
