<%@ page pageEncoding="UTF-8" contentType="text/html;charset=UTF-8" import="java.util.*, java.sql.*, bibliophilia.*, javax.naming.*, javax.sql.*" %>
<html>
<head>
  <!--jsp:include page="htitle.jsp"/-->
  <title>Bibliophilia - 高木研書籍管理システム</title>
  <link rel="stylesheet" href="style/common.css" TYPE="text/css">
</head>
<body>
<jsp:include page="title.jsp" />
<%
    InitialContext ic = new InitialContext();
    DataSource ds = (DataSource)ic.lookup("java:comp/env/jdbc/bibliophilia");
    Connection con = ds.getConnection();
    PreparedStatement stmt = con.prepareStatement("select isbn, title, reg_date, name, book_id from  (select * from books left join user_info on books.user_id=user_info.user_id) as b where reg_date >  current_timestamp + '-3 months'");
    // PreparedStatement stmt = con.prepareStatement("select isbn, title, reg_date, name from  (select * from books left join user_info on books.user_id=user_info.user_id order by reg_date desc) as b limit 15");
    ResultSet rs = stmt.executeQuery();
    HashMap<String, Integer> map = new HashMap<String, Integer>();
    int i = 0;
    Vector<String> users = new Vector<String>();
    Vector<String> date = new Vector<String>();
    Vector<String> isbn = new Vector<String>();
    Vector<Integer> bookids = new Vector<Integer>();
    Vector<String> title = new Vector<String>();
    Vector<java.sql.Date> regdate = new Vector<java.sql.Date>();
    while(rs.next()){
        map.put(rs.getString(1), i);
        users.add(rs.getString(4));
        isbn.add(rs.getString(1));
        bookids.add(rs.getInt(5));
        title.add(rs.getString(2));
        regdate.add(rs.getDate(3));
        i++;
    }
    stmt.close();
    rs.close();
    Collections.shuffle(isbn);
%>
<TABLE width = "640">
 <jsp:include page="menu.jsp" />
<TD valign="top">
<H2>高木研書籍管理システム </H2>
<p>
ようこそ　Bibliophiliaへ。
<p>
貸出記録を付ける方は、最初に利用者登録をしてください。

<H3>新着図書</H3>
最も最近に登録された3冊の書籍です。
<TABLE cellpadding="15">
<%
    PreparedStatement stmt_new = con.prepareStatement(
        "select isbn, title, reg_date, name, book_id from  (select * from books "
            + " left join user_info on books.user_id=user_info.user_id) as b order by reg_date desc limit 3");
    rs = stmt_new.executeQuery();
    while(rs.next()){
      try {
        String isbn_ = rs.getString(1);
        String title_ = rs.getString(2);
        java.sql.Date date_ = rs.getDate(3);
        String name_ = rs.getString(4);
        int bookid_ = rs.getInt(5);
        BookInfo info_ = null;
        if(isbn_ != null){
            info_ = BookInfo.getInfoByISBN(isbn_);
        }
        String[] images = info_.getImage();
        if(images[0] != null){
            out.println(
                "<td valign='TOP'><Center><a href='" + images[2]+ "'><img src='"+ images[0] +"'></a><BR>" 
                + "<a href='/bibliophilia/bookinfo.jsp?rent_book=-1&id="
                + bookid_ +"'>" 
                + title_ + "</a>");
        }else {
            out.println("<TD>[No Image]<P>" 
                + "<a href='/bibliophilia/bookinfo.jsp?rent_book=-1&id="
                + bookid_ +"'>" + title_ + "</A>" );
        }
        out.println("<BR><font color='#888888'><pre>" + date_ + "登録");
        if(name_ != null){
            out.println("<BR>" + name_ + "さんに貸出中");
        }
      }catch(Exception e){
      }
    }
    stmt_new.close();
    rs.close();
    con.close();
%>
</TABLE>
<H3>最近登録された図書</H3>
<table>
<%
 int j = 0;
 for ( i = 0; i<isbn.size() && j<4; i++){
    String ISBN = isbn.elementAt(i);
    try {
        BookInfo info = BookInfo.getInfoByISBN(ISBN);
        String[] images = info.getImage();
        if(images[0] != null){
            out.println("<tr><td><a href='" + images[2]+ "'><img src='"+ images[0] +"'></a>");
            int index = map.get(ISBN);
            out.println(
                "<td><font><a href='/bibliophilia/bookinfo.jsp?rent_book=-1&id="
                + bookids.elementAt(index) +"'>" 
                + title.elementAt(index) + "</a></font>");
            out.println("<br><font color='#888888'>登録: " + regdate.elementAt(index) );
            if(users.elementAt(index) != null){
                out.println(" &nbsp; " + users.elementAt(index) + "さんに貸出中");
            }
            out.println("</font>");
            j++;
        }
    }catch(Exception e){
    }
 }
%>
</table>
<H3>新システムの特徴</H3>
<UL>
<LI>書籍の登録が簡単です
    <UL>バーコードで書籍登録ができます。旧システムでは著者名や
    タイトルを入力する必要がありましたが、その必要はなくなりました。</UL>
<LI>高木研に存在の確認されている書籍のみが登録されています
    <UL>所在の確認されている456冊が登録されています。(2006-6-21現在)</UL>
<LI>簡単に大量に貸出記録を付けることができます
    <UL>一度に沢山の書籍を借りる際は、メニューの一括貸出機能が便利です。
    バーコードリーダーを併せてご利用ください。</UL>
</UL>
<H3>よくある質問</H3>
<LI>返却
<UL>
    <a href="/bibliophilia/reg_user.jsp">利用者情報</A>のページから
        行ってください。
</UL>
<LI>登録されていない本
<UL>
    高木研の所有の本はこのシステムに登録してください。
    ただし、登録する前に、個人の所有ではないことをご確認ください。
</UL>
<LI>画像のない本<p>
<UL>
    画像が表示されない理由はいくつか考えられます。
<p>
    <LI>ISBN番号が未登録。
    <UL>ISBN番号を登録すると表示されるでしょう。
    または、書籍の情報ページで、更新ボタンを押して
    適切なISBN番号を選択してください。
    </UL>
    <LI>ISBN番号が不完全
    <UL>ときどき、9桁しか登録していない書籍があります。
    書籍の情報を編集するページで、ISBNの自動修正をオンのまま
    情報を更新すると、自動的に修正されます。
    </UL>
    <LI>Amazonに画像がない
    <UL>古い書籍などでそのようなケースがあります。
    </UL>
</UL>
<LI>最近登録された図書
<UL>
    最近3ヶ月間に登録されたものの中からランダムに表示しています。
</UL>
<LI>バグ
    <UL>
    このシステムは高木研で開発しています。<br>バグ、不具合等のご連絡は
    <a href="mailto:hoge@cb.k.u-tokyo.ac.jp">山口</a>まで。
    </UL>
</UL>

<%

/*
    try {
        BookInfo info = BookInfo.getInfoByISBN("4042955037");
        Vector<Creator> creators = info.getCreators();
        for(int i = 0; i<creators.size(); i++){
            out.println(creators.elementAt(i).getName());
        }
            // out.println("<BR>" + BookInfo.getURL("4042955037"));
        out.println("<BR><a href='" + info.getDetailPageURL() + "'>Detail</a>");
    }catch(Exception e){
        e.printStackTrace();
    }
    */
%>
<TD>
</table>
</body>
</html>
