package bibliophilia;

import java.util.*;
import java.sql.*;
import bibliophilia.*;
import java.sql.*;
import java.io.*;

public class RegIsbn {
    Connection con = null;
    public static void main(String[] argv){
        RegIsbn reg = new RegIsbn();
        reg.run();
    }
    public RegIsbn(){
    }
    public void run(){

        Vector<String> isbns = new Vector<String>();
        try {
            Class.forName("org.postgresql.Driver");
            con = DriverManager.getConnection(
                "jdbc:postgresql://localhost:5432/bibliophilia?charSet=UNICODE", "bibliophilia", "");
            BufferedReader br = new BufferedReader(new FileReader("isbn-scanned.txt"));
            String line = null;
            while(null != (line = br.readLine())){
                line = IsbnUtil.toOldSystem(line);
                isbns.add(line.trim());
            }
            br.close();
        }catch(Exception e){
            e.printStackTrace();
        }
        for(String isbn: isbns){
            try {
                reg(isbn);
            }catch(Exception e){
                e.printStackTrace();
            }
        }
    }
    public void reg(String isbn) throws Exception{
	    BookInfo book = null;
	    book = BookInfo.getInfoByISBN(isbn.trim());
	    if(null == book.getISBN() ||  book.getISBN().equals("")){
	        System.out.println(isbn + ": the isbn was not in Amazon");
	    }else {
	        try {
	            Statement stmt0 = con.createStatement();
	            ResultSet rs = stmt0.executeQuery("select nextval('seq_book_id')");
	            rs.next();
	            int book_id = rs.getInt(1);
	            PreparedStatement stmt = 
	                con.prepareStatement("insert into books (book_id, isbn, title, reg_date, manufacturer) values(?, ?, ?, ?, ?)");
	            PreparedStatement roles = con.prepareStatement("insert into author (book_id, arole, name) values(?, ?, ?)");
	            stmt.setInt(1, book_id);
	            stmt.setString(2, book.getISBN());
	            stmt.setString(3, book.getTitle());
	            stmt.setDate(4, new java.sql.Date(System.currentTimeMillis() ));
	            stmt.setString(5, book.getManufacturer());
	            stmt.executeUpdate();
	            Vector<Creator> creators = book.getCreators();
	            for(Creator c: creators){
	                roles.setInt(1, book_id);
	                roles.setString(2, c.getRole());
	                roles.setString(3, c.getName());
	                roles.executeUpdate();
	            }
	            stmt0.close();
	            stmt.close();
	            roles.close();
	            rs.close();
	        }catch(Exception e){
	            e.printStackTrace();
	            System.out.println("Error: " + isbn + ":  "+ e.getMessage());
	        }finally {
	        }
	    }
    }
}
