package bibliophilia;

import java.sql.*;
import java.io.*;
import java.util.*;

public class RegBookTable {
    public static void main(String[] argv){
        if(argv.length < 1){
            System.err.println("Assign book list file.");
            return;
        }
        try {
            int userCount = 0;
            HashMap<String, Integer> idmap = new HashMap<String, Integer>();
            idmap.put("---", -1);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(argv[0]), "UTF-8"));
            String line = null;

            Class.forName("org.postgresql.Driver");
            Connection con = DriverManager.getConnection("jdbc:postgresql://localhost:5432/bibliophilia?charSet=UNICODE", "bibliophilia", "");
            Statement stmt = con.createStatement();
            // stmt.executeUpdate("set client_encoding to 'UTF8'");
            PreparedStatement stmt1 = con.prepareStatement("insert into author (book_id, arole, name) values(?, '著', ?)");;
            PreparedStatement regb = con.prepareStatement(
                "insert into books(book_id, isbn, title, reg_date, manufacturer, user_id) values(?, ?, ?, ?, ?, ?)");
            while(null != (line = br.readLine())){
                line = line.trim();
                if(line.equals("")){
                    continue;
                }
                String[] buf = line.split("\t");
                for(int i = 0; i<buf.length; i++){
                    buf[i] = buf[i].trim();
                }

                ResultSet rs = null;
                int userid = -1;
                if(!idmap.containsKey(buf[5])){
                    userid = (++userCount);
                    PreparedStatement regu = con.prepareStatement("insert into user_info(name, user_id) values(?, ?); select nextval('seq_user_id')");
                    regu.setString(1, buf[5]);
                    regu.setInt(2, userid);
                    regu.executeUpdate();
                    regu.close();
                    idmap.put(buf[5], userid);
                }
                userid = idmap.get(buf[5]);
                // buf: ISBN, title, author, manufac, date, user
                rs = stmt.executeQuery("select nextval('seq_book_id')");
                rs.next();
                int bookid = rs.getInt(1);
                regb.setInt(1, bookid);
                buf[0] = buf[0].replaceAll("-", "");
                buf[0] = buf[0].replaceAll("ISBN", "");
                buf[0] = buf[0].replaceAll(":", "");
                buf[0] = buf[0].replaceAll(" ", "");
                regb.setString(2, buf[0]);
                regb.setString(3, buf[1]);
                System.out.write(buf[1].getBytes("UTF-8"));
                System.out.println("");
                buf[4] = buf[4].replace('/', '-');
                regb.setDate(4, java.sql.Date.valueOf(buf[4]));
                regb.setString(5, buf[3]);
                regb.setInt(6, userid);
                regb.executeUpdate();

                stmt1.setInt(1, bookid);
                stmt1.setString(2, buf[2]);
                stmt1.executeUpdate();
            }
        }catch(Exception e){
            e.printStackTrace();
        }
    }
}
