package bibliophilia;
import javax.naming.*;
import javax.sql.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.mail.*;
import javax.mail.internet.*;
import java.util.Properties;
import java.util.Date;
import java.sql.*;

public class MailPostServlet extends HttpServlet{

  private final static String SMTP_HOST_NAME = "smtp.ecc.u-tokyo.ac.jp";
  private static String adminMail = null;

  public void doGet(HttpServletRequest req, HttpServletResponse resp)
    throws IOException, ServletException  {
      if(adminMail == null){
          ServletConfig sc = getServletConfig();
          adminMail = sc.getInitParameter("admin_mail");
      }
      String to = req.getParameter("TO");
      int bookid = Integer.parseInt(req.getParameter("BOOKID"));
      String title = getTitle(bookid);
      String body =
        "このメールは図書管理システム"
            + "Bibliophiliaからの自動送信メッセージです。";
      body += "\nこの本を読みたいと思ってる方がいらっしゃるようですので、早目の返却をお願いいたします。";
      body += "\n";
      body += "\n";
      body += "書籍名: " + title + "\n";
      send(adminMail, to, title, body);
  }
  public String getTitle(int bookid) throws IOException{
      String title = "";
      try {
        InitialContext ic = new InitialContext();
        DataSource ds = (DataSource)ic.lookup("java:comp/env/jdbc/bibliophilia");
        Connection con = ds.getConnection();
        PreparedStatement st = con.prepareStatement("select title from books where book_id=?");
        st.setInt(1, bookid);
        ResultSet rs = st.executeQuery();
        rs.next();
        title = rs.getString(1);
        rs.close();
        st.close();
        con.close();
      }catch(Exception e){
          throw new IOException(e.getMessage());
      }
      return title;
  }
  public static void send(
          String from,   
          String to,     
          String subject,
          String body) { 

    try {

      Properties props = new Properties();
      props.put("mail.smtp.host", SMTP_HOST_NAME);
      Session session = Session.getDefaultInstance(props, null);

      MimeMessage mimeMessage = new MimeMessage(session);
      mimeMessage.addFrom(InternetAddress.parse(from));
      System.err.println(to);
      mimeMessage.setRecipients(Message.RecipientType.TO,InternetAddress.parse(to));
      mimeMessage.setSubject(subject, "iso-2022-jp");
      mimeMessage.setText(body, "iso-2022-jp");
      mimeMessage.setSentDate(new java.util.Date());

      Transport.send(mimeMessage);

    } catch (Exception e) { 
      e.printStackTrace();
    }
  }
}
