package bibliophilia;

public class IsbnUtil {
    static final int[] weight = {10, 9, 8, 7, 6, 5, 4, 3, 2};
    public static String toOldSystem(String newSystem){
        String raw = newSystem.substring(3, 12);
        int sum = 0;
        for(int i = 0; i<raw.length(); i++){
            sum += (weight[i] * Integer.parseInt("" + raw.charAt(i)));
        }
        int digit = 11 - (sum%11);
        String d = "";
        if(digit == 11){
            d = "0";
        }else if(digit == 10){
            d = "X";
        }else {
            d = Integer.toString(digit);
        }
        return raw + d;
    }
    public static String completeCheckDigit10(String raw){
        int sum = 0;
        for(int i = 0; i<raw.length(); i++){
            sum += (weight[i] * Integer.parseInt("" + raw.charAt(i)));
        }
        int digit = 11 - (sum%11);
        String d = "";
        if(digit == 11){
            d = "0";
        }else if(digit == 10){
            d = "X";
        }else {
            d = Integer.toString(digit);
        }
        return raw + d;
    }
    public static String toNewSystem(String oldSystem){
        String raw = "978" + oldSystem.substring(0, 9);
        int oddSum = 0;
        int eveSum = 0;
        for(int i = 0; i<raw.length(); i++){
            if(i%2 == 0){
                oddSum += Integer.parseInt("" + raw.charAt(i));
            }else {
                eveSum += (Integer.parseInt("" + raw.charAt(i)));
            }
        }
        eveSum = eveSum * 3;
        int cd = 10 - (oddSum+eveSum)%10;
        if(cd == 10){
            cd = 0;
        }
        return raw + cd;
    }
}
