package bibliophilia;

import java.net.URL;
import java.net.MalformedURLException;
import java.io.IOException;
import java.net.HttpURLConnection;

/*
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
*/
import javax.xml.parsers.*;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import java.util.Vector;

public class BookInfo {
    final static String subscriptionId = "14PFQ2WS3QXRBWRPXMR2";
    String detailedPageURL = "";
    Vector<Creator> creators = new Vector<Creator>();
    String manufacturer = "";
    String title;
    String isbn = "";
    String[] images = new String[3];
    String urlCache = null;

    public BookInfo(){
    }
    public void setManufacturer(String m){
        manufacturer = m;
    }
    public String getManufacturer(){
        return manufacturer;
    }
    public void setTitle(String str){
        this.title = str;
    }
    public String getISBN(){
        return isbn;
    }
    public void setISBN(String n){
        this.isbn = n;
    }
    public String getTitle(){
        return title;
    }
    public void addCreator(String role, String name){
        creators.add(new Creator(role, name));
    }
    public Vector<Creator> getCreators(){
        return creators;
    }
    public String getDetailPageURL(){
        return detailedPageURL;
    }
    public String getURL(){
        return urlCache;
    }
    public static BookInfo getInfoByISBN(String isbn) 
            throws SAXException, MalformedURLException, ParserConfigurationException, IOException{
        String url = getURL(isbn);
        BookInfo info = new BookInfo();
        info.urlCache = url;

        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        // Document document = builder.parse(new java.io.FileInputStream("hoge.txt"));
        Document document = builder.parse(url);
        NodeList list = document.getElementsByTagName("Creator");
        int creatorCount = 0;
        for(int i = 0; i<list.getLength(); i++){
            // System.out.println(((Element)list.item(i)).getTextContent());
            Element el = (Element)list.item(i);
            info.addCreator(el.getAttribute("Role"), el.getTextContent());
            creatorCount++;
        }
        if(creatorCount == 0){
            list = document.getElementsByTagName("Author");
            for(int i = 0; i<list.getLength(); i++){
                Element el = (Element)list.item(i);
                info.addCreator("", el.getTextContent());
            }
        }

        list = document.getElementsByTagName("DetailPageURL");
        for(int i = 0; i<list.getLength(); i++){
            info.detailedPageURL = ((Element)list.item(i)).getTextContent();
        }
        list = document.getElementsByTagName("Title");
        for(int i = 0; i<list.getLength(); i++){
            info.setTitle( ((Element)list.item(i)).getTextContent() );
            break;
        }
        list = document.getElementsByTagName("ASIN");
        for(int i = 0; i<list.getLength(); i++){
            info.setISBN( ((Element)list.item(i)).getTextContent() );
            break;
        }
        list = document.getElementsByTagName("Manufacturer");
        for(int i = 0; i<list.getLength(); i++){
            info.setManufacturer( ((Element)list.item(i)).getTextContent() );
            break;
        }

        list = document.getElementsByTagName("SmallImage");
        for(int i = 0; i<list.getLength(); i++){
            Element ie = (Element)list.item(i);
            NodeList list2 = ie.getElementsByTagName("URL");
            info.images[0] = ( ((Element)list2.item(0)).getTextContent() );
            break;
        }
        list = document.getElementsByTagName("MediumImage");
        for(int i = 0; i<list.getLength(); i++){
            Element ie = (Element)list.item(i);
            NodeList list2 = ie.getElementsByTagName("URL");
            info.images[1] = ( ((Element)list2.item(0)).getTextContent() );
            break;
        }
        list = document.getElementsByTagName("LargeImage");
        for(int i = 0; i<list.getLength(); i++){
            Element ie = (Element)list.item(i);
            NodeList list2 = ie.getElementsByTagName("URL");
            info.images[2] = ( ((Element)list2.item(0)).getTextContent() );
            break;
        }
        return info;
    }
    public String[] getImage(){
        return images;
    }

    public static String getURL(String isbn){
        return "http://webservices.amazon.co.jp/onca/xml"
            + "?Service=AWSECommerceService"
            + "&Version=2005-03-23"
            + "&Operation=ItemLookup"
            + "&ContentType=text%2Fxml"
            + "&SubscriptionId=" + subscriptionId 
            + "&ItemId=" + isbn
            + "&IdType=ASIN"
            + "&ResponseGroup=Images,ItemAttributes"
            + "&Condition=All";
    }
    public static void main(String[] argv){
        try {
            BookInfo info = BookInfo.getInfoByISBN("4042955037");
        }catch(Exception e){
            e.printStackTrace();
        }
    }
}
/*
<?xml version="1.0" encoding="UTF-8" ?>
<ItemLookupResponse xmlns="http://webservices.amazon.com/AWSECommerceService/2005-03-23">
<OperationRequest>
    <HTTPHeaders>
        <Header Name="UserAgent" Value="Java/1.5.0_01"></Header>
    </HTTPHeaders>
    <RequestId>0K2BZDXM4X3HE21EVGWH</RequestId>
    <Arguments
        <Argument Name="SubscriptionId" Value="14PFQ2WS3QXRBWRPXMR2"></Argument>
        <Argument Name="Condition" Value="All"></Argument>
        <Argument Name="Operation" Value="ItemLookup"></Argument>
        <Argument Name="Service" Value="AWSECommerceService"></Argument>
        <Argument Name="ContentType" Value="text/xml"></Argument>
        <Argument Name="Version" Value="2005-03-23"></Argument>
        <Argument Name="IdType" Value="ASIN"></Argument>
        <Argument Name="ItemId" Value="4042955037"></Argument>
    </Arguments>
    <RequestProcessingTime>0.0109708309173584</RequestProcessingTime>
</OperationRequest>
<Items>
    <Request>
        <IsValid>True</IsValid>
        <ItemLookupRequest>
            <Condition>All</Condition>
            <IdType>ASIN</IdType>
            <ItemId>4042955037</ItemId>
        </ItemLookupRequest>
    </Request>
    <Item>
        <ASIN>4042955037</ASIN>
        <DetailPageURL>http://www.amazon.co.jp/exec/obidos/redirect?tag=ws%26link_code=xm2%26camp=2025%26creative=165953%26path=http://www.amazon.co.jp/gp/redirect.html%253fASIN=4042955037%2526tag=ws%2526lcode=xm2%2526cID=2025%2526ccmID=165953%2526location=/o/ASIN/4042955037%25253FSubscriptionId=14PFQ2WS3QXRBWRPXMR2</DetailPageURL>
        <ItemAttributes>
            <Author>󡦥֥饦</Author>
            <Creator Role="">󡦥֥饦</Creator>
            <Creator Role=""> </Creator>
            <Manufacturer>Ź</Manufacturer>
            <ProductGroup>Book</ProductGroup>
            <Title>()</Title>
        </ItemAttributes>
    </Item>
</Items>
</ItemLookupResponse>
*/
