/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.Field;
import org.postgresql.core.Notification;
import org.postgresql.core.PGStream;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.v2.FastpathParameterList;
import org.postgresql.core.v2.ProtocolConnectionImpl;
import org.postgresql.core.v2.SimpleParameterList;
import org.postgresql.core.v2.V2Query;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class QueryExecutorImpl
implements QueryExecutor {
    private final ProtocolConnectionImpl protoConnection;
    private final PGStream pgStream;

    public QueryExecutorImpl(ProtocolConnectionImpl protoConnection, PGStream pgStream) {
        this.protoConnection = protoConnection;
        this.pgStream = pgStream;
    }

    public ParameterList createFastpathParameters(int count) {
        return new FastpathParameterList(count);
    }

    public Query createParameterizedQuery(String sql) {
        return new V2Query(sql, true);
    }

    public Query createSimpleQuery(String sql) {
        return new V2Query(sql, false);
    }

    public synchronized void execute(Query query, ParameterList parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        this.execute((V2Query)query, (SimpleParameterList)parameters, handler, maxRows, flags);
    }

    private void execute(V2Query query, SimpleParameterList parameters, ResultHandler handler, int maxRows, int flags) throws SQLException {
        if ((flags & 0x20) != 0) {
            return;
        }
        if (parameters == null) {
            parameters = (SimpleParameterList)query.createParameterList();
        }
        parameters.checkAllParametersSet();
        String queryPrefix = null;
        if (this.protoConnection.getTransactionState() == 0 && (flags & 0x10) == 0) {
            queryPrefix = "BEGIN;";
            final ResultHandler delegateHandler = handler;
            handler = new ResultHandler(){
                private boolean sawBegin = false;

                public void handleCommandStatus(String status, int updateCount, long insertOID) {
                    if (!this.sawBegin) {
                        if (!status.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        delegateHandler.handleCommandStatus(status, updateCount, insertOID);
                    }
                }

                public void handleCompletion() throws SQLException {
                    delegateHandler.handleCompletion();
                }

                public void handleError(SQLException error) {
                    delegateHandler.handleError(error);
                }

                public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                    if (this.sawBegin) {
                        delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
                    }
                }

                public void handleWarning(SQLWarning warning) {
                    delegateHandler.handleWarning(warning);
                }
            };
        }
        try {
            this.sendQuery(query, parameters, queryPrefix);
            this.processResults(query, handler, maxRows);
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    public synchronized void execute(Query[] queries, ParameterList[] parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        final ResultHandler delegateHandler = handler;
        handler = new ResultHandler(){

            public void handleCommandStatus(String status, int updateCount, long insertOID) {
                delegateHandler.handleCommandStatus(status, updateCount, insertOID);
            }

            public void handleCompletion() throws SQLException {
            }

            public void handleError(SQLException error) {
                delegateHandler.handleError(error);
            }

            public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
            }

            public void handleWarning(SQLWarning warning) {
                delegateHandler.handleWarning(warning);
            }
        };
        int i = 0;
        while (i < queries.length) {
            this.execute((V2Query)queries[i], (SimpleParameterList)parameters[i], handler, maxRows, flags);
            ++i;
        }
        delegateHandler.handleCompletion();
    }

    public synchronized byte[] fastpathCall(int fnid, ParameterList parameters, boolean suppressBegin) throws SQLException {
        if (this.protoConnection.getTransactionState() == 0 && !suppressBegin) {
            if (Driver.logDebug) {
                Driver.debug("Issuing BEGIN before fastpath call.");
            }
            ResultHandler handler = new ResultHandler(){
                private boolean sawBegin = false;
                private SQLException sqle = null;

                public void handleCommandStatus(String status, int updateCount, long insertOID) {
                    if (!this.sawBegin) {
                        if (!status.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                    }
                }

                public void handleCompletion() throws SQLException {
                    if (this.sqle != null) {
                        throw this.sqle;
                    }
                }

                public void handleError(SQLException error) {
                    if (this.sqle == null) {
                        this.sqle = error;
                    } else {
                        this.sqle.setNextException(error);
                    }
                }

                public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                }

                public void handleWarning(SQLWarning warning) {
                    this.handleError(warning);
                }
            };
            try {
                V2Query query = (V2Query)this.createSimpleQuery("");
                SimpleParameterList params = (SimpleParameterList)query.createParameterList();
                this.sendQuery(query, params, "BEGIN");
                this.processResults(query, handler, 0);
            }
            catch (IOException ioe) {
                throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
        try {
            this.sendFastpathCall(fnid, (FastpathParameterList)parameters);
            return this.receiveFastpathResult();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    public void fetch(ResultCursor cursor, ResultHandler handler, int rows) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "fetch(ResultCursor,ResultHandler,int)");
    }

    private void interpretCommandStatus(String status, ResultHandler handler) throws IOException {
        int update_count = 0;
        long insert_oid = 0L;
        if (status.equals("BEGIN")) {
            this.protoConnection.setTransactionState(1);
        } else if (status.equals("COMMIT") || status.equals("ROLLBACK")) {
            this.protoConnection.setTransactionState(0);
        } else if (status.startsWith("INSERT") || status.startsWith("UPDATE") || status.startsWith("DELETE") || status.startsWith("MOVE")) {
            try {
                update_count = Integer.parseInt(status.substring(1 + status.lastIndexOf(32)));
                if (status.startsWith("INSERT")) {
                    insert_oid = Long.parseLong(status.substring(1 + status.indexOf(32), status.lastIndexOf(32)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                handler.handleError(new PSQLException(GT.tr("Unable to interpret the update count in command completion tag: {0}.", status), PSQLState.CONNECTION_FAILURE));
                return;
            }
        }
        handler.handleCommandStatus(status, update_count, insert_oid);
    }

    protected void processResults(Query originalQuery, ResultHandler handler, int maxRows) throws IOException {
        Field[] fields = null;
        Vector<byte[][]> tuples = null;
        boolean endQuery = false;
        block12: while (!endQuery) {
            int c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    break;
                }
                case 66: {
                    if (fields == null) {
                        throw new IOException("Data transfer before field metadata");
                    }
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE BinaryRow");
                    }
                    byte[][] tuple = this.pgStream.ReceiveTupleV2(fields.length, true);
                    int i = 0;
                    while (i < fields.length) {
                        fields[i].setFormat(1);
                        ++i;
                    }
                    if (maxRows != 0 && tuples.size() >= maxRows) continue block12;
                    tuples.addElement(tuple);
                    break;
                }
                case 67: {
                    String status = this.pgStream.ReceiveString();
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE CommandStatus(" + status + ")");
                    }
                    if (fields != null) {
                        handler.handleResultRows(originalQuery, fields, tuples, null);
                        fields = null;
                        break;
                    }
                    this.interpretCommandStatus(status, handler);
                    break;
                }
                case 68: {
                    if (fields == null) {
                        throw new IOException("Data transfer before field metadata");
                    }
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE DataRow");
                    }
                    byte[][] tuple = this.pgStream.ReceiveTupleV2(fields.length, false);
                    if (maxRows != 0 && tuples.size() >= maxRows) continue block12;
                    tuples.addElement(tuple);
                    break;
                }
                case 69: {
                    handler.handleError(this.receiveErrorMessage());
                    break;
                }
                case 73: {
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE EmptyQuery");
                    }
                    this.pgStream.ReceiveIntegerR(4);
                    break;
                }
                case 78: {
                    handler.handleWarning(this.receiveNotification());
                    break;
                }
                case 80: {
                    String portalName = this.pgStream.ReceiveString();
                    if (!Driver.logDebug) continue block12;
                    Driver.debug(" <=BE PortalName(" + portalName + ")");
                    break;
                }
                case 84: {
                    fields = this.receiveFields();
                    tuples = new Vector<byte[][]>();
                    break;
                }
                case 90: {
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ReadyForQuery");
                    }
                    endQuery = true;
                    break;
                }
                default: {
                    throw new IOException("Unexpected packet type: " + c);
                }
            }
        }
    }

    private void receiveAsyncNotify() throws IOException {
        int pid = this.pgStream.ReceiveIntegerR(4);
        String msg = this.pgStream.ReceiveString();
        if (Driver.logDebug) {
            Driver.debug(" <=BE AsyncNotify(pid=" + pid + ",msg=" + msg + ")");
        }
        this.protoConnection.addNotification(new Notification(msg, pid));
    }

    private SQLException receiveErrorMessage() throws IOException {
        String errorMsg = this.pgStream.ReceiveString().trim();
        if (Driver.logDebug) {
            Driver.debug(" <=BE ErrorResponse(" + errorMsg + ")");
        }
        return new PSQLException(errorMsg, PSQLState.UNKNOWN_STATE);
    }

    private byte[] receiveFastpathResult() throws IOException, SQLException {
        SQLException error = null;
        boolean endQuery = false;
        byte[] result = null;
        block7: while (!endQuery) {
            int c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    break;
                }
                case 69: {
                    SQLException newError = this.receiveErrorMessage();
                    if (error == null) {
                        error = newError;
                        break;
                    }
                    error.setNextException(newError);
                    break;
                }
                case 78: {
                    this.protoConnection.addWarning(this.receiveNotification());
                    break;
                }
                case 86: {
                    c = this.pgStream.ReceiveChar();
                    if (c == 71) {
                        if (Driver.logDebug) {
                            Driver.debug(" <=BE FastpathResult");
                        }
                        int len = this.pgStream.ReceiveIntegerR(4);
                        result = this.pgStream.Receive(len);
                        c = this.pgStream.ReceiveChar();
                    } else if (Driver.logDebug) {
                        Driver.debug(" <=BE FastpathVoidResult");
                    }
                    if (c == 48) continue block7;
                    throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)c)), PSQLState.CONNECTION_FAILURE);
                }
                case 90: {
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ReadyForQuery");
                    }
                    endQuery = true;
                    break;
                }
                default: {
                    throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)c)), PSQLState.CONNECTION_FAILURE);
                }
            }
        }
        if (error != null) {
            throw error;
        }
        return result;
    }

    private Field[] receiveFields() throws IOException {
        int size = this.pgStream.ReceiveIntegerR(2);
        Field[] fields = new Field[size];
        if (Driver.logDebug) {
            Driver.debug(" <=BE RowDescription(" + fields.length + ")");
        }
        int i = 0;
        while (i < fields.length) {
            String columnLabel = this.pgStream.ReceiveString();
            int typeOid = this.pgStream.ReceiveIntegerR(4);
            int typeLength = this.pgStream.ReceiveIntegerR(2);
            int typeModifier = this.pgStream.ReceiveIntegerR(4);
            fields[i] = new Field(columnLabel, columnLabel, typeOid, typeLength, typeModifier, 0, 0);
            ++i;
        }
        return fields;
    }

    private SQLWarning receiveNotification() throws IOException {
        String warnMsg = this.pgStream.ReceiveString();
        int severityMark = warnMsg.indexOf(":");
        warnMsg = warnMsg.substring(severityMark + 1).trim();
        if (Driver.logDebug) {
            Driver.debug(" <=BE NoticeResponse(" + warnMsg + ")");
        }
        return new SQLWarning(warnMsg);
    }

    private void sendFastpathCall(int fnid, FastpathParameterList params) throws IOException {
        int count = params.getParameterCount();
        if (Driver.logDebug) {
            Driver.debug(" FE=> FastpathCall(fnid=" + fnid + ",paramCount=" + count + ")");
        }
        this.pgStream.SendChar(70);
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger4(fnid);
        this.pgStream.SendInteger4(count);
        int i = 1;
        while (i <= count) {
            params.writeV2FastpathValue(i, this.pgStream);
            ++i;
        }
        this.pgStream.flush();
    }

    protected void sendQuery(V2Query query, SimpleParameterList params, String queryPrefix) throws IOException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> Query(\"" + (queryPrefix == null ? "" : queryPrefix) + query.toString(params) + "\")");
        }
        this.pgStream.SendChar(81);
        Writer encodingWriter = this.pgStream.getEncodingWriter();
        if (queryPrefix != null) {
            encodingWriter.write(queryPrefix);
        }
        String[] fragments = query.getFragments();
        int i = 0;
        while (i < fragments.length) {
            encodingWriter.write(fragments[i]);
            if (i < params.getParameterCount()) {
                params.writeV2Value(i + 1, encodingWriter);
            }
            ++i;
        }
        encodingWriter.write(0);
        this.pgStream.flush();
    }
}

