/*
 * Decompiled with CFR 0.152.
 */
package jbarcodebean;

import jbarcodebean.AbstractBarcodeStrategy;
import jbarcodebean.BarcodeException;

public class Code128
extends AbstractBarcodeStrategy {
    public static final char FNC_1 = '\u0080';
    public static final char FNC_2 = '\u0081';
    public static final char FNC_3 = '\u0082';
    public static final char FNC_4 = '\u0083';
    private static final char START_A = '\u0084';
    private static final char START_B = '\u0085';
    private static final char START_C = '\u0086';
    private static final char MODE_A = '\u0087';
    private static final char MODE_B = '\u0088';
    private static final char MODE_C = '\u0089';
    private static final char SHIFT = '\u008a';
    private static final char STOP = '\u008b';
    protected static AbstractBarcodeStrategy.CharacterCode[] codes = new AbstractBarcodeStrategy.CharacterCode[]{new AbstractBarcodeStrategy.CharacterCode(' ', new byte[]{2, 1, 2, 2, 2, 2}, 0), new AbstractBarcodeStrategy.CharacterCode('!', new byte[]{2, 2, 2, 1, 2, 2}, 1), new AbstractBarcodeStrategy.CharacterCode('\"', new byte[]{2, 2, 2, 2, 2, 1}, 2), new AbstractBarcodeStrategy.CharacterCode('#', new byte[]{1, 2, 1, 2, 2, 3}, 3), new AbstractBarcodeStrategy.CharacterCode('$', new byte[]{1, 2, 1, 3, 2, 2}, 4), new AbstractBarcodeStrategy.CharacterCode('%', new byte[]{1, 3, 1, 2, 2, 2}, 5), new AbstractBarcodeStrategy.CharacterCode('&', new byte[]{1, 2, 2, 2, 1, 3}, 6), new AbstractBarcodeStrategy.CharacterCode('\'', new byte[]{1, 2, 2, 3, 1, 2}, 7), new AbstractBarcodeStrategy.CharacterCode('(', new byte[]{1, 3, 2, 2, 1, 2}, 8), new AbstractBarcodeStrategy.CharacterCode(')', new byte[]{2, 2, 1, 2, 1, 3}, 9), new AbstractBarcodeStrategy.CharacterCode('*', new byte[]{2, 2, 1, 3, 1, 2}, 10), new AbstractBarcodeStrategy.CharacterCode('+', new byte[]{2, 3, 1, 2, 1, 2}, 11), new AbstractBarcodeStrategy.CharacterCode(',', new byte[]{1, 1, 2, 2, 3, 2}, 12), new AbstractBarcodeStrategy.CharacterCode('-', new byte[]{1, 2, 2, 1, 3, 2}, 13), new AbstractBarcodeStrategy.CharacterCode('.', new byte[]{1, 2, 2, 2, 3, 1}, 14), new AbstractBarcodeStrategy.CharacterCode('/', new byte[]{1, 1, 3, 2, 2, 2}, 15), new AbstractBarcodeStrategy.CharacterCode('0', new byte[]{1, 2, 3, 1, 2, 2}, 16), new AbstractBarcodeStrategy.CharacterCode('1', new byte[]{1, 2, 3, 2, 2, 1}, 17), new AbstractBarcodeStrategy.CharacterCode('2', new byte[]{2, 2, 3, 2, 1, 1}, 18), new AbstractBarcodeStrategy.CharacterCode('3', new byte[]{2, 2, 1, 1, 3, 2}, 19), new AbstractBarcodeStrategy.CharacterCode('4', new byte[]{2, 2, 1, 2, 3, 1}, 20), new AbstractBarcodeStrategy.CharacterCode('5', new byte[]{2, 1, 3, 2, 1, 2}, 21), new AbstractBarcodeStrategy.CharacterCode('6', new byte[]{2, 2, 3, 1, 1, 2}, 22), new AbstractBarcodeStrategy.CharacterCode('7', new byte[]{3, 1, 2, 1, 3, 1}, 23), new AbstractBarcodeStrategy.CharacterCode('8', new byte[]{3, 1, 1, 2, 2, 2}, 24), new AbstractBarcodeStrategy.CharacterCode('9', new byte[]{3, 2, 1, 1, 2, 2}, 25), new AbstractBarcodeStrategy.CharacterCode(':', new byte[]{3, 2, 1, 2, 2, 1}, 26), new AbstractBarcodeStrategy.CharacterCode(';', new byte[]{3, 1, 2, 2, 1, 2}, 27), new AbstractBarcodeStrategy.CharacterCode('<', new byte[]{3, 2, 2, 1, 1, 2}, 28), new AbstractBarcodeStrategy.CharacterCode('=', new byte[]{3, 2, 2, 2, 1, 1}, 29), new AbstractBarcodeStrategy.CharacterCode('>', new byte[]{2, 1, 2, 1, 2, 3}, 30), new AbstractBarcodeStrategy.CharacterCode('?', new byte[]{2, 1, 2, 3, 2, 1}, 31), new AbstractBarcodeStrategy.CharacterCode('@', new byte[]{2, 3, 2, 1, 2, 1}, 32), new AbstractBarcodeStrategy.CharacterCode('A', new byte[]{1, 1, 1, 3, 2, 3}, 33), new AbstractBarcodeStrategy.CharacterCode('B', new byte[]{1, 3, 1, 1, 2, 3}, 34), new AbstractBarcodeStrategy.CharacterCode('C', new byte[]{1, 3, 1, 3, 2, 1}, 35), new AbstractBarcodeStrategy.CharacterCode('D', new byte[]{1, 1, 2, 3, 1, 3}, 36), new AbstractBarcodeStrategy.CharacterCode('E', new byte[]{1, 3, 2, 1, 1, 3}, 37), new AbstractBarcodeStrategy.CharacterCode('F', new byte[]{1, 3, 2, 3, 1, 1}, 38), new AbstractBarcodeStrategy.CharacterCode('G', new byte[]{2, 1, 1, 3, 1, 3}, 39), new AbstractBarcodeStrategy.CharacterCode('H', new byte[]{2, 3, 1, 1, 1, 3}, 40), new AbstractBarcodeStrategy.CharacterCode('I', new byte[]{2, 3, 1, 3, 1, 1}, 41), new AbstractBarcodeStrategy.CharacterCode('J', new byte[]{1, 1, 2, 1, 3, 3}, 42), new AbstractBarcodeStrategy.CharacterCode('K', new byte[]{1, 1, 2, 3, 3, 1}, 43), new AbstractBarcodeStrategy.CharacterCode('L', new byte[]{1, 3, 2, 1, 3, 1}, 44), new AbstractBarcodeStrategy.CharacterCode('M', new byte[]{1, 1, 3, 1, 2, 3}, 45), new AbstractBarcodeStrategy.CharacterCode('N', new byte[]{1, 1, 3, 3, 2, 1}, 46), new AbstractBarcodeStrategy.CharacterCode('O', new byte[]{1, 3, 3, 1, 2, 1}, 47), new AbstractBarcodeStrategy.CharacterCode('P', new byte[]{3, 1, 3, 1, 2, 1}, 48), new AbstractBarcodeStrategy.CharacterCode('Q', new byte[]{2, 1, 1, 3, 3, 1}, 49), new AbstractBarcodeStrategy.CharacterCode('R', new byte[]{2, 3, 1, 1, 3, 1}, 50), new AbstractBarcodeStrategy.CharacterCode('S', new byte[]{2, 1, 3, 1, 1, 3}, 51), new AbstractBarcodeStrategy.CharacterCode('T', new byte[]{2, 1, 3, 3, 1, 1}, 52), new AbstractBarcodeStrategy.CharacterCode('U', new byte[]{2, 1, 3, 1, 3, 1}, 53), new AbstractBarcodeStrategy.CharacterCode('V', new byte[]{3, 1, 1, 1, 2, 3}, 54), new AbstractBarcodeStrategy.CharacterCode('W', new byte[]{3, 1, 1, 3, 2, 1}, 55), new AbstractBarcodeStrategy.CharacterCode('X', new byte[]{3, 3, 1, 1, 2, 1}, 56), new AbstractBarcodeStrategy.CharacterCode('Y', new byte[]{3, 1, 2, 1, 1, 3}, 57), new AbstractBarcodeStrategy.CharacterCode('Z', new byte[]{3, 1, 2, 3, 1, 1}, 58), new AbstractBarcodeStrategy.CharacterCode('[', new byte[]{3, 3, 2, 1, 1, 1}, 59), new AbstractBarcodeStrategy.CharacterCode('\\', new byte[]{3, 1, 4, 1, 1, 1}, 60), new AbstractBarcodeStrategy.CharacterCode(']', new byte[]{2, 2, 1, 4, 1, 1}, 61), new AbstractBarcodeStrategy.CharacterCode('^', new byte[]{4, 3, 1, 1, 1, 1}, 62), new AbstractBarcodeStrategy.CharacterCode('_', new byte[]{1, 1, 1, 2, 2, 4}, 63), new AbstractBarcodeStrategy.CharacterCode('`', new byte[]{1, 1, 1, 4, 2, 2}, 64), new AbstractBarcodeStrategy.CharacterCode('a', new byte[]{1, 2, 1, 1, 2, 4}, 65), new AbstractBarcodeStrategy.CharacterCode('b', new byte[]{1, 2, 1, 4, 2, 1}, 66), new AbstractBarcodeStrategy.CharacterCode('c', new byte[]{1, 4, 1, 1, 2, 2}, 67), new AbstractBarcodeStrategy.CharacterCode('d', new byte[]{1, 4, 1, 2, 2, 1}, 68), new AbstractBarcodeStrategy.CharacterCode('e', new byte[]{1, 1, 2, 2, 1, 4}, 69), new AbstractBarcodeStrategy.CharacterCode('f', new byte[]{1, 1, 2, 4, 1, 2}, 70), new AbstractBarcodeStrategy.CharacterCode('g', new byte[]{1, 2, 2, 1, 1, 4}, 71), new AbstractBarcodeStrategy.CharacterCode('h', new byte[]{1, 2, 2, 4, 1, 1}, 72), new AbstractBarcodeStrategy.CharacterCode('i', new byte[]{1, 4, 2, 1, 1, 2}, 73), new AbstractBarcodeStrategy.CharacterCode('j', new byte[]{1, 4, 2, 2, 1, 1}, 74), new AbstractBarcodeStrategy.CharacterCode('k', new byte[]{2, 4, 1, 2, 1, 1}, 75), new AbstractBarcodeStrategy.CharacterCode('l', new byte[]{2, 2, 1, 1, 1, 4}, 76), new AbstractBarcodeStrategy.CharacterCode('m', new byte[]{4, 1, 3, 1, 1, 1}, 77), new AbstractBarcodeStrategy.CharacterCode('n', new byte[]{2, 4, 1, 1, 1, 2}, 78), new AbstractBarcodeStrategy.CharacterCode('o', new byte[]{1, 3, 4, 1, 1, 1}, 79), new AbstractBarcodeStrategy.CharacterCode('p', new byte[]{1, 1, 1, 2, 4, 2}, 80), new AbstractBarcodeStrategy.CharacterCode('q', new byte[]{1, 2, 1, 1, 4, 2}, 81), new AbstractBarcodeStrategy.CharacterCode('r', new byte[]{1, 2, 1, 2, 4, 1}, 82), new AbstractBarcodeStrategy.CharacterCode('s', new byte[]{1, 1, 4, 2, 1, 2}, 83), new AbstractBarcodeStrategy.CharacterCode('t', new byte[]{1, 2, 4, 1, 1, 2}, 84), new AbstractBarcodeStrategy.CharacterCode('u', new byte[]{1, 2, 4, 2, 1, 1}, 85), new AbstractBarcodeStrategy.CharacterCode('v', new byte[]{4, 1, 1, 2, 1, 2}, 86), new AbstractBarcodeStrategy.CharacterCode('w', new byte[]{4, 2, 1, 1, 1, 2}, 87), new AbstractBarcodeStrategy.CharacterCode('x', new byte[]{4, 2, 1, 2, 1, 1}, 88), new AbstractBarcodeStrategy.CharacterCode('y', new byte[]{2, 1, 2, 1, 4, 1}, 89), new AbstractBarcodeStrategy.CharacterCode('z', new byte[]{2, 1, 4, 1, 2, 1}, 90), new AbstractBarcodeStrategy.CharacterCode('{', new byte[]{4, 1, 2, 1, 2, 1}, 91), new AbstractBarcodeStrategy.CharacterCode('|', new byte[]{1, 1, 1, 1, 4, 3}, 92), new AbstractBarcodeStrategy.CharacterCode('}', new byte[]{1, 1, 1, 3, 4, 1}, 93), new AbstractBarcodeStrategy.CharacterCode('~', new byte[]{1, 3, 1, 1, 4, 1}, 94), new AbstractBarcodeStrategy.CharacterCode('\u007f', new byte[]{1, 1, 4, 1, 1, 3}, 95), new AbstractBarcodeStrategy.CharacterCode('\u0082', new byte[]{1, 1, 4, 3, 1, 1}, 96), new AbstractBarcodeStrategy.CharacterCode('\u0081', new byte[]{4, 1, 1, 1, 1, 3}, 97), new AbstractBarcodeStrategy.CharacterCode('\u008a', new byte[]{4, 1, 1, 3, 1, 1}, 98), new AbstractBarcodeStrategy.CharacterCode('\u0089', new byte[]{1, 1, 3, 1, 4, 1}, 99), new AbstractBarcodeStrategy.CharacterCode('\u0083', new byte[]{1, 1, 4, 1, 3, 1}, 100), new AbstractBarcodeStrategy.CharacterCode('\u0087', new byte[]{3, 1, 1, 1, 4, 1}, 101), new AbstractBarcodeStrategy.CharacterCode('\u0080', new byte[]{4, 1, 1, 1, 3, 1}, 102), new AbstractBarcodeStrategy.CharacterCode('\u0084', new byte[]{2, 1, 1, 4, 1, 2}, 103), new AbstractBarcodeStrategy.CharacterCode('\u0085', new byte[]{2, 1, 1, 2, 1, 4}, 104), new AbstractBarcodeStrategy.CharacterCode('\u0086', new byte[]{2, 1, 1, 2, 3, 2}, 105), new AbstractBarcodeStrategy.CharacterCode('\u008b', new byte[]{2, 3, 3, 1, 1, 1, 2}, 106)};

    public int requiresChecksum() {
        return 1;
    }

    protected AbstractBarcodeStrategy.CharacterCode[] getCodes() {
        return codes;
    }

    protected String getBarcodeLabelText(String string) {
        String string2 = new String();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '~') continue;
            string2 = string2 + c;
        }
        return string2;
    }

    protected byte getMarginWidth() {
        return 11;
    }

    protected char getStartSentinel() {
        return '\uffff';
    }

    protected char getStopSentinel() {
        return '\u008b';
    }

    protected boolean isInterleaved() {
        return false;
    }

    protected String preprocess(String string) throws BarcodeException {
        String string2 = new String();
        int n = 0;
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        c2 = string.charAt(0);
        if (c2 == '\u0080' || c2 == '\u0081' || c2 == '\u0082' || c2 == '\u0083') {
            c = c2;
            c2 = string.charAt(1);
            if (string.length() > 2) {
                c3 = string.charAt(2);
            }
        } else if (string.length() > 1) {
            c3 = string.charAt(1);
        }
        if (c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9' && c != '\u0081' && c != '\u0082' && c != '\u0083') {
            string2 = string2 + '\u0086';
            n = 137;
        } else if (c2 >= ' ' && c2 <= '\u007f') {
            string2 = string2 + '\u0085';
            n = 136;
        } else {
            string2 = string2 + '\u0084';
            n = 135;
        }
        block5: for (int i = 0; i < string.length(); ++i) {
            c2 = string.charAt(i);
            c3 = i + 1 < string.length() ? string.charAt(i + 1) : (char)'\u0000';
            if (c2 > '\u0083') {
                throw new BarcodeException("Invalid character in barcode");
            }
            switch (n) {
                case 137: {
                    if (c2 == '\u0080') {
                        string2 = string2 + '\u0080';
                        continue block5;
                    }
                    if (c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9') {
                        string2 = string2 + this.convertCodeC(string.substring(i, i + 2));
                        ++i;
                        continue block5;
                    }
                    if (c2 >= ' ' && c2 <= '\u007f') {
                        string2 = string2 + '\u0083';
                        n = 136;
                        --i;
                        continue block5;
                    }
                    string2 = string2 + '\u0087';
                    n = 135;
                    --i;
                    continue block5;
                }
                case 136: {
                    if (c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9') {
                        string2 = string2 + '\u0089';
                        n = 137;
                        --i;
                        continue block5;
                    }
                    if (c2 >= ' ' && c2 <= '\u007f') {
                        string2 = string2 + c2;
                        continue block5;
                    }
                    if (c2 == '\u0080' || c2 == '\u0081' || c2 == '\u0082' || c2 == '\u0083') {
                        string2 = string2 + c2;
                        continue block5;
                    }
                    string2 = string2 + '\u0087';
                    n = 135;
                    --i;
                    continue block5;
                }
                case 135: {
                    if (c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9') {
                        string2 = string2 + '\u0089';
                        n = 137;
                        --i;
                        continue block5;
                    }
                    if (c2 < ' ') {
                        string2 = string2 + (c2 + 96);
                        continue block5;
                    }
                    if (c2 <= '_') {
                        string2 = string2 + c2;
                        continue block5;
                    }
                    if (c2 == '\u0080' || c2 == '\u0081' || c2 == '\u0082') {
                        string2 = string2 + c2;
                        continue block5;
                    }
                    if (c2 == '\u0083') {
                        string2 = string2 + '\u0087';
                        continue block5;
                    }
                    string2 = string2 + '\u0083';
                    n = 136;
                    --i;
                }
            }
        }
        return string2;
    }

    private char convertCodeC(String string) {
        int n = 32 + new Integer(string);
        switch (n) {
            case 128: {
                n = 130;
                break;
            }
            case 129: {
                n = 129;
                break;
            }
            case 130: {
                n = 138;
                break;
            }
            case 131: {
                n = 137;
            }
        }
        return (char)n;
    }

    protected String postprocess(String string) {
        return string;
    }

    protected String augmentWithChecksum(String string) throws BarcodeException {
        int n = 0;
        AbstractBarcodeStrategy.CharacterCode characterCode = this.getCharacterCode(string.charAt(0));
        n = characterCode.check;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            characterCode = this.getCharacterCode(c);
            if (characterCode == null) {
                throw new BarcodeException("Invalid character in barcode");
            }
            n += characterCode.check * i;
        }
        characterCode = this.getCharacterCode(n % 103);
        return string + characterCode.character;
    }
}

