/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.ui.preference.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten 設定の初期化のためのメッセージ。
 *
 * リソースバンドル定義: [BentenPreferenceInitializerMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenPreferenceInitializerMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenPreferenceInitializerMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenPreferenceInitializerMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenPreferenceInitializerMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/preference/messages/BentenPreferenceInitializerMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenPreferenceInitializerMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenPreferenceInitializerMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenPreferenceInitializerMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/preference/messages/BentenPreferenceInitializerMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenPreferenceInitializerMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenPreferenceInitializerMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenPreferenceInitializerMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/preference/messages/BentenPreferenceInitializerMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenPreferenceInitializerMessages], key[Default_TM_Name]
     *
     * [Simple] (en)<br>
     * [Simple] (ja)<br>
     *
     * @return key[Default_TM_Name]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDefaultTmName() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Simple";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Default_TM_Name");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenPreferenceInitializerMessages], key[Default_Glossary_Name]
     *
     * [Regex] (en)<br>
     * [Regex] (ja)<br>
     *
     * @return key[Default_Glossary_Name]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDefaultGlossaryName() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Regex";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Default_Glossary_Name");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
