/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.handler;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

import benten.twa.cat.core.BentenMarkNoTransableBatchProcess;
import benten.twa.cat.core.BentenMarkNoTransableProcessImpl;
import benten.twa.cat.core.valueobject.BentenMarkNoTransableProcessInput;
import benten.twa.cat.dialogs.MarkNoTransableDialog;
import benten.twa.cat.messages.BentenMarkNoTransableMessages;
import benten.twa.cat.status.BentenMarkNoTransableStatus;
import benten.twa.ui.jobs.AbstractWorkflowHandler;

/**
 * 翻訳対象外のマーク
 *
 * <pre>
 * XLIFF 内の翻訳の必要のない翻訳単位を、翻訳対象外としてマークします。
 *   1.  XLIFF の翻訳単位の内容から、翻訳の必要の有無を判断します。
 *   2.  翻訳の必要がないと判断されたものについて、翻訳対象外としてマークします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 非翻訳対象マーク機能」に対応します。
 * 
 * @author IGA Tosiki
 */
public class MarkNoTransableHandler extends AbstractWorkflowHandler {
	/**
	 * 翻訳対象外マーク機能のためのメッセージ。
	 */
	protected static final BentenMarkNoTransableMessages fMsg = new BentenMarkNoTransableMessages();

	@Override
	protected StatusDialog createDialog(final Shell shell, final IStructuredSelection selection) {
		setJobMessage(fMsg.getJobName());
		return new MarkNoTransableDialog(shell, selection);
	}

	@Override
	protected void processFile(final IStatus iStatus) throws IOException, SAXException {
		final BentenMarkNoTransableStatus status = (BentenMarkNoTransableStatus) iStatus;

		final BentenMarkNoTransableProcessInput input = new BentenMarkNoTransableProcessInput();
		input.setXliffdir(status.getTargetDir().getAbsolutePath());
		new BentenMarkNoTransableBatchProcess().validateInput(input);
		final BentenMarkNoTransableProcessImpl process = new BentenMarkNoTransableProcessImpl() {
			@Override
			protected void beginTask(final int totalWork) {
				monitor.beginTask(null, totalWork);
			}

			@Override
			public boolean progress(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				monitor.worked(1);
				Thread.yield();
				return monitor.isCanceled();
			}
		};
		process.execute(input);
		resultInfo = process.getResultInfo();
	}
}
