/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.handler;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

import benten.twa.cat.core.BentenApplyFuzzyMatchBatchProcess;
import benten.twa.cat.core.BentenApplyFuzzyMatchProcessImpl;
import benten.twa.cat.core.valueobject.BentenApplyFuzzyMatchProcessInput;
import benten.twa.cat.dialogs.ApplyFuzzyMatchDialog;
import benten.twa.cat.messages.BentenApplyFuzzyMatchMessages;
import benten.twa.cat.status.BentenApplyFuzzyMatchStatus;
import benten.twa.ui.jobs.AbstractWorkflowHandler;

/**
 * 類似訳の適用
 * 
 * <pre>
 * このウィザードは、TMX の類似訳を XLIFF に適用します。
 *   1.  翻訳単位と類似する TMX を探し、翻訳単位の代替翻訳に適用します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 類似訳適用機能」に対応します。
 * 
 * @author IGA Tosiki
 */
public class ApplyFuzzyMatchHandler extends AbstractWorkflowHandler {
	/**
	 * 類似訳適用機能のためのメッセージ。
	 */
	protected static final BentenApplyFuzzyMatchMessages fMsg = new BentenApplyFuzzyMatchMessages();

	@Override
	protected StatusDialog createDialog(final Shell shell, final IStructuredSelection selection) {
		setJobMessage(fMsg.getJobName());
		return new ApplyFuzzyMatchDialog(shell, selection);
	}

	@Override
	protected void processFile(final IStatus iStatus) throws IOException, SAXException {
		final BentenApplyFuzzyMatchStatus status = (BentenApplyFuzzyMatchStatus) iStatus;

		final BentenApplyFuzzyMatchProcessInput input = new BentenApplyFuzzyMatchProcessInput();
		// input.setTmxdir() は呼び出しません。
		input.setXliffdir(status.getXliffDir().getAbsolutePath());

		// ホワイトスペースを無視して TMX を検索するかどうかのフラグ。
		input.setIgnorewhitespacetmreference(status.getIgnoreWhitespaceTmReference());

		// ニーモニック・キーを無視して TMX を検索するかどうかのフラグ。
		input.setIgnoremnemonickeytmreference(status.getIgnoreMnemonicKeyTmReference());

		new BentenApplyFuzzyMatchBatchProcess().validateInput(input);
		final BentenApplyFuzzyMatchProcessImpl process = new BentenApplyFuzzyMatchProcessImpl() {
			@Override
			protected void beginTask(final int totalWork) {
				monitor.beginTask(null, totalWork);
			}

			@Override
			public boolean progress(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				monitor.worked(1);
				Thread.yield();
				return monitor.isCanceled();
			}

			@Override
			public boolean progressInner(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				Thread.yield();
				return monitor.isCanceled();
			}
		};
		process.execute(input);
		resultInfo = process.getResultInfo();
	}
}
