/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.tmx.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

import benten.twa.tmx.dialogs.ExtractTmxFragmentDialog;
import benten.twa.tmx.messages.BentenExtractTmxFragmentMessages;
import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.twa.ui.wizards.AbstractWorkflowDialogWizardPage;

/**
 * TMX フラグメントの抽出
 *
 * <pre>
 * XLIFF フラグメントから、TMX フラグメントを抽出します。
 *   1.  XLIFF から翻訳単位を抽出して TMX を作成します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳メモリー断片抽出・マージ機能: TMXフラグメント抽出機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class ExtractTmxFragmentWizardPage2 extends AbstractWorkflowDialogWizardPage {
	/**
	 * TMXフラグメント抽出機能のためのメッセージ。
	 */
	protected static final BentenExtractTmxFragmentMessages fMsg = new BentenExtractTmxFragmentMessages();

	/**
	 * コンストラクター。
	 * @param selection 選択
	 */
	protected ExtractTmxFragmentWizardPage2(final IStructuredSelection selection) {
		super(selection);
		setTitle(fMsg.getWizardPage2Title());
		setDescription(fMsg.getWizardPage2Description());
	}

	@Override
	public AbstractWorkflowDialog createWorkflowDialog(final Composite parent, final IStructuredSelection selection) {
		return new ExtractTmxFragmentDialog(parent.getShell(), selection);
	}
}
