/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.ui.dialogs.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * ノートを編集するためのダイアログのためのメッセージ。
 *
 * リソースバンドル定義: [NoteDialogMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class NoteDialogMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * NoteDialogMessagesクラスのコンストラクタ。
     *
     * 基底名[NoteDialogMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public NoteDialogMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/dialogs/messages/NoteDialogMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * NoteDialogMessagesクラスのコンストラクタ。
     *
     * 基底名[NoteDialogMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public NoteDialogMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/dialogs/messages/NoteDialogMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * NoteDialogMessagesクラスのコンストラクタ。
     *
     * 基底名[NoteDialogMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public NoteDialogMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/dialogs/messages/NoteDialogMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[NoteDialogMessages], key[Label.0]
     *
     * [Person in &amp;Charge:] (en)<br>
     * [担当(&amp;C):] (ja)<br>
     *
     * @return key[Label.0]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel0() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Person in &Charge:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.0");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[NoteDialogMessages], key[Label.1]
     *
     * [Con&amp;tents:] (en)<br>
     * [内容(&amp;T):] (ja)<br>
     *
     * @return key[Label.1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Con&tents:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[NoteDialogMessages], key[Dlg.Error.0]
     *
     * [Enter either of the person in charge or the contents.] (en)<br>
     * [担当、内容のいずれかを入力してください。] (ja)<br>
     *
     * @return key[Dlg.Error.0]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError0() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Enter either of the person in charge or the contents.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.0");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
