/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.ui.dialogs.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * リソース * 選択ダイアログのためのメッセージ。
 *
 * リソースバンドル定義: [ResourceSelectionDialogMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class ResourceSelectionDialogMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * ResourceSelectionDialogMessagesクラスのコンストラクタ。
     *
     * 基底名[ResourceSelectionDialogMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public ResourceSelectionDialogMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/dialogs/messages/ResourceSelectionDialogMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * ResourceSelectionDialogMessagesクラスのコンストラクタ。
     *
     * 基底名[ResourceSelectionDialogMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public ResourceSelectionDialogMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/dialogs/messages/ResourceSelectionDialogMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * ResourceSelectionDialogMessagesクラスのコンストラクタ。
     *
     * 基底名[ResourceSelectionDialogMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public ResourceSelectionDialogMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/dialogs/messages/ResourceSelectionDialogMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[ResourceSelectionDialogMessages], key[Msg.001]
     *
     * [Select File] (en)<br>
     * [ファイルの選択] (ja)<br>
     *
     * @return key[Msg.001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Select File";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[ResourceSelectionDialogMessages], key[Msg.002]
     *
     * [Select a file.] (en)<br>
     * [ファイルを選択してください。] (ja)<br>
     *
     * @return key[Msg.002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Select a file.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[ResourceSelectionDialogMessages], key[Msg.011]
     *
     * [Select Folder] (en)<br>
     * [フォルダーの選択] (ja)<br>
     *
     * @return key[Msg.011]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg011() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Select Folder";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.011");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[ResourceSelectionDialogMessages], key[Msg.012]
     *
     * [Select a folder.] (en)<br>
     * [フォルダーを選択してください。] (ja)<br>
     *
     * @return key[Msg.012]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg012() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Select a folder.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.012");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
