/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.stat.model;

/**
 * 翻訳率のためのモデル・クラス。
 */
public class TranslationRateModel extends AbstractStatModel {
    /**
     * フィールド: [transUnit]。
     */
    private int fTransUnit;

    /**
     * フィールド: [untranslate]。
     */
    private int fUntranslate;

    /**
     * フィールド: [nottranslated]。
     */
    private int fNottranslated;

    /**
     * フィールド: [working]。
     */
    private int fWorking;

    /**
     * フィールド: [translated]。
     */
    private int fTranslated;

    /**
     * フィールド: [untranslateRate]。
     */
    private int fUntranslateRate;

    /**
     * フィールド: [nottranslatedRate]。
     */
    private int fNottranslatedRate;

    /**
     * フィールド: [workingRate]。
     */
    private int fWorkingRate;

    /**
     * フィールド: [translatedRate]。
     */
    private int fTranslatedRate;

    /**
     * フィールド [transUnit] の値を設定します。
     *
     * @param argTransUnit フィールド[transUnit]に設定する値。
     */
    public void setTransUnit(final int argTransUnit) {
        fTransUnit = argTransUnit;
    }

    /**
     * フィールド [transUnit] の値を取得します。
     *
     * @return フィールド[transUnit]から取得した値。
     */
    public int getTransUnit() {
        return fTransUnit;
    }

    /**
     * フィールド [untranslate] の値を設定します。
     *
     * @param argUntranslate フィールド[untranslate]に設定する値。
     */
    public void setUntranslate(final int argUntranslate) {
        fUntranslate = argUntranslate;
    }

    /**
     * フィールド [untranslate] の値を取得します。
     *
     * @return フィールド[untranslate]から取得した値。
     */
    public int getUntranslate() {
        return fUntranslate;
    }

    /**
     * フィールド [nottranslated] の値を設定します。
     *
     * @param argNottranslated フィールド[nottranslated]に設定する値。
     */
    public void setNottranslated(final int argNottranslated) {
        fNottranslated = argNottranslated;
    }

    /**
     * フィールド [nottranslated] の値を取得します。
     *
     * @return フィールド[nottranslated]から取得した値。
     */
    public int getNottranslated() {
        return fNottranslated;
    }

    /**
     * フィールド [working] の値を設定します。
     *
     * @param argWorking フィールド[working]に設定する値。
     */
    public void setWorking(final int argWorking) {
        fWorking = argWorking;
    }

    /**
     * フィールド [working] の値を取得します。
     *
     * @return フィールド[working]から取得した値。
     */
    public int getWorking() {
        return fWorking;
    }

    /**
     * フィールド [translated] の値を設定します。
     *
     * @param argTranslated フィールド[translated]に設定する値。
     */
    public void setTranslated(final int argTranslated) {
        fTranslated = argTranslated;
    }

    /**
     * フィールド [translated] の値を取得します。
     *
     * @return フィールド[translated]から取得した値。
     */
    public int getTranslated() {
        return fTranslated;
    }

    /**
     * フィールド [untranslateRate] の値を設定します。
     *
     * @param argUntranslateRate フィールド[untranslateRate]に設定する値。
     */
    public void setUntranslateRate(final int argUntranslateRate) {
        fUntranslateRate = argUntranslateRate;
    }

    /**
     * フィールド [untranslateRate] の値を取得します。
     *
     * @return フィールド[untranslateRate]から取得した値。
     */
    public int getUntranslateRate() {
        return fUntranslateRate;
    }

    /**
     * フィールド [nottranslatedRate] の値を設定します。
     *
     * @param argNottranslatedRate フィールド[nottranslatedRate]に設定する値。
     */
    public void setNottranslatedRate(final int argNottranslatedRate) {
        fNottranslatedRate = argNottranslatedRate;
    }

    /**
     * フィールド [nottranslatedRate] の値を取得します。
     *
     * @return フィールド[nottranslatedRate]から取得した値。
     */
    public int getNottranslatedRate() {
        return fNottranslatedRate;
    }

    /**
     * フィールド [workingRate] の値を設定します。
     *
     * @param argWorkingRate フィールド[workingRate]に設定する値。
     */
    public void setWorkingRate(final int argWorkingRate) {
        fWorkingRate = argWorkingRate;
    }

    /**
     * フィールド [workingRate] の値を取得します。
     *
     * @return フィールド[workingRate]から取得した値。
     */
    public int getWorkingRate() {
        return fWorkingRate;
    }

    /**
     * フィールド [translatedRate] の値を設定します。
     *
     * @param argTranslatedRate フィールド[translatedRate]に設定する値。
     */
    public void setTranslatedRate(final int argTranslatedRate) {
        fTranslatedRate = argTranslatedRate;
    }

    /**
     * フィールド [translatedRate] の値を取得します。
     *
     * @return フィールド[translatedRate]から取得した値。
     */
    public int getTranslatedRate() {
        return fTranslatedRate;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.cat.stat.model.TranslationRateModel[");
        buf.append("transUnit=" + fTransUnit);
        buf.append(",untranslate=" + fUntranslate);
        buf.append(",nottranslated=" + fNottranslated);
        buf.append(",working=" + fWorking);
        buf.append(",translated=" + fTranslated);
        buf.append(",untranslateRate=" + fUntranslateRate);
        buf.append(",nottranslatedRate=" + fNottranslatedRate);
        buf.append(",workingRate=" + fWorkingRate);
        buf.append(",translatedRate=" + fTranslatedRate);
        buf.append("]");
        return buf.toString();
    }
}
