/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.stat.model;

/**
 * TM ヒット率のためのモデル・クラス。
 */
public class TmHitRateModel extends AbstractStatModel {
    /**
     * フィールド: [match_100]。
     */
    private int fMatch100;

    /**
     * フィールド: [match_95]。
     */
    private int fMatch95;

    /**
     * フィールド: [match_85]。
     */
    private int fMatch85;

    /**
     * フィールド: [match_75]。
     */
    private int fMatch75;

    /**
     * フィールド: [matchUnder_75]。
     */
    private int fMatchUnder75;

    /**
     * フィールド [match_100] の値を設定します。
     *
     * @param argMatch100 フィールド[match_100]に設定する値。
     */
    public void setMatch100(final int argMatch100) {
        fMatch100 = argMatch100;
    }

    /**
     * フィールド [match_100] の値を取得します。
     *
     * @return フィールド[match_100]から取得した値。
     */
    public int getMatch100() {
        return fMatch100;
    }

    /**
     * フィールド [match_95] の値を設定します。
     *
     * @param argMatch95 フィールド[match_95]に設定する値。
     */
    public void setMatch95(final int argMatch95) {
        fMatch95 = argMatch95;
    }

    /**
     * フィールド [match_95] の値を取得します。
     *
     * @return フィールド[match_95]から取得した値。
     */
    public int getMatch95() {
        return fMatch95;
    }

    /**
     * フィールド [match_85] の値を設定します。
     *
     * @param argMatch85 フィールド[match_85]に設定する値。
     */
    public void setMatch85(final int argMatch85) {
        fMatch85 = argMatch85;
    }

    /**
     * フィールド [match_85] の値を取得します。
     *
     * @return フィールド[match_85]から取得した値。
     */
    public int getMatch85() {
        return fMatch85;
    }

    /**
     * フィールド [match_75] の値を設定します。
     *
     * @param argMatch75 フィールド[match_75]に設定する値。
     */
    public void setMatch75(final int argMatch75) {
        fMatch75 = argMatch75;
    }

    /**
     * フィールド [match_75] の値を取得します。
     *
     * @return フィールド[match_75]から取得した値。
     */
    public int getMatch75() {
        return fMatch75;
    }

    /**
     * フィールド [matchUnder_75] の値を設定します。
     *
     * @param argMatchUnder75 フィールド[matchUnder_75]に設定する値。
     */
    public void setMatchUnder75(final int argMatchUnder75) {
        fMatchUnder75 = argMatchUnder75;
    }

    /**
     * フィールド [matchUnder_75] の値を取得します。
     *
     * @return フィールド[matchUnder_75]から取得した値。
     */
    public int getMatchUnder75() {
        return fMatchUnder75;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.cat.stat.model.TmHitRateModel[");
        buf.append("match_100=" + fMatch100);
        buf.append(",match_95=" + fMatch95);
        buf.append(",match_85=" + fMatch85);
        buf.append(",match_75=" + fMatch75);
        buf.append(",matchUnder_75=" + fMatchUnder75);
        buf.append("]");
        return buf.toString();
    }
}
