/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.xliff.status;

import java.io.File;

import benten.ui.UiStatus;

/**
 * 状態をダイアログとハンドラーで共用するためのクラス。
 */
public class BentenCleanXliffStatus extends UiStatus {
    /**
     * フィールド: [targetDir]。
     */
    private File fTargetDir;

    /**
     * フィールド [targetDir] の値を設定します。
     *
     * @param argTargetDir フィールド[targetDir]に設定する値。
     */
    public void setTargetDir(final File argTargetDir) {
        fTargetDir = argTargetDir;
    }

    /**
     * フィールド [targetDir] の値を取得します。
     *
     * @return フィールド[targetDir]から取得した値。
     */
    public File getTargetDir() {
        return fTargetDir;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.xliff.status.BentenCleanXliffStatus[");
        buf.append("targetDir=" + fTargetDir);
        buf.append("]");
        return buf.toString();
    }
}
