/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;

import benten.cat.tm.core.BentenTmSearchResult;
import benten.cat.tm.ui.views.TranslationView;
import benten.ui.actions.AbstractCopyAction;

/**
 * 翻訳ターゲット・コピー・アクション。
 *
 * @author YAMAMOTO Koji
 * @author KASHIHARA Shinji
 */
public class CopyTranslationTargetAction extends AbstractCopyAction {

	/**
	 * コンストラクター。
	 * @param view ビュー
	 * @param text テキスト
	 */
	public CopyTranslationTargetAction(final TranslationView view, final String text) {
		super(view, text);
	}

	@Override
	protected String asText(final IStructuredSelection selection) {
		final BentenTmSearchResult entry = (BentenTmSearchResult) selection.getFirstElement();
		return entry.getTarget();
	}
}
