/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.preference;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

import benten.twa.filter.preference.messages.TwaFilterPropertyPageMessages;
import benten.ui.preference.BentenProjectProperty;
import benten.ui.preference.BentenProjectProperty.ProjectProperty;
import benten.ui.views.UiToolkit;

/**
 * 翻訳支援ツール・フィルターのプロパティー・ページです。
 *
 * @author KASHIHARA Shinji
 */
public class TwaFilterPropertyPage extends PropertyPage implements IWorkbenchPropertyPage {
	/**
	 * 翻訳支援ツール・フィルターのプロパティー・ページのためのメッセージ。
	 */
	protected static final TwaFilterPropertyPageMessages fMsg = new TwaFilterPropertyPageMessages();

	/**
	 * Benten が提供する基本的なウィジェットを生成する UI ツールキットのインスタンス。
	 */
	private final UiToolkit toolkit = new UiToolkit();

	/** プリファランス・ストア。 */
	private IPreferenceStore projectStore;

	// 画面項目(ボタン)。

	private Button transTargetImportedPromptCheck;
	private Button xliffConvertedPromptCheck;

	@Override
	protected Control createContents(final Composite parent) {
		final Composite composite = toolkit.createComposite(parent, 1);
		projectStore = BentenProjectProperty.getStore((IProject) getElement());

		final Group promptGroup = new Group(composite, SWT.BOLD);
		promptGroup.setLayout(toolkit.createGridLayout(2, 5));
		promptGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		promptGroup.setText(fMsg.getLabel0());

		transTargetImportedPromptCheck = new Button(promptGroup, SWT.CHECK);
		transTargetImportedPromptCheck.setText(fMsg.getLabel1());
		transTargetImportedPromptCheck.setSelection(prompt(ProjectProperty.PROMPT_TRANS_TARGET_IMPORTED));

		toolkit.createLabel(promptGroup, getStateMessage(ProjectProperty.TRANS_TARGET_IMPORTED));

		xliffConvertedPromptCheck = new Button(promptGroup, SWT.CHECK);
		xliffConvertedPromptCheck.setText(fMsg.getLabel2());
		xliffConvertedPromptCheck.setSelection(prompt(ProjectProperty.PROMPT_XLIFF_CONVERTED));

		toolkit.createLabel(promptGroup, getStateMessage(ProjectProperty.XLIFF_CONVERTED));

		return composite;
	}

	/**
	 * 状態メッセージの取得。
	 * @param property プロパティ。
	 * @return メッセージ。
	 */
	private String getStateMessage(final ProjectProperty property) {
		return projectStore.getBoolean(property.name()) ? fMsg.getMsg001() : fMsg.getMsg002();
	}

	/**
	 * プロジェクト・ストアを参照し、プロンプトするか判定。
	 * @param property プロジェクト・プロパティ。
	 * @return プロンプトする場合は true。
	 */
	private boolean prompt(final ProjectProperty property) {
		final String prompt = projectStore.getString(property.name());
		return !MessageDialogWithToggle.ALWAYS.equals(prompt);
	}

	/**
	 * チェックボックスからプロジェクト・ストアに保管するための値を取得。
	 * @param check チェックボックス。
	 * @return プロンプトする場合は MessageDialogWithToggle.PROMPT、しない場合は MessageDialogWithToggle.ALWAYS。
	 */
	private String getValue(final Button check) {
		return check.getSelection() ? MessageDialogWithToggle.PROMPT : MessageDialogWithToggle.ALWAYS;
	}

	@Override
	public boolean performOk() {
		projectStore.setValue(ProjectProperty.PROMPT_TRANS_TARGET_IMPORTED.name(),
				getValue(transTargetImportedPromptCheck));
		projectStore.setValue(ProjectProperty.PROMPT_XLIFF_CONVERTED.name(), getValue(xliffConvertedPromptCheck));
		return true;
	}

	@Override
	protected void performDefaults() {
		transTargetImportedPromptCheck.setSelection(true);
		xliffConvertedPromptCheck.setSelection(true);
	}
}
