/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.filter.core.valueobject;

/**
 * 処理クラス [BentenExportHtmlProcess]の入力バリューオブジェクトクラスです。
 */
public class BentenExportHtmlProcessInput {
    /**
     * verboseモードで動作させるかどうか。
     *
     * フィールド: [verbose]。
     * デフォルト: [false]。
     */
    private boolean fVerbose = false;

    /**
     * エクスポート元となる XLIFF が格納されたディレクトリ。
     *
     * フィールド: [sourcexliffdir]。
     */
    private String fSourcexliffdir;

    /**
     * エクスポート元となる HTML が格納されたディレクトリ。
     *
     * フィールド: [sourcehtmldir]。
     */
    private String fSourcehtmldir;

    /**
     * エクスポート先となる HTML を格納するディレクトリ。
     *
     * フィールド: [targetdir]。
     */
    private String fTargetdir;

    /**
     * フィールド [verbose] の値を設定します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     *
     * @param argVerbose フィールド[verbose]に設定する値。
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * フィールド [verbose] の値を取得します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[verbose]から取得した値。
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * フィールド [sourcexliffdir] の値を設定します。
     *
     * フィールドの説明: [エクスポート元となる XLIFF が格納されたディレクトリ。]。
     *
     * @param argSourcexliffdir フィールド[sourcexliffdir]に設定する値。
     */
    public void setSourcexliffdir(final String argSourcexliffdir) {
        fSourcexliffdir = argSourcexliffdir;
    }

    /**
     * フィールド [sourcexliffdir] の値を取得します。
     *
     * フィールドの説明: [エクスポート元となる XLIFF が格納されたディレクトリ。]。
     *
     * @return フィールド[sourcexliffdir]から取得した値。
     */
    public String getSourcexliffdir() {
        return fSourcexliffdir;
    }

    /**
     * フィールド [sourcehtmldir] の値を設定します。
     *
     * フィールドの説明: [エクスポート元となる HTML が格納されたディレクトリ。]。
     *
     * @param argSourcehtmldir フィールド[sourcehtmldir]に設定する値。
     */
    public void setSourcehtmldir(final String argSourcehtmldir) {
        fSourcehtmldir = argSourcehtmldir;
    }

    /**
     * フィールド [sourcehtmldir] の値を取得します。
     *
     * フィールドの説明: [エクスポート元となる HTML が格納されたディレクトリ。]。
     *
     * @return フィールド[sourcehtmldir]から取得した値。
     */
    public String getSourcehtmldir() {
        return fSourcehtmldir;
    }

    /**
     * フィールド [targetdir] の値を設定します。
     *
     * フィールドの説明: [エクスポート先となる HTML を格納するディレクトリ。]。
     *
     * @param argTargetdir フィールド[targetdir]に設定する値。
     */
    public void setTargetdir(final String argTargetdir) {
        fTargetdir = argTargetdir;
    }

    /**
     * フィールド [targetdir] の値を取得します。
     *
     * フィールドの説明: [エクスポート先となる HTML を格納するディレクトリ。]。
     *
     * @return フィールド[targetdir]から取得した値。
     */
    public String getTargetdir() {
        return fTargetdir;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.filter.core.valueobject.BentenExportHtmlProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",sourcexliffdir=" + fSourcexliffdir);
        buf.append(",sourcehtmldir=" + fSourcehtmldir);
        buf.append(",targetdir=" + fTargetdir);
        buf.append("]");
        return buf.toString();
    }
}
