/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.preference;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * 設定ページ基底クラス。
 *
 * <UL>
 * <LI>プレファランスとプロジェクト設定を共通化するための設定ページ・クラスです。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
public abstract class AbstractPreferencePage extends PreferencePage implements IWorkbenchPreferencePage {

	/**
	 * コンストラクター。
	 */
	public AbstractPreferencePage() {
	}

	/**
	 * コンストラクター。
	 * @param title タイトル
	 */
	public AbstractPreferencePage(final String title) {
		super(title);
	}

	/**
	 * コンストラクター。
	 * @param title タイトル
	 * @param image イメージ
	 */
	public AbstractPreferencePage(final String title, final ImageDescriptor image) {
		super(title, image);
	}

	@Override
	protected IPreferenceStore doGetPreferenceStore() {
		return BentenPreference.getStore();
	}

	/**
	 * コントロールの有効化。
	 *
	 * @param enabled 有効化する場合は true
	 */
	abstract protected void setEnabled(final boolean enabled);

	@Override
	abstract protected Control createContents(final Composite parent);

	@Override
	abstract protected void performDefaults();

	@Override
	abstract public boolean performOk();
}
