/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.fields;

import java.io.File;

/**
 * 参照ボタンを持つテキスト・フィールド。
 *
 * <UL>
 * <LI>ファイルなどのリソース参照ボタンを持つテキスト・フィールドのインターフェースです。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
public interface IBrowseTextField {

	/**
	 * ラベル・テキストの取得。
	 * @return ラベル・テキスト
	 */
	String getLabelText();

	/**
	 * ファイルの取得。
	 * @return ファイル
	 */
	File getFile();

	/**
	 * テキストの取得。
	 * @return テキスト
	 */
	String getText();

	/**
	 * テキストのセット。
	 * @param text テキスト
	 */
	void setText(String text);
}
