/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.core.dom.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten コアの DOM のためのメッセージ。
 *
 * リソースバンドル定義: [BentenCoreDomMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenCoreDomMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenCoreDomMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenCoreDomMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenCoreDomMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/core/dom/messages/BentenCoreDomMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenCoreDomMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenCoreDomMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenCoreDomMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/core/dom/messages/BentenCoreDomMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenCoreDomMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenCoreDomMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenCoreDomMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/core/dom/messages/BentenCoreDomMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenCoreDomMessages], key[TransUnitDelegate.Msg.001]
     *
     * [TransUnitDelegate#setContextGroupTmOmit: Unable to create the element &quot;context-group&quot; since both of the element &quot;target&quot; and &quot;source&quot; don't exist.] (en)<br>
     * [TransUnitDelegate#setContextGroupTmOmit: 要素 &quot;target&quot; と &quot;source&quot; の両方が存在しないので、要素 &quot;context-group&quot; を作成できません。] (ja)<br>
     *
     * @return key[TransUnitDelegate.Msg.001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getTransUnitDelegateMsg001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "TransUnitDelegate#setContextGroupTmOmit: Unable to create the element \"context-group\" since both of the element \"target\" and \"source\" don't exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TransUnitDelegate.Msg.001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenCoreDomMessages], key[TransUnitDelegate.Msg.002]
     *
     * [TransUnitDelegate#appendNote: Unable to create the element &quot;note&quot; since both of the element &quot;target&quot; and &quot;source&quot; don't exist.] (en)<br>
     * [TransUnitDelegate#appendNote: 要素 &quot;target&quot; と &quot;source&quot; の両方が存在しないので、要素 &quot;note&quot; を作成できません。] (ja)<br>
     *
     * @return key[TransUnitDelegate.Msg.002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getTransUnitDelegateMsg002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "TransUnitDelegate#appendNote: Unable to create the element \"note\" since both of the element \"target\" and \"source\" don't exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TransUnitDelegate.Msg.002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenCoreDomMessages], key[TransUnitDelegate.Msg.003]
     *
     * [TransUnitDelegate#createEmptyTarget: Unable to create the element &quot;target&quot; since the element &quot;source&quot; doesn't exist.] (en)<br>
     * [TransUnitDelegate#createEmptyTarget: 要素 &quot;source&quot; が存在しないので、要素 &quot;target&quot; を作成できません。] (ja)<br>
     *
     * @return key[TransUnitDelegate.Msg.003]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getTransUnitDelegateMsg003() {
        // 初期値として定義書の値を利用します。
        String strFormat = "TransUnitDelegate#createEmptyTarget: Unable to create the element \"target\" since the element \"source\" doesn't exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TransUnitDelegate.Msg.003");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
