/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.tmx.status;

import java.io.File;

import benten.ui.UiStatus;

/**
 * 状態をダイアログとハンドラーで共用するためのクラス。
 */
public class BentenExtractTmxFragmentStatus extends UiStatus {
    /**
     * フィールド: [targetDir]。
     */
    private File fTargetDir;

    /**
     * フィールド: [toDir]。
     */
    private File fToDir;

    /**
     * フィールド: [state]。
     */
    private String fState;

    /**
     * フィールド: [includeDate]。
     */
    private boolean fIncludeDate;

    /**
     * フィールド: [transTargetId]。
     */
    private String fTransTargetId;

    /**
     * フィールド: [transSourceLang]。
     */
    private String fTransSourceLang;

    /**
     * フィールド [targetDir] の値を設定します。
     *
     * @param argTargetDir フィールド[targetDir]に設定する値。
     */
    public void setTargetDir(final File argTargetDir) {
        fTargetDir = argTargetDir;
    }

    /**
     * フィールド [targetDir] の値を取得します。
     *
     * @return フィールド[targetDir]から取得した値。
     */
    public File getTargetDir() {
        return fTargetDir;
    }

    /**
     * フィールド [toDir] の値を設定します。
     *
     * @param argToDir フィールド[toDir]に設定する値。
     */
    public void setToDir(final File argToDir) {
        fToDir = argToDir;
    }

    /**
     * フィールド [toDir] の値を取得します。
     *
     * @return フィールド[toDir]から取得した値。
     */
    public File getToDir() {
        return fToDir;
    }

    /**
     * フィールド [state] の値を設定します。
     *
     * @param argState フィールド[state]に設定する値。
     */
    public void setState(final String argState) {
        fState = argState;
    }

    /**
     * フィールド [state] の値を取得します。
     *
     * @return フィールド[state]から取得した値。
     */
    public String getState() {
        return fState;
    }

    /**
     * フィールド [includeDate] の値を設定します。
     *
     * @param argIncludeDate フィールド[includeDate]に設定する値。
     */
    public void setIncludeDate(final boolean argIncludeDate) {
        fIncludeDate = argIncludeDate;
    }

    /**
     * フィールド [includeDate] の値を取得します。
     *
     * @return フィールド[includeDate]から取得した値。
     */
    public boolean getIncludeDate() {
        return fIncludeDate;
    }

    /**
     * フィールド [transTargetId] の値を設定します。
     *
     * @param argTransTargetId フィールド[transTargetId]に設定する値。
     */
    public void setTransTargetId(final String argTransTargetId) {
        fTransTargetId = argTransTargetId;
    }

    /**
     * フィールド [transTargetId] の値を取得します。
     *
     * @return フィールド[transTargetId]から取得した値。
     */
    public String getTransTargetId() {
        return fTransTargetId;
    }

    /**
     * フィールド [transSourceLang] の値を設定します。
     *
     * @param argTransSourceLang フィールド[transSourceLang]に設定する値。
     */
    public void setTransSourceLang(final String argTransSourceLang) {
        fTransSourceLang = argTransSourceLang;
    }

    /**
     * フィールド [transSourceLang] の値を取得します。
     *
     * @return フィールド[transSourceLang]から取得した値。
     */
    public String getTransSourceLang() {
        return fTransSourceLang;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.tmx.status.BentenExtractTmxFragmentStatus[");
        buf.append("targetDir=" + fTargetDir);
        buf.append(",toDir=" + fToDir);
        buf.append(",state=" + fState);
        buf.append(",includeDate=" + fIncludeDate);
        buf.append(",transTargetId=" + fTransTargetId);
        buf.append(",transSourceLang=" + fTransSourceLang);
        buf.append("]");
        return buf.toString();
    }
}
