/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.stat.model;

/**
 * 用語集ヒット率のためのモデル・クラス。
 */
public class GlossaryHitRateModel extends AbstractStatModel {
    /**
     * フィールド: [hit_75]。
     */
    private int fHit75;

    /**
     * フィールド: [hit_50]。
     */
    private int fHit50;

    /**
     * フィールド: [hit_25]。
     */
    private int fHit25;

    /**
     * フィールド: [hitUnder_25]。
     */
    private int fHitUnder25;

    /**
     * フィールド [hit_75] の値を設定します。
     *
     * @param argHit75 フィールド[hit_75]に設定する値。
     */
    public void setHit75(final int argHit75) {
        fHit75 = argHit75;
    }

    /**
     * フィールド [hit_75] の値を取得します。
     *
     * @return フィールド[hit_75]から取得した値。
     */
    public int getHit75() {
        return fHit75;
    }

    /**
     * フィールド [hit_50] の値を設定します。
     *
     * @param argHit50 フィールド[hit_50]に設定する値。
     */
    public void setHit50(final int argHit50) {
        fHit50 = argHit50;
    }

    /**
     * フィールド [hit_50] の値を取得します。
     *
     * @return フィールド[hit_50]から取得した値。
     */
    public int getHit50() {
        return fHit50;
    }

    /**
     * フィールド [hit_25] の値を設定します。
     *
     * @param argHit25 フィールド[hit_25]に設定する値。
     */
    public void setHit25(final int argHit25) {
        fHit25 = argHit25;
    }

    /**
     * フィールド [hit_25] の値を取得します。
     *
     * @return フィールド[hit_25]から取得した値。
     */
    public int getHit25() {
        return fHit25;
    }

    /**
     * フィールド [hitUnder_25] の値を設定します。
     *
     * @param argHitUnder25 フィールド[hitUnder_25]に設定する値。
     */
    public void setHitUnder25(final int argHitUnder25) {
        fHitUnder25 = argHitUnder25;
    }

    /**
     * フィールド [hitUnder_25] の値を取得します。
     *
     * @return フィールド[hitUnder_25]から取得した値。
     */
    public int getHitUnder25() {
        return fHitUnder25;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.cat.stat.model.GlossaryHitRateModel[");
        buf.append("hit_75=" + fHit75);
        buf.append(",hit_50=" + fHit50);
        buf.append(",hit_25=" + fHit25);
        buf.append(",hitUnder_25=" + fHitUnder25);
        buf.append("]");
        return buf.toString();
    }
}
