/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

import benten.cat.glossary.ui.CatGlossaryUiPlugin;
import benten.cat.glossary.ui.actions.messages.ShowGlossaryActionMessages;
import benten.cat.glossary.ui.views.GlossaryView;
import benten.ui.UiPlugin;
import benten.ui.UiStatus;

/**
 * 用語集表示アクション。
 *
 * <UL>
 * <LI>用語集ビューを表示するアクション・クラスです。
 * </UL>
 *
 * ★基本設計「翻訳支援機能: 用語対訳集検索機能」に対応します。
 *
 * @author YAMAMOTO Koji
 * @author KASHIHARA Shinji
 */
public class ShowGlossaryAction implements IEditorActionDelegate {

	/**
	 * 用語集検索結果を表示するビューのためのメッセージ。
	 */
	protected static final ShowGlossaryActionMessages fMsg = new ShowGlossaryActionMessages();

	/** ターゲットとなるエディター */
	private IEditorPart targetEditor;

	/** 選択 */
	private ISelection selection;

	/**
	 * {@inheritDoc}
	 */
	public void selectionChanged(final IAction action, final ISelection selection) {
		this.selection = selection;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setActiveEditor(final IAction action, final IEditorPart targetEditor) {
		this.targetEditor = targetEditor;
	}

	/**
	 * {@inheritDoc}
	 */
	public void run(final IAction action) {
		try {
			// エンジンが取得できることを予め確認。
			CatGlossaryUiPlugin.getDefault().getGlossaryEngine();
		} catch (IllegalArgumentException e) {
			final UiStatus s = new UiStatus(IStatus.ERROR, e.getMessage());
			UiPlugin.openDialog(fMsg.getMsg001(), s);
			return;
		}

		try {
			final GlossaryView view = (GlossaryView) targetEditor.getSite().getPage().showView(
					GlossaryView.class.getName());
			final ITextSelection textSelection = (ITextSelection) selection;
			view.showGlossary(textSelection.getText());
		} catch (final PartInitException e) {
			CatGlossaryUiPlugin.getDefault().log(e);
		}
	}
}
